/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.UniqueConstraint;
import java.lang.annotation.Annotation;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.AnnotationInstance;

public class UniqueConstraintJpaAnnotation
implements UniqueConstraint {
    private String name;
    private String[] columnNames;
    private String options;

    public UniqueConstraintJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.options = "";
    }

    public UniqueConstraintJpaAnnotation(UniqueConstraint annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.columnNames = annotation.columnNames();
        this.options = annotation.options();
    }

    public UniqueConstraintJpaAnnotation(AnnotationInstance annotation, SourceModelBuildingContext modelContext) {
        this.name = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.UNIQUE_CONSTRAINT, "name", modelContext);
        this.columnNames = (String[])OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.UNIQUE_CONSTRAINT, "columnNames", modelContext);
        this.options = (String)OrmAnnotationHelper.extractJandexValue(annotation, JpaAnnotations.UNIQUE_CONSTRAINT, "options", modelContext);
    }

    public Class<? extends Annotation> annotationType() {
        return UniqueConstraint.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public String[] columnNames() {
        return this.columnNames;
    }

    public void columnNames(String[] value) {
        this.columnNames = value;
    }

    public String options() {
        return this.options;
    }

    public void options(String value) {
        this.options = value;
    }
}

