/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.Transient;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.boot.models.categorize.spi.AllMemberConsumer;
import org.hibernate.boot.models.categorize.spi.ClassAttributeAccessType;
import org.hibernate.boot.models.categorize.spi.PersistentAttributeMemberResolver;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;

public abstract class AbstractPersistentAttributeMemberResolver
implements PersistentAttributeMemberResolver {
    protected abstract List<MemberDetails> resolveAttributesMembers(Function<FieldDetails, Boolean> var1, Function<MethodDetails, Boolean> var2, ClassDetails var3, ClassAttributeAccessType var4);

    @Override
    public List<MemberDetails> resolveAttributesMembers(ClassDetails classDetails, ClassAttributeAccessType classLevelAccessType, AllMemberConsumer memberConsumer) {
        HashSet transientFields = new HashSet();
        HashSet transientMethods = new HashSet();
        this.collectMembersMarkedTransient(transientFields::add, transientMethods::add, classDetails, memberConsumer);
        return this.resolveAttributesMembers(transientFields::contains, transientMethods::contains, classDetails, classLevelAccessType);
    }

    protected void collectMembersMarkedTransient(Consumer<FieldDetails> transientFieldConsumer, Consumer<MethodDetails> transientMethodConsumer, ClassDetails classDetails, AllMemberConsumer memberConsumer) {
        List fields = classDetails.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = (FieldDetails)fields.get(i);
            memberConsumer.acceptMember((MemberDetails)fieldDetails);
            if (!fieldDetails.hasDirectAnnotationUsage(Transient.class)) continue;
            transientFieldConsumer.accept(fieldDetails);
        }
        List methods = classDetails.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            MethodDetails methodDetails = (MethodDetails)methods.get(i);
            memberConsumer.acceptMember((MemberDetails)methodDetails);
            if (!methodDetails.hasDirectAnnotationUsage(Transient.class)) continue;
            transientMethodConsumer.accept(methodDetails);
        }
    }
}

