/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitDefaultsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistenceUnitMetadataImpl;
import org.hibernate.boot.models.categorize.internal.CategorizedDomainModelImpl;
import org.hibernate.boot.models.categorize.spi.CategorizedDomainModel;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.internal.GlobalRegistrationsImpl;
import org.hibernate.boot.models.spi.GlobalRegistrations;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.jandex.IndexView;

public class DomainModelCategorizationCollector {
    private final boolean areIdGeneratorsGlobal;
    private final IndexView jandexIndex;
    private final GlobalRegistrationsImpl globalRegistrations;
    private final SourceModelBuildingContext modelsContext;
    private final Set<ClassDetails> rootEntities = new HashSet<ClassDetails>();
    private final Map<String, ClassDetails> mappedSuperclasses = new HashMap<String, ClassDetails>();
    private final Map<String, ClassDetails> embeddables = new HashMap<String, ClassDetails>();

    public DomainModelCategorizationCollector(boolean areIdGeneratorsGlobal, GlobalRegistrations globalRegistrations, IndexView jandexIndex, SourceModelBuildingContext modelsContext) {
        this.areIdGeneratorsGlobal = areIdGeneratorsGlobal;
        this.jandexIndex = jandexIndex;
        this.globalRegistrations = (GlobalRegistrationsImpl)globalRegistrations;
        this.modelsContext = modelsContext;
    }

    public GlobalRegistrationsImpl getGlobalRegistrations() {
        return this.globalRegistrations;
    }

    public Set<ClassDetails> getRootEntities() {
        return this.rootEntities;
    }

    public Map<String, ClassDetails> getMappedSuperclasses() {
        return this.mappedSuperclasses;
    }

    public Map<String, ClassDetails> getEmbeddables() {
        return this.embeddables;
    }

    public void apply(JaxbEntityMappingsImpl jaxbRoot, XmlDocumentContext xmlDocumentContext) {
        JaxbEntityListenerContainerImpl listenerContainer;
        JaxbPersistenceUnitDefaultsImpl persistenceUnitDefaults;
        this.getGlobalRegistrations().collectJavaTypeRegistrations(jaxbRoot.getJavaTypeRegistrations());
        this.getGlobalRegistrations().collectJdbcTypeRegistrations(jaxbRoot.getJdbcTypeRegistrations());
        this.getGlobalRegistrations().collectConverterRegistrations(jaxbRoot.getConverterRegistrations());
        this.getGlobalRegistrations().collectConverters(jaxbRoot.getConverters());
        this.getGlobalRegistrations().collectUserTypeRegistrations(jaxbRoot.getUserTypeRegistrations());
        this.getGlobalRegistrations().collectCompositeUserTypeRegistrations(jaxbRoot.getCompositeUserTypeRegistrations());
        this.getGlobalRegistrations().collectCollectionTypeRegistrations(jaxbRoot.getCollectionUserTypeRegistrations());
        this.getGlobalRegistrations().collectEmbeddableInstantiatorRegistrations(jaxbRoot.getEmbeddableInstantiatorRegistrations());
        this.getGlobalRegistrations().collectFilterDefinitions(jaxbRoot.getFilterDefinitions());
        JaxbPersistenceUnitMetadataImpl persistenceUnitMetadata = jaxbRoot.getPersistenceUnitMetadata();
        if (persistenceUnitMetadata != null && (persistenceUnitDefaults = persistenceUnitMetadata.getPersistenceUnitDefaults()) != null && (listenerContainer = persistenceUnitDefaults.getEntityListenerContainer()) != null) {
            this.getGlobalRegistrations().collectEntityListenerRegistrations(listenerContainer.getEntityListeners(), this.modelsContext);
        }
        this.getGlobalRegistrations().collectIdGenerators(jaxbRoot);
        this.getGlobalRegistrations().collectQueryReferences(jaxbRoot, xmlDocumentContext);
    }

    public void apply(ClassDetails classDetails) {
        this.getGlobalRegistrations().collectJavaTypeRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectJdbcTypeRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectConverterRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectUserTypeRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectCompositeUserTypeRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectCollectionTypeRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectEmbeddableInstantiatorRegistrations((AnnotationTarget)classDetails);
        this.getGlobalRegistrations().collectFilterDefinitions((AnnotationTarget)classDetails);
        if (this.areIdGeneratorsGlobal) {
            this.getGlobalRegistrations().collectIdGenerators(classDetails);
        }
        this.getGlobalRegistrations().collectImportRename(classDetails);
        if (classDetails.getDirectAnnotationUsage(MappedSuperclass.class) != null) {
            if (classDetails.getClassName() != null) {
                this.mappedSuperclasses.put(classDetails.getClassName(), classDetails);
            }
        } else if (classDetails.getDirectAnnotationUsage(Entity.class) != null) {
            if (DomainModelCategorizationCollector.isRootEntity(classDetails)) {
                this.rootEntities.add(classDetails);
            }
        } else if (classDetails.getDirectAnnotationUsage(Embeddable.class) != null && classDetails.getClassName() != null) {
            this.embeddables.put(classDetails.getClassName(), classDetails);
        }
        if (classDetails.getClassName() != null && classDetails.isImplementor(AttributeConverter.class) || classDetails.getDirectAnnotationUsage(Converter.class) != null) {
            this.globalRegistrations.collectConverter(classDetails);
        }
    }

    public static boolean isRootEntity(ClassDetails classInfo) {
        if (classInfo.getSuperClass() == null) {
            return true;
        }
        for (ClassDetails current = classInfo.getSuperClass(); current != null; current = current.getSuperClass()) {
            if (!current.hasDirectAnnotationUsage(Entity.class) || current.isAbstract()) continue;
            return false;
        }
        return true;
    }

    public CategorizedDomainModel createResult(Set<EntityHierarchy> entityHierarchies, PersistenceUnitMetadata persistenceUnitMetadata, ClassDetailsRegistry classDetailsRegistry, AnnotationDescriptorRegistry annotationDescriptorRegistry) {
        return new CategorizedDomainModelImpl(classDetailsRegistry, annotationDescriptorRegistry, this.jandexIndex, persistenceUnitMetadata, entityHierarchies, this.mappedSuperclasses, this.embeddables, this.getGlobalRegistrations());
    }
}

