/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.BigDecimalJavaType;
import org.hibernate.type.descriptor.java.BigIntegerJavaType;
import org.hibernate.type.descriptor.java.BlobJavaType;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.CalendarJavaType;
import org.hibernate.type.descriptor.java.CharacterJavaType;
import org.hibernate.type.descriptor.java.ClassJavaType;
import org.hibernate.type.descriptor.java.ClobJavaType;
import org.hibernate.type.descriptor.java.CurrencyJavaType;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.DurationJavaType;
import org.hibernate.type.descriptor.java.FloatJavaType;
import org.hibernate.type.descriptor.java.InetAddressJavaType;
import org.hibernate.type.descriptor.java.InstantJavaType;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JdbcDateJavaType;
import org.hibernate.type.descriptor.java.JdbcTimeJavaType;
import org.hibernate.type.descriptor.java.JdbcTimestampJavaType;
import org.hibernate.type.descriptor.java.LocalDateJavaType;
import org.hibernate.type.descriptor.java.LocalDateTimeJavaType;
import org.hibernate.type.descriptor.java.LocalTimeJavaType;
import org.hibernate.type.descriptor.java.LocaleJavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.java.NClobJavaType;
import org.hibernate.type.descriptor.java.OffsetDateTimeJavaType;
import org.hibernate.type.descriptor.java.OffsetTimeJavaType;
import org.hibernate.type.descriptor.java.ShortJavaType;
import org.hibernate.type.descriptor.java.StringJavaType;
import org.hibernate.type.descriptor.java.TimeZoneJavaType;
import org.hibernate.type.descriptor.java.UUIDJavaType;
import org.hibernate.type.descriptor.java.UrlJavaType;
import org.hibernate.type.descriptor.java.YearJavaType;
import org.hibernate.type.descriptor.java.ZoneIdJavaType;
import org.hibernate.type.descriptor.java.ZoneOffsetJavaType;
import org.hibernate.type.descriptor.java.ZonedDateTimeJavaType;

public final class SimpleTypeInterpretation
extends Enum<SimpleTypeInterpretation> {
    public static final /* enum */ SimpleTypeInterpretation BOOLEAN = new SimpleTypeInterpretation(Boolean.class, BooleanJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation BYTE = new SimpleTypeInterpretation(Byte.class, ByteJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation SHORT = new SimpleTypeInterpretation(Short.class, ShortJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation INTEGER = new SimpleTypeInterpretation(Integer.class, IntegerJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation LONG = new SimpleTypeInterpretation(Long.class, LongJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation DOUBLE = new SimpleTypeInterpretation(Double.class, DoubleJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation FLOAT = new SimpleTypeInterpretation(Float.class, FloatJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation BIG_INTEGER = new SimpleTypeInterpretation(BigInteger.class, BigIntegerJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation BIG_DECIMAL = new SimpleTypeInterpretation(BigDecimal.class, BigDecimalJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation CHARACTER = new SimpleTypeInterpretation(Character.class, CharacterJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation STRING = new SimpleTypeInterpretation(String.class, StringJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation INSTANT = new SimpleTypeInterpretation(Instant.class, InstantJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation DURATION = new SimpleTypeInterpretation(Duration.class, DurationJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation YEAR = new SimpleTypeInterpretation(Year.class, YearJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation LOCAL_DATE_TIME = new SimpleTypeInterpretation(LocalDateTime.class, LocalDateTimeJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation LOCAL_DATE = new SimpleTypeInterpretation(LocalDate.class, LocalDateJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation LOCAL_TIME = new SimpleTypeInterpretation(LocalTime.class, LocalTimeJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation OFFSET_DATE_TIME = new SimpleTypeInterpretation(OffsetDateTime.class, OffsetDateTimeJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation OFFSET_TIME = new SimpleTypeInterpretation(OffsetTime.class, OffsetTimeJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation ZONED_DATE_TIME = new SimpleTypeInterpretation(ZonedDateTime.class, ZonedDateTimeJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation ZONE_ID = new SimpleTypeInterpretation(ZoneId.class, ZoneIdJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation ZONE_OFFSET = new SimpleTypeInterpretation(ZoneOffset.class, ZoneOffsetJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation UUID = new SimpleTypeInterpretation(UUID.class, UUIDJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation URL = new SimpleTypeInterpretation(URL.class, UrlJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation INET_ADDRESS = new SimpleTypeInterpretation(InetAddress.class, InetAddressJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation CURRENCY = new SimpleTypeInterpretation(Currency.class, CurrencyJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation LOCALE = new SimpleTypeInterpretation(Locale.class, LocaleJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation CLASS = new SimpleTypeInterpretation(Class.class, ClassJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation BLOB = new SimpleTypeInterpretation(Blob.class, BlobJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation CLOB = new SimpleTypeInterpretation(Clob.class, ClobJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation NCLOB = new SimpleTypeInterpretation(NClob.class, NClobJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation JDBC_TIMESTAMP = new SimpleTypeInterpretation(Timestamp.class, JdbcTimestampJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation JDBC_DATE = new SimpleTypeInterpretation(Date.class, JdbcDateJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation JDBC_TIME = new SimpleTypeInterpretation(Time.class, JdbcTimeJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation CALENDAR = new SimpleTypeInterpretation(Calendar.class, CalendarJavaType.class);
    public static final /* enum */ SimpleTypeInterpretation TIME_ZONE = new SimpleTypeInterpretation(TimeZone.class, TimeZoneJavaType.class);
    private final Class<?> javaType;
    private final Class<? extends BasicJavaType<?>> javaTypeDescriptorType;
    private static final /* synthetic */ SimpleTypeInterpretation[] $VALUES;

    public static SimpleTypeInterpretation[] values() {
        return (SimpleTypeInterpretation[])$VALUES.clone();
    }

    public static SimpleTypeInterpretation valueOf(String name) {
        return Enum.valueOf(SimpleTypeInterpretation.class, name);
    }

    private SimpleTypeInterpretation(Class<?> javaType, Class<? extends BasicJavaType<?>> javaTypeDescriptorType) {
        this.javaType = javaType;
        this.javaTypeDescriptorType = javaTypeDescriptorType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Class<? extends BasicJavaType<?>> getJavaTypeDescriptorType() {
        return this.javaTypeDescriptorType;
    }

    public static SimpleTypeInterpretation interpret(String name) {
        assert (StringHelper.isNotEmpty(name));
        if (name.equalsIgnoreCase("boolean") || Boolean.class.getName().equals(name)) {
            return BOOLEAN;
        }
        if (name.equalsIgnoreCase("byte") || Byte.class.getName().equals(name)) {
            return BYTE;
        }
        if (name.equalsIgnoreCase("short") || Short.class.getName().equals(name)) {
            return SHORT;
        }
        if (name.equalsIgnoreCase("int") || name.equalsIgnoreCase("integer") || Integer.class.getName().equals(name)) {
            return INTEGER;
        }
        if (name.equalsIgnoreCase("long") || Long.class.getName().equals(name)) {
            return LONG;
        }
        if (name.equalsIgnoreCase("double") || Double.class.getName().equals(name)) {
            return DOUBLE;
        }
        if (name.equalsIgnoreCase("float") || Float.class.getName().equals(name)) {
            return FLOAT;
        }
        if (name.equalsIgnoreCase("biginteger") || name.equalsIgnoreCase("big_integer") || BigInteger.class.getName().equals(name)) {
            return BIG_INTEGER;
        }
        if (name.equalsIgnoreCase("bigdecimal") || name.equalsIgnoreCase("big_decimal") || BigDecimal.class.getName().equals(name)) {
            return BIG_DECIMAL;
        }
        if (name.equalsIgnoreCase("char") || name.equalsIgnoreCase("character") || Character.class.getName().equalsIgnoreCase(name)) {
            return CHARACTER;
        }
        if (name.equalsIgnoreCase("string") || String.class.getName().equalsIgnoreCase(name)) {
            return STRING;
        }
        if (name.equalsIgnoreCase("instant") || Instant.class.getName().equals(name)) {
            return INSTANT;
        }
        if (name.equalsIgnoreCase("duration") || Duration.class.getName().equals(name)) {
            return DURATION;
        }
        if (name.equalsIgnoreCase("year") || Year.class.getName().equals(name)) {
            return YEAR;
        }
        if (name.equalsIgnoreCase("localdatetime") || name.equalsIgnoreCase("local_date_time") || LocalDateTime.class.getName().equals(name)) {
            return LOCAL_DATE_TIME;
        }
        if (name.equalsIgnoreCase("localdate") || name.equalsIgnoreCase("local_date") || LocalDate.class.getName().equals(name)) {
            return LOCAL_DATE;
        }
        if (name.equalsIgnoreCase("localtime") || name.equalsIgnoreCase("local_time") || LocalTime.class.getName().equals(name)) {
            return LOCAL_TIME;
        }
        if (name.equalsIgnoreCase("zoneddatetime") || name.equalsIgnoreCase("zoned_date_time") || ZonedDateTime.class.getName().equals(name)) {
            return ZONED_DATE_TIME;
        }
        if (name.equalsIgnoreCase("offsetdatetime") || name.equalsIgnoreCase("offset_date_time") || OffsetDateTime.class.getName().equals(name)) {
            return OFFSET_DATE_TIME;
        }
        if (name.equalsIgnoreCase("offsettime") || name.equalsIgnoreCase("offset_time") || OffsetTime.class.getName().equals(name)) {
            return OFFSET_TIME;
        }
        if (name.equalsIgnoreCase("zoneid") || name.equalsIgnoreCase("zone_id") || ZoneId.class.getName().equals(name)) {
            return ZONE_ID;
        }
        if (name.equalsIgnoreCase("zoneoffset") || name.equalsIgnoreCase("zone_offset") || ZoneOffset.class.getName().equals(name)) {
            return ZONE_OFFSET;
        }
        if (name.equalsIgnoreCase("uuid") || UUID.class.getName().equals(name)) {
            return UUID;
        }
        if (name.equalsIgnoreCase("url") || URL.class.getName().equals(name)) {
            return URL;
        }
        if (name.equalsIgnoreCase("inet") || name.equalsIgnoreCase("inetaddress") || name.equalsIgnoreCase("inet_address") || InetAddress.class.getName().equals(name)) {
            return INET_ADDRESS;
        }
        if (name.equalsIgnoreCase("currency") || Currency.class.getName().equals(name)) {
            return CURRENCY;
        }
        if (name.equalsIgnoreCase("locale") || Locale.class.getName().equals(name)) {
            return LOCALE;
        }
        if (name.equalsIgnoreCase("class") || Class.class.getName().equals(name)) {
            return CLASS;
        }
        if (name.equalsIgnoreCase("blob") || Blob.class.getName().equals(name)) {
            return BLOB;
        }
        if (name.equalsIgnoreCase("clob") || Clob.class.getName().equals(name)) {
            return CLOB;
        }
        if (name.equalsIgnoreCase("nclob") || NClob.class.getName().equals(name)) {
            return NCLOB;
        }
        if (name.equalsIgnoreCase("timestamp") || name.equalsIgnoreCase("time_stamp") || java.util.Date.class.getName().equals(name) || Timestamp.class.getName().equals(name)) {
            return JDBC_TIMESTAMP;
        }
        if (name.equalsIgnoreCase("date") || Date.class.getName().equals(name)) {
            return JDBC_DATE;
        }
        if (name.equalsIgnoreCase("time") || Time.class.getName().equals(name)) {
            return JDBC_TIME;
        }
        if (name.equalsIgnoreCase("calendar") || name.equalsIgnoreCase("gregoriancalendar") || name.equalsIgnoreCase("gregorian_calendar") || Calendar.class.getName().equals(name) || GregorianCalendar.class.getName().equals(name)) {
            return CALENDAR;
        }
        if (name.equalsIgnoreCase("timezone") || name.equalsIgnoreCase("time_zone") || TimeZone.class.getName().equals(name)) {
            return TIME_ZONE;
        }
        return null;
    }

    private static /* synthetic */ SimpleTypeInterpretation[] $values() {
        return new SimpleTypeInterpretation[]{BOOLEAN, BYTE, SHORT, INTEGER, LONG, DOUBLE, FLOAT, BIG_INTEGER, BIG_DECIMAL, CHARACTER, STRING, INSTANT, DURATION, YEAR, LOCAL_DATE_TIME, LOCAL_DATE, LOCAL_TIME, OFFSET_DATE_TIME, OFFSET_TIME, ZONED_DATE_TIME, ZONE_ID, ZONE_OFFSET, UUID, URL, INET_ADDRESS, CURRENCY, LOCALE, CLASS, BLOB, CLOB, NCLOB, JDBC_TIMESTAMP, JDBC_DATE, JDBC_TIME, CALENDAR, TIME_ZONE};
    }

    static {
        $VALUES = SimpleTypeInterpretation.$values();
    }
}

