/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.spi;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.HibernateException;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAssociationAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistentAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.boot.spi.EffectiveMappingDefaults;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.usertype.UserType;

public interface XmlDocumentContext {
    public XmlDocument getXmlDocument();

    public EffectiveMappingDefaults getEffectiveDefaults();

    public SourceModelBuildingContext getModelBuildingContext();

    public BootstrapContext getBootstrapContext();

    default public MutableClassDetails resolveJavaType(String name) {
        try {
            return (MutableClassDetails)XmlAnnotationHelper.resolveJavaType(name, this);
        }
        catch (Exception e) {
            HibernateException hibernateException = new HibernateException("Unable to resolve Java type " + name);
            hibernateException.addSuppressed(e);
            throw hibernateException;
        }
    }

    default public MutableClassDetails resolveDynamicJavaType(JaxbPersistentAttribute jaxbPersistentAttribute) {
        JaxbAssociationAttribute jaxbAssociationAttribute;
        JaxbEmbeddedMapping jaxbEmbeddedMapping;
        String target;
        if (jaxbPersistentAttribute instanceof JaxbBasicMapping) {
            JdbcType jdbcType;
            String userTypeImplName;
            JaxbBasicMapping jaxbBasicMapping = (JaxbBasicMapping)((Object)jaxbPersistentAttribute);
            target = jaxbBasicMapping.getTarget();
            if (StringHelper.isNotEmpty(target)) {
                return (MutableClassDetails)XmlAnnotationHelper.resolveJavaType(target, this);
            }
            JaxbUserTypeImpl userTypeNode = jaxbBasicMapping.getType();
            if (userTypeNode != null && StringHelper.isNotEmpty(userTypeImplName = userTypeNode.getValue())) {
                ClassDetails userTypeImplDetails = XmlAnnotationHelper.resolveJavaType(userTypeImplName, this);
                UserType userType = (UserType)this.createInstance(userTypeImplDetails);
                Class modelClass = userType.returnedClass();
                return (MutableClassDetails)this.getModelBuildingContext().getClassDetailsRegistry().getClassDetails(modelClass.getName());
            }
            String javaTypeImplName = jaxbBasicMapping.getJavaType();
            if (StringHelper.isNotEmpty(javaTypeImplName)) {
                ClassDetails javaTypeImplDetails = XmlAnnotationHelper.resolveJavaType(javaTypeImplName, this);
                JavaType javaType = (JavaType)this.createInstance(javaTypeImplDetails);
                Class modelClass = javaType.getJavaTypeClass();
                return (MutableClassDetails)this.getModelBuildingContext().getClassDetailsRegistry().getClassDetails(modelClass.getName());
            }
            String jdbcTypeImplName = jaxbBasicMapping.getJdbcType();
            Integer jdbcTypeCode = jaxbBasicMapping.getJdbcTypeCode();
            if (StringHelper.isNotEmpty(jdbcTypeImplName)) {
                ClassDetails jdbcTypeImplDetails = XmlAnnotationHelper.resolveJavaType(javaTypeImplName, this);
                jdbcType = (JdbcType)this.createInstance(jdbcTypeImplDetails);
            } else {
                jdbcType = jdbcTypeCode != null ? this.getBootstrapContext().getTypeConfiguration().getJdbcTypeRegistry().getDescriptor(jdbcTypeCode) : null;
            }
            if (jdbcType != null) {
                JavaType javaType = jdbcType.getJdbcRecommendedJavaTypeMapping(0, 0, this.getBootstrapContext().getTypeConfiguration());
                Class modelClass = javaType.getJavaTypeClass();
                return (MutableClassDetails)this.getModelBuildingContext().getClassDetailsRegistry().getClassDetails(modelClass.getName());
            }
        }
        if (jaxbPersistentAttribute instanceof JaxbEmbeddedMapping && StringHelper.isNotEmpty(target = (jaxbEmbeddedMapping = (JaxbEmbeddedMapping)jaxbPersistentAttribute).getTarget())) {
            return (MutableClassDetails)this.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(target, name -> new DynamicClassDetails(target, this.getModelBuildingContext()));
        }
        if (jaxbPersistentAttribute instanceof JaxbAssociationAttribute && StringHelper.isNotEmpty(target = (jaxbAssociationAttribute = (JaxbAssociationAttribute)jaxbPersistentAttribute).getTargetEntity())) {
            return (MutableClassDetails)this.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(target, name -> new DynamicClassDetails(target, null, false, null, null, this.getModelBuildingContext()));
        }
        if (jaxbPersistentAttribute instanceof JaxbAnyMapping) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        if (jaxbPersistentAttribute instanceof JaxbPluralAttribute) {
            JaxbPluralAttribute jaxbPluralAttribute = (JaxbPluralAttribute)jaxbPersistentAttribute;
            LimitedCollectionClassification classification = NullnessHelper.nullif(jaxbPluralAttribute.getClassification(), LimitedCollectionClassification.BAG);
            return switch (classification) {
                default -> throw new IncompatibleClassChangeError();
                case LimitedCollectionClassification.BAG -> this.resolveJavaType(Collection.class.getName());
                case LimitedCollectionClassification.LIST -> this.resolveJavaType(List.class.getName());
                case LimitedCollectionClassification.SET -> this.resolveJavaType(Set.class.getName());
                case LimitedCollectionClassification.MAP -> this.resolveJavaType(Map.class.getName());
            };
        }
        throw new HibernateException("Could not determine target type for dynamic attribute - " + jaxbPersistentAttribute.getName());
    }

    private <T> @NonNull T createInstance(ClassDetails classDetails) {
        try {
            return classDetails.toJavaClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new HibernateException("Unable to create instance from incoming ClassDetails - " + classDetails);
        }
    }

    default public String resolveClassName(String specifiedName) {
        if (specifiedName.contains(".")) {
            return specifiedName;
        }
        return StringHelper.qualifyConditionallyIfNot(this.getXmlDocument().getDefaults().getPackage(), specifiedName);
    }
}

