/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.boot.internal.NamedNativeQueryDefinitionImpl;
import org.hibernate.boot.query.AbstractNamedQueryBuilder;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sql.spi.NamedNativeQueryMemento;

public interface NamedNativeQueryDefinition<E>
extends NamedQueryDefinition<E> {
    public String getSqlQueryString();

    public String getResultSetMappingName();

    @Override
    public NamedNativeQueryMemento<E> resolve(SessionFactoryImplementor var1);

    public static class Builder<E>
    extends AbstractNamedQueryBuilder<E, Builder<E>> {
        private String sqlString;
        private String resultSetMappingName;
        private Set<String> querySpaces;
        private Map<String, String> parameterTypes;
        private Integer firstResult;
        private Integer maxResults;

        public Builder(String name) {
            super(name);
        }

        public Builder<E> setSqlString(String sqlString) {
            this.sqlString = sqlString;
            return this.getThis();
        }

        public Builder<E> setFirstResult(Integer firstResult) {
            this.firstResult = firstResult;
            return this.getThis();
        }

        public Builder<E> setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this.getThis();
        }

        public NamedNativeQueryDefinition<E> build() {
            return new NamedNativeQueryDefinitionImpl(this.getName(), this.getResultClass(), this.sqlString, this.resultSetMappingName, this.getQuerySpaces(), this.getCacheable(), this.getCacheRegion(), this.getCacheMode(), this.getFlushMode(), this.getReadOnly(), this.getTimeout(), this.getFetchSize(), this.getComment(), this.firstResult, this.maxResults, this.getHints());
        }

        @Override
        protected Builder<E> getThis() {
            return this;
        }

        public String getSqlString() {
            return this.sqlString;
        }

        public Set<String> getQuerySpaces() {
            return this.querySpaces;
        }

        public Map<String, String> getParameterTypes() {
            return this.parameterTypes == null ? Collections.emptyMap() : this.parameterTypes;
        }

        public String getResultSetMappingName() {
            return this.resultSetMappingName;
        }

        public Builder<E> addSynchronizedQuerySpace(String space) {
            if (this.querySpaces == null) {
                this.querySpaces = new HashSet<String>();
            }
            this.querySpaces.add(space);
            return this.getThis();
        }

        public Builder<E> setQuerySpaces(Set<String> spaces) {
            this.querySpaces = spaces;
            return this;
        }

        public Builder<E> setResultSetMappingName(String resultSetMappingName) {
            this.resultSetMappingName = resultSetMappingName;
            return this;
        }

        public void addParameterTypeHint(String name, String type) {
            if (this.parameterTypes == null) {
                this.parameterTypes = new HashMap<String, String>();
            }
            this.parameterTypes.put(name, type);
        }
    }
}

