/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.SharedCacheMode;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Interceptor;
import org.hibernate.Internal;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.internal.ClassmateContext;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.internal.InstanceBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.ColumnOrderingStrategy;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.NamedResultSetMappingDescriptor;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.XmlMappingBinderAccess;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.EmptyInterceptor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.UserType;

public class Configuration {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(Configuration.class);
    private final BootstrapServiceRegistry bootstrapServiceRegistry;
    private final MetadataSources metadataSources;
    private final StandardServiceRegistryBuilder standardServiceRegistryBuilder;
    private final ClassmateContext classmateContext = new ClassmateContext();
    private ImplicitNamingStrategy implicitNamingStrategy;
    private PhysicalNamingStrategy physicalNamingStrategy;
    private final List<BasicType<?>> basicTypes = new ArrayList();
    private List<UserTypeRegistration> userTypeRegistrations;
    private final List<TypeContributor> typeContributorRegistrations = new ArrayList<TypeContributor>();
    private final List<FunctionContributor> functionContributorRegistrations = new ArrayList<FunctionContributor>();
    private final Map<String, NamedHqlQueryDefinition<?>> namedQueries = new HashMap();
    private final Map<String, NamedNativeQueryDefinition<?>> namedSqlQueries = new HashMap();
    private final Map<String, NamedProcedureCallDefinition> namedProcedureCallMap = new HashMap<String, NamedProcedureCallDefinition>();
    private final Map<String, NamedResultSetMappingDescriptor> sqlResultSetMappings = new HashMap<String, NamedResultSetMappingDescriptor>();
    private final Map<String, NamedEntityGraphDefinition> namedEntityGraphMap = new HashMap<String, NamedEntityGraphDefinition>();
    private Map<String, SqmFunctionDescriptor> customFunctionDescriptors;
    private List<AuxiliaryDatabaseObject> auxiliaryDatabaseObjectList;
    private HashMap<Class<?>, ConverterDescriptor> attributeConverterDescriptorsByClass;
    private List<EntityNameResolver> entityNameResolvers = new ArrayList<EntityNameResolver>();
    private Properties properties = new Properties();
    private Interceptor interceptor = EmptyInterceptor.INSTANCE;
    private EntityNotFoundDelegate entityNotFoundDelegate;
    private SessionFactoryObserver sessionFactoryObserver;
    private StatementInspector statementInspector;
    private CurrentTenantIdentifierResolver<Object> currentTenantIdentifierResolver;
    private CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
    private ColumnOrderingStrategy columnOrderingStrategy;
    private SharedCacheMode sharedCacheMode;

    public Configuration() {
        this(new BootstrapServiceRegistryBuilder().build());
    }

    public Configuration(BootstrapServiceRegistry serviceRegistry) {
        this.bootstrapServiceRegistry = serviceRegistry;
        this.metadataSources = new MetadataSources(serviceRegistry, this.createMappingBinderAccess(serviceRegistry));
        this.standardServiceRegistryBuilder = new StandardServiceRegistryBuilder(this.bootstrapServiceRegistry);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
    }

    private XmlMappingBinderAccess createMappingBinderAccess(BootstrapServiceRegistry serviceRegistry) {
        return new XmlMappingBinderAccess(serviceRegistry, settingName -> this.properties == null ? null : this.properties.get(settingName));
    }

    public Configuration(MetadataSources metadataSources) {
        this.metadataSources = metadataSources;
        this.bootstrapServiceRegistry = Configuration.getBootstrapRegistry(metadataSources.getServiceRegistry());
        this.standardServiceRegistryBuilder = new StandardServiceRegistryBuilder(this.bootstrapServiceRegistry);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
    }

    private static BootstrapServiceRegistry getBootstrapRegistry(ServiceRegistry serviceRegistry) {
        if (serviceRegistry instanceof BootstrapServiceRegistry) {
            return (BootstrapServiceRegistry)serviceRegistry;
        }
        if (serviceRegistry instanceof StandardServiceRegistry) {
            StandardServiceRegistry ssr = (StandardServiceRegistry)serviceRegistry;
            return (BootstrapServiceRegistry)ssr.getParentServiceRegistry();
        }
        throw new HibernateException("No ServiceRegistry was passed to Configuration#buildSessionFactory and could not determine how to locate BootstrapServiceRegistry from Configuration instantiation");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Configuration setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getProperty(String propertyName) {
        Object o = this.properties.get(propertyName);
        return o instanceof String ? (String)o : null;
    }

    public Configuration setProperty(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
        return this;
    }

    public Configuration setProperty(String propertyName, boolean value) {
        return this.setProperty(propertyName, Boolean.toString(value));
    }

    public Configuration setProperty(String propertyName, Class<?> value) {
        return this.setProperty(propertyName, value.getName());
    }

    public Configuration setProperty(String propertyName, Enum<?> value) {
        return this.setProperty(propertyName, value.name());
    }

    public Configuration setProperty(String propertyName, int value) {
        return this.setProperty(propertyName, Integer.toString(value));
    }

    public Configuration addProperties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public ImplicitNamingStrategy getImplicitNamingStrategy() {
        return this.implicitNamingStrategy;
    }

    public Configuration setImplicitNamingStrategy(ImplicitNamingStrategy implicitNamingStrategy) {
        this.implicitNamingStrategy = implicitNamingStrategy;
        return this;
    }

    public PhysicalNamingStrategy getPhysicalNamingStrategy() {
        return this.physicalNamingStrategy;
    }

    public Configuration setPhysicalNamingStrategy(PhysicalNamingStrategy physicalNamingStrategy) {
        this.physicalNamingStrategy = physicalNamingStrategy;
        return this;
    }

    public Configuration configure() throws HibernateException {
        return this.configure("hibernate.cfg.xml");
    }

    public Configuration configure(String resource) throws HibernateException {
        this.standardServiceRegistryBuilder.configure(resource);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
        return this;
    }

    @Internal
    public StandardServiceRegistryBuilder getStandardServiceRegistryBuilder() {
        return this.standardServiceRegistryBuilder;
    }

    public Configuration configure(URL url) throws HibernateException {
        this.standardServiceRegistryBuilder.configure(url);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
        return this;
    }

    public Configuration configure(File configFile) throws HibernateException {
        this.standardServiceRegistryBuilder.configure(configFile);
        this.properties.putAll(this.standardServiceRegistryBuilder.getSettings());
        return this;
    }

    public Configuration registerTypeContributor(TypeContributor typeContributor) {
        this.typeContributorRegistrations.add(typeContributor);
        return this;
    }

    public Configuration registerFunctionContributor(FunctionContributor functionContributor) {
        this.functionContributorRegistrations.add(functionContributor);
        return this;
    }

    public Configuration registerTypeOverride(BasicType<?> type) {
        this.basicTypes.add(type);
        return this;
    }

    public Configuration registerTypeOverride(UserType<?> type, String[] keys) {
        if (this.userTypeRegistrations == null) {
            this.userTypeRegistrations = new ArrayList<UserTypeRegistration>();
        }
        this.userTypeRegistrations.add(metadataBuilder -> metadataBuilder.applyBasicType(type, keys));
        return this;
    }

    public Configuration addFile(String xmlFile) throws MappingException {
        this.metadataSources.addFile(xmlFile);
        return this;
    }

    public Configuration addFile(File xmlFile) throws MappingException {
        this.metadataSources.addFile(xmlFile);
        return this;
    }

    public XmlMappingBinderAccess getXmlMappingBinderAccess() {
        return this.metadataSources.getXmlMappingBinderAccess();
    }

    public Configuration addXmlMapping(Binding<?> binding) {
        this.metadataSources.addXmlBinding(binding);
        return this;
    }

    public Configuration addCacheableFile(File xmlFile) throws MappingException {
        this.metadataSources.addCacheableFile(xmlFile);
        return this;
    }

    public Configuration addCacheableFileStrictly(File xmlFile) throws SerializationException {
        this.metadataSources.addCacheableFileStrictly(xmlFile);
        return this;
    }

    public Configuration addCacheableFile(String xmlFile) throws MappingException {
        this.metadataSources.addCacheableFile(xmlFile);
        return this;
    }

    public Configuration addURL(URL url) throws MappingException {
        this.metadataSources.addURL(url);
        return this;
    }

    public Configuration addInputStream(InputStream xmlInputStream) throws MappingException {
        this.metadataSources.addInputStream(xmlInputStream);
        return this;
    }

    public Configuration addResource(String resourceName) throws MappingException {
        this.metadataSources.addResource(resourceName);
        return this;
    }

    public Configuration addClass(Class entityClass) throws MappingException {
        if (entityClass == null) {
            throw new IllegalArgumentException("The specified class cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debugf("adding resource mappings from class convention : %s", entityClass.getName());
        }
        return this.addResource(entityClass.getName().replace('.', '/') + ".hbm.xml");
    }

    public Configuration addAnnotatedClass(Class annotatedClass) {
        this.metadataSources.addAnnotatedClass(annotatedClass);
        return this;
    }

    public Configuration addPackage(String packageName) throws MappingException {
        this.metadataSources.addPackage(packageName);
        return this;
    }

    public Configuration addJar(File jar) throws MappingException {
        this.metadataSources.addJar(jar);
        return this;
    }

    public Configuration addDirectory(File dir) throws MappingException {
        this.metadataSources.addDirectory(dir);
        return this;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Configuration setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.entityNotFoundDelegate;
    }

    public Configuration setEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    public SessionFactoryObserver getSessionFactoryObserver() {
        return this.sessionFactoryObserver;
    }

    public Configuration setSessionFactoryObserver(SessionFactoryObserver sessionFactoryObserver) {
        this.sessionFactoryObserver = sessionFactoryObserver;
        return this;
    }

    public StatementInspector getStatementInspector() {
        return this.statementInspector;
    }

    public Configuration setStatementInspector(StatementInspector statementInspector) {
        this.statementInspector = statementInspector;
        return this;
    }

    public CurrentTenantIdentifierResolver<Object> getCurrentTenantIdentifierResolver() {
        return this.currentTenantIdentifierResolver;
    }

    public Configuration setCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver<Object> currentTenantIdentifierResolver) {
        this.currentTenantIdentifierResolver = currentTenantIdentifierResolver;
        return this;
    }

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.customEntityDirtinessStrategy;
    }

    public Configuration setCustomEntityDirtinessStrategy(CustomEntityDirtinessStrategy customEntityDirtinessStrategy) {
        this.customEntityDirtinessStrategy = customEntityDirtinessStrategy;
        return this;
    }

    @Incubating
    public ColumnOrderingStrategy getColumnOrderingStrategy() {
        return this.columnOrderingStrategy;
    }

    @Incubating
    public Configuration setColumnOrderingStrategy(ColumnOrderingStrategy columnOrderingStrategy) {
        this.columnOrderingStrategy = columnOrderingStrategy;
        return this;
    }

    public SessionFactory buildSessionFactory(ServiceRegistry serviceRegistry) throws HibernateException {
        log.debug("Building session factory using provided StandardServiceRegistry");
        MetadataBuilder metadataBuilder = this.metadataSources.getMetadataBuilder((StandardServiceRegistry)serviceRegistry);
        if (this.implicitNamingStrategy != null) {
            metadataBuilder.applyImplicitNamingStrategy(this.implicitNamingStrategy);
        }
        if (this.physicalNamingStrategy != null) {
            metadataBuilder.applyPhysicalNamingStrategy(this.physicalNamingStrategy);
        }
        if (this.columnOrderingStrategy != null) {
            metadataBuilder.applyColumnOrderingStrategy(this.columnOrderingStrategy);
        }
        if (this.sharedCacheMode != null) {
            metadataBuilder.applySharedCacheMode(this.sharedCacheMode);
        }
        for (TypeContributor typeContributor : this.typeContributorRegistrations) {
            metadataBuilder.applyTypes(typeContributor);
        }
        for (FunctionContributor functionContributor : this.functionContributorRegistrations) {
            metadataBuilder.applyFunctions(functionContributor);
        }
        if (this.userTypeRegistrations != null) {
            this.userTypeRegistrations.forEach(registration -> registration.registerType(metadataBuilder));
        }
        for (BasicType basicType : this.basicTypes) {
            metadataBuilder.applyBasicType(basicType);
        }
        if (this.customFunctionDescriptors != null) {
            for (Map.Entry entry : this.customFunctionDescriptors.entrySet()) {
                metadataBuilder.applySqlFunction((String)entry.getKey(), (SqmFunctionDescriptor)entry.getValue());
            }
        }
        if (this.auxiliaryDatabaseObjectList != null) {
            for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : this.auxiliaryDatabaseObjectList) {
                metadataBuilder.applyAuxiliaryDatabaseObject(auxiliaryDatabaseObject);
            }
        }
        if (this.attributeConverterDescriptorsByClass != null) {
            this.attributeConverterDescriptorsByClass.values().forEach(metadataBuilder::applyAttributeConverter);
        }
        Metadata metadata = metadataBuilder.build();
        SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
        if (this.interceptor != null && this.interceptor != EmptyInterceptor.INSTANCE) {
            sessionFactoryBuilder.applyInterceptor(this.interceptor);
        }
        if (this.entityNameResolvers != null) {
            sessionFactoryBuilder.addEntityNameResolver(this.entityNameResolvers.toArray(new EntityNameResolver[0]));
        }
        if (this.sessionFactoryObserver != null) {
            sessionFactoryBuilder.addSessionFactoryObservers(this.sessionFactoryObserver);
        }
        if (this.statementInspector != null) {
            sessionFactoryBuilder.applyStatementInspector(this.statementInspector);
        }
        if (this.entityNotFoundDelegate != null) {
            sessionFactoryBuilder.applyEntityNotFoundDelegate(this.entityNotFoundDelegate);
        }
        if (this.currentTenantIdentifierResolver != null) {
            sessionFactoryBuilder.applyCurrentTenantIdentifierResolver(this.currentTenantIdentifierResolver);
        }
        if (this.customEntityDirtinessStrategy != null) {
            sessionFactoryBuilder.applyCustomEntityDirtinessStrategy(this.customEntityDirtinessStrategy);
        }
        return sessionFactoryBuilder.build();
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        log.debug("Building session factory using internal StandardServiceRegistryBuilder");
        this.standardServiceRegistryBuilder.applySettings(this.properties);
        StandardServiceRegistry serviceRegistry = this.standardServiceRegistryBuilder.build();
        try {
            return this.buildSessionFactory(serviceRegistry);
        }
        catch (Throwable t) {
            serviceRegistry.close();
            throw t;
        }
    }

    public Configuration addSqlFunction(String functionName, SqmFunctionDescriptor function) {
        if (this.customFunctionDescriptors == null) {
            this.customFunctionDescriptors = new HashMap<String, SqmFunctionDescriptor>();
        }
        this.customFunctionDescriptors.put(functionName, function);
        return this;
    }

    public Configuration addAuxiliaryDatabaseObject(AuxiliaryDatabaseObject object) {
        if (this.auxiliaryDatabaseObjectList == null) {
            this.auxiliaryDatabaseObjectList = new ArrayList<AuxiliaryDatabaseObject>();
        }
        this.auxiliaryDatabaseObjectList.add(object);
        return this;
    }

    public Configuration addAttributeConverter(Class<? extends AttributeConverter<?, ?>> attributeConverterClass, boolean autoApply) {
        this.addAttributeConverter(new ClassBasedConverterDescriptor(attributeConverterClass, autoApply, this.classmateContext));
        return this;
    }

    public Configuration addAttributeConverter(Class<? extends AttributeConverter<?, ?>> attributeConverterClass) {
        this.addAttributeConverter(new ClassBasedConverterDescriptor(attributeConverterClass, this.classmateContext));
        return this;
    }

    public Configuration addAttributeConverter(AttributeConverter<?, ?> attributeConverter) {
        this.addAttributeConverter(new InstanceBasedConverterDescriptor(attributeConverter, this.classmateContext));
        return this;
    }

    public Configuration addAttributeConverter(AttributeConverter<?, ?> attributeConverter, boolean autoApply) {
        this.addAttributeConverter(new InstanceBasedConverterDescriptor(attributeConverter, (Boolean)autoApply, this.classmateContext));
        return this;
    }

    public Configuration addAttributeConverter(ConverterDescriptor converterDescriptor) {
        if (this.attributeConverterDescriptorsByClass == null) {
            this.attributeConverterDescriptorsByClass = new HashMap();
        }
        this.attributeConverterDescriptorsByClass.put(converterDescriptor.getAttributeConverterClass(), converterDescriptor);
        return this;
    }

    public Configuration addEntityNameResolver(EntityNameResolver entityNameResolver) {
        if (this.entityNameResolvers == null) {
            this.entityNameResolvers = new ArrayList<EntityNameResolver>();
        }
        this.entityNameResolvers.add(entityNameResolver);
        return this;
    }

    public Configuration setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
        return this;
    }

    public Map<String, NamedNativeQueryDefinition<?>> getNamedSQLQueries() {
        return this.namedSqlQueries;
    }

    public Map<String, NamedResultSetMappingDescriptor> getSqlResultSetMappings() {
        return this.sqlResultSetMappings;
    }

    public Collection<NamedEntityGraphDefinition> getNamedEntityGraphs() {
        return this.namedEntityGraphMap == null ? Collections.emptyList() : this.namedEntityGraphMap.values();
    }

    public Map<String, NamedHqlQueryDefinition<?>> getNamedQueries() {
        return this.namedQueries;
    }

    public Map<String, NamedProcedureCallDefinition> getNamedProcedureCallMap() {
        return this.namedProcedureCallMap;
    }

    public Configuration mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (properties.containsKey(entry.getKey())) continue;
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    private static interface UserTypeRegistration {
        public void registerType(MetadataBuilder var1);
    }
}

