/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.dialect.StructAttributeValues;
import org.hibernate.dialect.StructHelper;
import org.hibernate.internal.util.CharSequenceHelper;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StringBuilderSqlAppender;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractPostgreSQLStructJdbcType
implements StructJdbcType {
    private static final DateTimeFormatter LOCAL_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:mm", "+00").toFormatter();
    private static final DateTimeFormatter LOCAL_DATE = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendOffset("+HH:mm", "+00").toFormatter();
    private final String typeName;
    private final int[] orderMapping;
    private final int[] inverseOrderMapping;
    private final EmbeddableMappingType embeddableMappingType;

    protected AbstractPostgreSQLStructJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        this.typeName = typeName;
        this.embeddableMappingType = embeddableMappingType;
        this.orderMapping = orderMapping;
        if (orderMapping == null) {
            this.inverseOrderMapping = null;
        } else {
            int[] inverseOrderMapping = new int[orderMapping.length];
            for (int i = 0; i < orderMapping.length; ++i) {
                inverseOrderMapping[orderMapping[i]] = i;
            }
            this.inverseOrderMapping = inverseOrderMapping;
        }
    }

    @Override
    public int getJdbcTypeCode() {
        return 2002;
    }

    @Override
    public String getStructTypeName() {
        return this.typeName;
    }

    @Override
    public EmbeddableMappingType getEmbeddableMappingType() {
        return this.embeddableMappingType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        if (this.embeddableMappingType == null) {
            return typeConfiguration.getJavaTypeRegistry().getDescriptor((Type)((Object)Object[].class));
        }
        return this.embeddableMappingType.getMappedJavaType();
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getObject(rs.getObject(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getObject(statement.getObject(name), options);
            }

            private X getObject(Object object, WrapperOptions options) throws SQLException {
                if (object == null) {
                    return null;
                }
                return ((AbstractPostgreSQLStructJdbcType)this.getJdbcType()).fromString(object.toString(), this.getJavaType(), options);
            }
        };
    }

    protected <X> X fromString(String string, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        Object[] array;
        int end;
        boolean returnEmbeddable;
        if (string == null) {
            return null;
        }
        boolean bl = returnEmbeddable = javaType.getJavaTypeClass() != Object[].class;
        if (this.embeddableMappingType == null) {
            assert (!returnEmbeddable);
            ArrayList<Object> values = new ArrayList<Object>(8);
            end = this.deserializeStruct(string, 0, string.length() - 1, values);
            array = values.toArray();
        } else {
            array = new Object[this.embeddableMappingType.getJdbcValueCount() + (this.embeddableMappingType.isPolymorphic() ? 1 : 0)];
            end = this.deserializeStruct(string, 0, 0, array, returnEmbeddable, options);
        }
        assert (end == string.length());
        if (returnEmbeddable) {
            StructAttributeValues attributeValues = this.getAttributeValues(this.embeddableMappingType, this.orderMapping, array, options);
            return (X)StructHelper.instantiate(this.embeddableMappingType, attributeValues, options.getSessionFactory());
        }
        if (this.inverseOrderMapping != null) {
            StructHelper.orderJdbcValues(this.embeddableMappingType, this.inverseOrderMapping, (Object[])array.clone(), array);
        }
        return (X)array;
    }

    private int deserializeStruct(String string, int begin, int end, ArrayList<Object> values) {
        int column = 0;
        boolean inQuote = false;
        boolean hasEscape = false;
        assert (string.charAt(begin) == '(');
        int start = begin + 1;
        int element = 1;
        block5: for (int i = start; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    if (inQuote) {
                        if (i + 1 != end && string.charAt(i + 1) == '\"') {
                            ++i;
                            hasEscape = true;
                            continue block5;
                        }
                        if (hasEscape) {
                            values.add(AbstractPostgreSQLStructJdbcType.unescape(string, start, i));
                        } else {
                            values.add(string.substring(start, i));
                        }
                        ++column;
                        inQuote = false;
                    } else {
                        inQuote = true;
                    }
                    hasEscape = false;
                    start = i + 1;
                    continue block5;
                }
                case ',': {
                    if (inQuote) continue block5;
                    if (column < element) {
                        if (start == i) {
                            values.add(null);
                        } else {
                            values.add(string.substring(start, i));
                        }
                        ++column;
                    }
                    start = i + 1;
                    ++element;
                    continue block5;
                }
                case ')': {
                    if (inQuote) continue block5;
                    if (column < element) {
                        if (start == i) {
                            values.add(null);
                        } else {
                            values.add(string.substring(start, i));
                        }
                    }
                    return i + 1;
                }
            }
        }
        throw new IllegalArgumentException("Struct not properly formed: " + string.subSequence(start, end));
    }

    private int deserializeStruct(String string, int begin, int quotes, Object[] values, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        int start;
        int column = 0;
        boolean inQuote = false;
        StringBuilder escapingSb = null;
        assert (string.charAt(begin) == '(');
        block14: for (int i = start = begin + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    int expectedQuoteCount;
                    if (inQuote && AbstractPostgreSQLStructJdbcType.repeatsChar(string, i, expectedQuoteCount = 1 << quotes, '\\')) {
                        if (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i + expectedQuoteCount, expectedQuoteCount)) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\"');
                            start = (i += expectedQuoteCount + expectedQuoteCount - 1) + 1;
                            continue block14;
                        }
                        assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, i + expectedQuoteCount, expectedQuoteCount, '\\'));
                        if (i != start || !this.isBinary(column)) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\\');
                            start = i + expectedQuoteCount + expectedQuoteCount;
                        }
                        i += expectedQuoteCount + expectedQuoteCount - 1;
                        continue block14;
                    }
                }
                case '\"': {
                    if (inQuote) {
                        if (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i, 1 << quotes + 1)) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\"');
                            start = (i += (1 << quotes + 1) - 1) + 1;
                            continue block14;
                        }
                        assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i, 1 << quotes));
                        JdbcMapping jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping();
                        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
                            case 91: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseDate(CharSequenceHelper.subSequence(string, start, i)), options);
                                break;
                            }
                            case 92: 
                            case 2013: 
                            case 3007: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseTime(CharSequenceHelper.subSequence(string, start, i)), options);
                                break;
                            }
                            case 93: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseTimestamp(CharSequenceHelper.subSequence(string, start, i), jdbcMapping.getJdbcJavaType()), options);
                                break;
                            }
                            case 2014: 
                            case 3003: {
                                values[column] = AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, this.parseTimestampWithTimeZone(CharSequenceHelper.subSequence(string, start, i), jdbcMapping.getJdbcJavaType()), options);
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 4003: {
                                int backslashes = 1 << quotes + 1;
                                assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, start, backslashes, '\\'));
                                int xCharPosition = start + backslashes;
                                assert (string.charAt(xCharPosition) == 'x');
                                values[column] = AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, xCharPosition + 1, i);
                                break;
                            }
                            default: {
                                if (escapingSb == null || escapingSb.length() == 0) {
                                    values[column] = AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, start, i);
                                    break;
                                }
                                escapingSb.append(string, start, i);
                                values[column] = AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, escapingSb, 0, escapingSb.length());
                                escapingSb.setLength(0);
                            }
                        }
                        ++column;
                        inQuote = false;
                        if (string.charAt(i += 1 << quotes) == ')') {
                            assert (column == values.length);
                            return i + 1;
                        }
                        assert (string.charAt(i) == ',');
                    } else {
                        int expectedQuotes = 1 << quotes;
                        assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i, expectedQuotes));
                        if (string.charAt((i += expectedQuotes - 1) + 1) == '(') {
                            JdbcMapping jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping();
                            if (jdbcMapping.getJdbcType() instanceof AbstractPostgreSQLStructJdbcType) {
                                AbstractPostgreSQLStructJdbcType structJdbcType = (AbstractPostgreSQLStructJdbcType)jdbcMapping.getJdbcType();
                                Object[] subValues = new Object[structJdbcType.embeddableMappingType.getJdbcValueCount()];
                                subEnd = structJdbcType.deserializeStruct(string, i + 1, quotes + 1, subValues, returnEmbeddable, options);
                                if (returnEmbeddable) {
                                    Object subValue;
                                    StructAttributeValues attributeValues = structJdbcType.getAttributeValues(structJdbcType.embeddableMappingType, structJdbcType.orderMapping, subValues, options);
                                    values[column] = subValue = StructHelper.instantiate(structJdbcType.embeddableMappingType, attributeValues, options.getSessionFactory());
                                } else {
                                    if (structJdbcType.inverseOrderMapping != null) {
                                        StructHelper.orderJdbcValues(structJdbcType.embeddableMappingType, structJdbcType.inverseOrderMapping, (Object[])subValues.clone(), subValues);
                                    }
                                    values[column] = subValues;
                                }
                                ++column;
                                assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, subEnd, expectedQuotes));
                                i = subEnd + expectedQuotes;
                                if (string.charAt(i) == ')') {
                                    assert (column == values.length);
                                    return i + 1;
                                }
                                assert (string.charAt(i) == ',');
                            } else {
                                inQuote = true;
                            }
                        } else if (string.charAt(i + 1) == '{') {
                            JdbcMapping jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping();
                            if (jdbcMapping instanceof BasicPluralType) {
                                BasicPluralType pluralType = (BasicPluralType)jdbcMapping;
                                ArrayList<Object> arrayList = new ArrayList<Object>();
                                subEnd = this.deserializeArray(string, i + 1, quotes + 1, arrayList, pluralType.getElementType(), returnEmbeddable, options);
                                assert (string.charAt(subEnd - 1) == '}');
                                values[column] = pluralType.getJdbcJavaType().wrap(arrayList, options);
                                ++column;
                                assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, subEnd, expectedQuotes));
                                i = subEnd + expectedQuotes;
                                if (string.charAt(i) == ')') {
                                    assert (column == values.length);
                                    return i + 1;
                                }
                                assert (string.charAt(i) == ',');
                            } else {
                                inQuote = true;
                            }
                        } else {
                            inQuote = true;
                        }
                    }
                    start = i + 1;
                    continue block14;
                }
                case ',': {
                    JdbcMapping jdbcMapping;
                    if (inQuote) continue block14;
                    values[column] = start == i ? null : ((jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping()).getJdbcType().getDefaultSqlTypeCode() == 16 ? AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, string.charAt(start) == 't', options) : (jdbcMapping.getJavaTypeDescriptor().getJavaTypeClass().isEnum() && jdbcMapping.getJdbcType().isInteger() ? AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, IntegerJavaType.INSTANCE.fromEncodedString(string, start, i), options) : AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, start, i)));
                    ++column;
                    start = i + 1;
                    continue block14;
                }
                case ')': {
                    if (inQuote) continue block14;
                    if (column < values.length) {
                        JdbcMapping jdbcMapping;
                        values[column] = start == i ? null : ((jdbcMapping = this.getJdbcValueSelectable(column).getJdbcMapping()).getJdbcType().getDefaultSqlTypeCode() == 16 ? AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, string.charAt(start) == 't', options) : (jdbcMapping.getJavaTypeDescriptor().getJavaTypeClass().isEnum() && jdbcMapping.getJdbcType().isInteger() ? AbstractPostgreSQLStructJdbcType.fromRawObject(jdbcMapping, IntegerJavaType.INSTANCE.fromEncodedString(string, start, i), options) : AbstractPostgreSQLStructJdbcType.fromString(jdbcMapping, string, start, i)));
                    }
                    return i + 1;
                }
                case '{': {
                    if (inQuote) continue block14;
                    BasicPluralType pluralType = (BasicPluralType)this.getJdbcValueSelectable(column).getJdbcMapping();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    i = this.deserializeArray(string, i, quotes + 1, arrayList, pluralType.getElementType(), returnEmbeddable, options);
                    assert (string.charAt(i - 1) == '}');
                    values[column] = pluralType.getJdbcJavaType().wrap(arrayList, options);
                    ++column;
                    if (string.charAt(i) == ')') {
                        assert (column == values.length);
                        return i + 1;
                    }
                    assert (string.charAt(i) == ',');
                    start = i + 1;
                }
            }
        }
        throw new IllegalArgumentException("Struct not properly formed: " + string.substring(start));
    }

    private boolean isBinary(int column) {
        return AbstractPostgreSQLStructJdbcType.isBinary(this.getJdbcValueSelectable(column).getJdbcMapping());
    }

    private static boolean isBinary(JdbcMapping jdbcMapping) {
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                return true;
            }
        }
        return false;
    }

    private int deserializeArray(String string, int begin, int quotes, ArrayList<Object> values, BasicType<Object> elementType, boolean returnEmbeddable, WrapperOptions options) throws SQLException {
        int start;
        boolean inQuote = false;
        StringBuilder escapingSb = null;
        assert (string.charAt(begin) == '{');
        block16: for (int i = start = begin + 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    int expectedQuoteCount;
                    if (inQuote && AbstractPostgreSQLStructJdbcType.repeatsChar(string, i, expectedQuoteCount = 1 << quotes, '\\')) {
                        if (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i + expectedQuoteCount, expectedQuoteCount)) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\"');
                            start = (i += expectedQuoteCount + expectedQuoteCount - 1) + 1;
                            continue block16;
                        }
                        assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, i + expectedQuoteCount, expectedQuoteCount, '\\'));
                        if (i != start || !AbstractPostgreSQLStructJdbcType.isBinary(elementType)) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\\');
                            start = i + expectedQuoteCount + expectedQuoteCount;
                        }
                        i += expectedQuoteCount + expectedQuoteCount - 1;
                        continue block16;
                    }
                }
                case '\"': {
                    int backslashes;
                    if (inQuote) {
                        if (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i, 1 << quotes + 1)) {
                            if (escapingSb == null) {
                                escapingSb = new StringBuilder();
                            }
                            escapingSb.append(string, start, i);
                            escapingSb.append('\"');
                            start = (i += (1 << quotes + 1) - 1) + 1;
                            continue block16;
                        }
                        assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i, 1 << quotes));
                        switch (elementType.getJdbcType().getDefaultSqlTypeCode()) {
                            case 91: {
                                values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, this.parseDate(CharSequenceHelper.subSequence(string, start, i)), options));
                                break;
                            }
                            case 92: 
                            case 2013: 
                            case 3007: {
                                values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, this.parseTime(CharSequenceHelper.subSequence(string, start, i)), options));
                                break;
                            }
                            case 93: {
                                values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, this.parseTimestamp(CharSequenceHelper.subSequence(string, start, i), elementType.getJdbcJavaType()), options));
                                break;
                            }
                            case 2014: 
                            case 3003: {
                                values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, this.parseTimestampWithTimeZone(CharSequenceHelper.subSequence(string, start, i), elementType.getJdbcJavaType()), options));
                                break;
                            }
                            case -4: 
                            case -3: 
                            case -2: 
                            case 4003: {
                                backslashes = 1 << quotes + 1;
                                assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, start, backslashes, '\\'));
                                int xCharPosition = start + backslashes;
                                assert (string.charAt(xCharPosition) == 'x');
                                values.add(AbstractPostgreSQLStructJdbcType.fromString(elementType, string, xCharPosition + 1, i));
                                break;
                            }
                            default: {
                                if (escapingSb == null || escapingSb.length() == 0) {
                                    values.add(AbstractPostgreSQLStructJdbcType.fromString(elementType, string, start, i));
                                    break;
                                }
                                escapingSb.append(string, start, i);
                                values.add(AbstractPostgreSQLStructJdbcType.fromString(elementType, escapingSb, 0, escapingSb.length()));
                                escapingSb.setLength(0);
                            }
                        }
                        inQuote = false;
                        if (string.charAt(i += 1 << quotes) == '}') {
                            return i + 1;
                        }
                        assert (string.charAt(i) == ',');
                    } else {
                        int expectedQuotes = 1 << quotes;
                        assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, i, expectedQuotes));
                        if (string.charAt((i += expectedQuotes - 1) + 1) == '(') {
                            if (elementType.getJdbcType() instanceof AbstractPostgreSQLStructJdbcType) {
                                AbstractPostgreSQLStructJdbcType structJdbcType = (AbstractPostgreSQLStructJdbcType)elementType.getJdbcType();
                                Object[] subValues = new Object[structJdbcType.embeddableMappingType.getJdbcValueCount()];
                                int subEnd = structJdbcType.deserializeStruct(string, i + 1, quotes + 1, subValues, returnEmbeddable, options);
                                if (returnEmbeddable) {
                                    StructAttributeValues attributeValues = structJdbcType.getAttributeValues(structJdbcType.embeddableMappingType, structJdbcType.orderMapping, subValues, options);
                                    Object subValue = StructHelper.instantiate(structJdbcType.embeddableMappingType, attributeValues, options.getSessionFactory());
                                    values.add(subValue);
                                } else {
                                    if (structJdbcType.inverseOrderMapping != null) {
                                        StructHelper.orderJdbcValues(structJdbcType.embeddableMappingType, structJdbcType.inverseOrderMapping, (Object[])subValues.clone(), subValues);
                                    }
                                    values.add(subValues);
                                }
                                assert (AbstractPostgreSQLStructJdbcType.isDoubleQuote(string, subEnd, expectedQuotes));
                                i = subEnd + expectedQuotes;
                                if (string.charAt(i) == '}') {
                                    return i + 1;
                                }
                                assert (string.charAt(i) == ',');
                            } else {
                                inQuote = true;
                            }
                        } else {
                            inQuote = true;
                        }
                    }
                    start = i + 1;
                    switch (elementType.getJdbcType().getDefaultSqlTypeCode()) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case 4003: {
                            backslashes = 1 << quotes + 1;
                            assert (AbstractPostgreSQLStructJdbcType.repeatsChar(string, start, backslashes, '\\'));
                            i += backslashes;
                        }
                    }
                    continue block16;
                }
                case ',': {
                    if (inQuote) continue block16;
                    if (start == i) {
                        values.add(null);
                    } else if (elementType.getJdbcType().getDefaultSqlTypeCode() == 16) {
                        values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, string.charAt(start) == 't', options));
                    } else if (elementType.getJavaTypeDescriptor().getJavaTypeClass().isEnum() && elementType.getJdbcType().isInteger()) {
                        values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, IntegerJavaType.INSTANCE.fromEncodedString(string, start, i), options));
                    } else {
                        values.add(AbstractPostgreSQLStructJdbcType.fromString(elementType, string, start, i));
                    }
                    start = i + 1;
                    continue block16;
                }
                case '}': {
                    if (inQuote) continue block16;
                    if (start == i) {
                        values.add(null);
                    } else if (elementType.getJdbcType().getDefaultSqlTypeCode() == 16) {
                        values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, string.charAt(start) == 't', options));
                    } else if (elementType.getJavaTypeDescriptor().getJavaTypeClass().isEnum() && elementType.getJdbcType().isInteger()) {
                        values.add(AbstractPostgreSQLStructJdbcType.fromRawObject(elementType, IntegerJavaType.INSTANCE.fromEncodedString(string, start, i), options));
                    } else {
                        values.add(AbstractPostgreSQLStructJdbcType.fromString(elementType, string, start, i));
                    }
                    return i + 1;
                }
            }
        }
        throw new IllegalArgumentException("Array not properly formed: " + string.substring(start));
    }

    private SelectableMapping getJdbcValueSelectable(int jdbcValueSelectableIndex) {
        if (this.orderMapping != null) {
            int numberOfAttributeMappings = this.embeddableMappingType.getNumberOfAttributeMappings();
            int size = numberOfAttributeMappings + (this.embeddableMappingType.isPolymorphic() ? 1 : 0);
            int count = 0;
            for (int i = 0; i < size; ++i) {
                ValuedModelPart modelPart = StructHelper.getEmbeddedPart(this.embeddableMappingType, this.orderMapping[i]);
                MappingType mappedType = modelPart.getMappedType();
                if (mappedType instanceof EmbeddableMappingType) {
                    EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
                    SelectableMapping aggregateMapping = embeddableMappingType.getAggregateMapping();
                    if (aggregateMapping == null) {
                        SelectableMapping subSelectable = embeddableMappingType.getJdbcValueSelectable(jdbcValueSelectableIndex - count);
                        if (subSelectable != null) {
                            return subSelectable;
                        }
                        count += embeddableMappingType.getJdbcValueCount();
                        continue;
                    }
                    if (count == jdbcValueSelectableIndex) {
                        return aggregateMapping;
                    }
                    ++count;
                    continue;
                }
                if (count == jdbcValueSelectableIndex) {
                    return (SelectableMapping)((Object)modelPart);
                }
                count += modelPart.getJdbcTypeCount();
            }
            return null;
        }
        return this.embeddableMappingType.getJdbcValueSelectable(jdbcValueSelectableIndex);
    }

    private static boolean repeatsChar(String string, int start, int times, char expectedChar) {
        int end = start + times;
        if (end < string.length()) {
            while (start < end) {
                if (string.charAt(start) != expectedChar) {
                    return false;
                }
                ++start;
            }
            return true;
        }
        return false;
    }

    private static boolean isDoubleQuote(String string, int start, int escapes) {
        if (escapes == 1) {
            return string.charAt(start) == '\"';
        }
        assert ((escapes & 1) == 0) : "Only an even number of escapes allowed";
        int end = start + escapes;
        if (end < string.length()) {
            while (start < end) {
                char c1 = string.charAt(start);
                char c2 = string.charAt(start + 1);
                switch (c1) {
                    case '\\': {
                        if (c2 == '\\' || c2 == '\"') break;
                        return false;
                    }
                    case '\"': {
                        if (c2 == '\"') break;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
                start += 2;
            }
            return string.charAt(end - 1) == '\"';
        }
        return false;
    }

    private Object fromString(int selectableIndex, String string, int start, int end) {
        return AbstractPostgreSQLStructJdbcType.fromString(this.getJdbcValueSelectable(selectableIndex).getJdbcMapping(), string, start, end);
    }

    private static Object fromString(JdbcMapping jdbcMapping, CharSequence charSequence, int start, int end) {
        return jdbcMapping.getJdbcJavaType().fromEncodedString(charSequence, start, end);
    }

    private static Object fromRawObject(JdbcMapping jdbcMapping, Object raw, WrapperOptions options) {
        return jdbcMapping.getJdbcJavaType().wrap(raw, options);
    }

    private Object parseDate(CharSequence subSequence) {
        return LOCAL_DATE.parse(subSequence, LocalDate::from);
    }

    private Object parseTime(CharSequence subSequence) {
        return DateTimeFormatter.ISO_LOCAL_TIME.parse(subSequence, LocalTime::from);
    }

    private Object parseTimestamp(CharSequence subSequence, JavaType<?> jdbcJavaType) {
        TemporalAccessor temporalAccessor = LOCAL_DATE_TIME.parse(subSequence);
        LocalDateTime localDateTime = LocalDateTime.from(temporalAccessor);
        Timestamp timestamp = Timestamp.valueOf(localDateTime);
        timestamp.setNanos(temporalAccessor.get(ChronoField.NANO_OF_SECOND));
        return timestamp;
    }

    private Object parseTimestampWithTimeZone(CharSequence subSequence, JavaType<?> jdbcJavaType) {
        TemporalAccessor temporalAccessor = LOCAL_DATE_TIME.parse(subSequence);
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (jdbcJavaType.getJavaTypeClass() == Instant.class) {
                return Instant.from(temporalAccessor);
            }
            return OffsetDateTime.from(temporalAccessor);
        }
        return LocalDateTime.from(temporalAccessor);
    }

    private static String unescape(CharSequence string, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.append(string.charAt(++i));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public Object createJdbcValue(Object domainValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        StringBuilder sb = new StringBuilder();
        this.serializeStructTo(new PostgreSQLAppender(sb), domainValue, options);
        return sb.toString();
    }

    @Override
    public Object[] extractJdbcValues(Object rawJdbcValue, WrapperOptions options) throws SQLException {
        assert (this.embeddableMappingType != null);
        Object[] array = new Object[this.embeddableMappingType.getJdbcValueCount()];
        this.deserializeStruct(this.getRawStructFromJdbcValue(rawJdbcValue), 0, 0, array, true, options);
        if (this.inverseOrderMapping != null) {
            StructHelper.orderJdbcValues(this.embeddableMappingType, this.inverseOrderMapping, (Object[])array.clone(), array);
        }
        return array;
    }

    protected String getRawStructFromJdbcValue(Object rawJdbcValue) {
        return rawJdbcValue.toString();
    }

    protected <X> String toString(X value, JavaType<X> javaType, WrapperOptions options) throws SQLException {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        this.serializeStructTo(new PostgreSQLAppender(sb), value, options);
        return sb.toString();
    }

    private void serializeStructTo(PostgreSQLAppender appender, Object value, WrapperOptions options) throws SQLException {
        this.serializeDomainValueTo(appender, options, value, '(');
        appender.append(')');
    }

    private void serializeDomainValueTo(PostgreSQLAppender appender, WrapperOptions options, Object domainValue, char separator) throws SQLException {
        this.serializeJdbcValuesTo(appender, options, StructHelper.getJdbcValues(this.embeddableMappingType, this.orderMapping, domainValue, options), separator);
    }

    private void serializeJdbcValuesTo(PostgreSQLAppender appender, WrapperOptions options, Object[] jdbcValues, char separator) throws SQLException {
        for (int i = 0; i < jdbcValues.length; ++i) {
            appender.append(separator);
            separator = (char)44;
            Object jdbcValue = jdbcValues[i];
            if (jdbcValue == null) continue;
            SelectableMapping selectableMapping = this.orderMapping == null ? this.embeddableMappingType.getJdbcValueSelectable(i) : this.embeddableMappingType.getJdbcValueSelectable(this.orderMapping[i]);
            JdbcMapping jdbcMapping = selectableMapping.getJdbcMapping();
            if (jdbcMapping.getJdbcType() instanceof AbstractPostgreSQLStructJdbcType) {
                appender.quoteStart();
                ((AbstractPostgreSQLStructJdbcType)jdbcMapping.getJdbcType()).serializeJdbcValuesTo(appender, options, (Object[])jdbcValue, '(');
                appender.append(')');
                appender.quoteEnd();
                continue;
            }
            this.serializeConvertedBasicTo(appender, options, jdbcMapping, jdbcValue);
        }
    }

    private void serializeConvertedBasicTo(PostgreSQLAppender appender, WrapperOptions options, JdbcMapping jdbcMapping, Object subValue) throws SQLException {
        JavaType<?> jdbcJavaType = jdbcMapping.getJdbcJavaType();
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -6: 
            case 4: 
            case 5: {
                if (subValue instanceof Boolean) {
                    appender.append((Boolean)subValue != false ? (char)'1' : '0');
                    break;
                }
                if (subValue instanceof Enum) {
                    appender.appendSql(((Enum)subValue).ordinal());
                    break;
                }
            }
            case -7: 
            case -5: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 3015: {
                appender.append(subValue.toString());
                break;
            }
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                if (subValue instanceof Boolean) {
                    appender.append((Boolean)subValue != false ? (char)'Y' : 'N');
                    break;
                }
            }
            case -16: 
            case -1: 
            case 4001: 
            case 4002: 
            case 6000: 
            case 6001: {
                appender.quoteStart();
                appender.append((String)subValue);
                appender.quoteEnd();
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: 
            case 3003: 
            case 3007: {
                this.appendTemporal(appender, jdbcMapping, subValue, options);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 4003: {
                byte[] bytes = jdbcJavaType.unwrap(subValue, byte[].class, options);
                appender.ensureCanFit(appender.quote + 1 + (bytes.length << 1));
                appender.append('\\');
                appender.append('\\');
                appender.append('x');
                PrimitiveByteArrayJavaType.INSTANCE.appendString(appender, bytes);
                break;
            }
            case 3000: {
                appender.append(subValue.toString());
                break;
            }
            case 2003: {
                if (subValue == null) break;
                int length = Array.getLength(subValue);
                if (length == 0) {
                    appender.append("{}");
                    break;
                }
                BasicType elementType = ((BasicPluralType)jdbcMapping).getElementType();
                appender.quoteStart();
                appender.append('{');
                Object arrayElement = Array.get(subValue, 0);
                if (arrayElement == null) {
                    appender.appendNull();
                } else {
                    this.serializeConvertedBasicTo(appender, options, elementType, arrayElement);
                }
                for (int i = 1; i < length; ++i) {
                    arrayElement = Array.get(subValue, i);
                    appender.append(',');
                    if (arrayElement == null) {
                        appender.appendNull();
                        continue;
                    }
                    this.serializeConvertedBasicTo(appender, options, elementType, arrayElement);
                }
                appender.append('}');
                appender.quoteEnd();
                break;
            }
            case 2002: {
                if (subValue == null) break;
                AbstractPostgreSQLStructJdbcType structJdbcType = (AbstractPostgreSQLStructJdbcType)jdbcMapping.getJdbcType();
                appender.quoteStart();
                structJdbcType.serializeJdbcValuesTo(appender, options, (Object[])subValue, '(');
                appender.append(')');
                appender.quoteEnd();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported JdbcType nested in struct: " + jdbcMapping.getJdbcType());
            }
        }
    }

    private StructAttributeValues getAttributeValues(EmbeddableMappingType embeddableMappingType, int[] orderMapping, Object[] rawJdbcValues, WrapperOptions options) throws SQLException {
        int numberOfAttributeMappings = embeddableMappingType.getNumberOfAttributeMappings();
        int size = numberOfAttributeMappings + (embeddableMappingType.isPolymorphic() ? 1 : 0);
        StructAttributeValues attributeValues = new StructAttributeValues(numberOfAttributeMappings, orderMapping != null ? null : rawJdbcValues);
        int jdbcIndex = 0;
        for (int i = 0; i < size; ++i) {
            int attributeIndex = orderMapping == null ? i : orderMapping[i];
            jdbcIndex += this.injectAttributeValue(StructHelper.getEmbeddedPart(embeddableMappingType, attributeIndex), attributeValues, attributeIndex, rawJdbcValues, jdbcIndex, options);
        }
        return attributeValues;
    }

    private int injectAttributeValue(ValuedModelPart modelPart, StructAttributeValues attributeValues, int attributeIndex, Object[] rawJdbcValues, int jdbcIndex, WrapperOptions options) throws SQLException {
        int jdbcValueCount;
        MappingType mappedType = modelPart.getMappedType();
        Object rawJdbcValue = rawJdbcValues[jdbcIndex];
        if (mappedType instanceof EmbeddableMappingType) {
            EmbeddableMappingType embeddableMappingType = (EmbeddableMappingType)mappedType;
            if (embeddableMappingType.getAggregateMapping() != null) {
                jdbcValueCount = 1;
                attributeValues.setAttributeValue(attributeIndex, rawJdbcValue);
            } else {
                jdbcValueCount = embeddableMappingType.getJdbcValueCount();
                Object[] subJdbcValues = new Object[jdbcValueCount];
                System.arraycopy(rawJdbcValues, jdbcIndex, subJdbcValues, 0, subJdbcValues.length);
                StructAttributeValues subValues = this.getAttributeValues(embeddableMappingType, null, subJdbcValues, options);
                attributeValues.setAttributeValue(attributeIndex, StructHelper.instantiate(embeddableMappingType, subValues, options.getSessionFactory()));
            }
        } else {
            assert (modelPart.getJdbcTypeCount() == 1);
            jdbcValueCount = 1;
            JdbcMapping jdbcMapping = modelPart.getSingleJdbcMapping();
            Object jdbcValue = jdbcMapping.getJdbcJavaType().wrap(rawJdbcValue, options);
            attributeValues.setAttributeValue(attributeIndex, jdbcMapping.convertToDomainValue(jdbcValue));
        }
        return jdbcValueCount;
    }

    private void appendTemporal(SqlAppender appender, JdbcMapping jdbcMapping, Object value, WrapperOptions options) {
        TimeZone jdbcTimeZone = AbstractPostgreSQLStructJdbcType.getJdbcTimeZone(options);
        JavaType<?> javaType = jdbcMapping.getJdbcJavaType();
        appender.append('\"');
        switch (jdbcMapping.getJdbcType().getJdbcTypeCode()) {
            case 91: {
                if (value instanceof Date) {
                    DateTimeUtils.appendAsDate(appender, (Date)value);
                    break;
                }
                if (value instanceof Calendar) {
                    DateTimeUtils.appendAsDate(appender, (Calendar)value);
                    break;
                }
                if (value instanceof TemporalAccessor) {
                    DateTimeUtils.appendAsDate(appender, (TemporalAccessor)value);
                    break;
                }
                DateTimeUtils.appendAsDate(appender, javaType.unwrap(value, Date.class, options));
                break;
            }
            case 92: 
            case 2013: 
            case 3007: {
                if (value instanceof Date) {
                    DateTimeUtils.appendAsTime(appender, (Date)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof Calendar) {
                    DateTimeUtils.appendAsTime(appender, (Calendar)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof TemporalAccessor) {
                    TemporalAccessor temporalAccessor = (TemporalAccessor)value;
                    if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                        DateTimeUtils.appendAsTime(appender, temporalAccessor, true, jdbcTimeZone);
                        break;
                    }
                    DateTimeUtils.appendAsLocalTime(appender, temporalAccessor);
                    break;
                }
                DateTimeUtils.appendAsTime(appender, javaType.unwrap(value, Time.class, options), jdbcTimeZone);
                break;
            }
            case 93: 
            case 2014: 
            case 3003: {
                if (value instanceof Date) {
                    DateTimeUtils.appendAsTimestampWithMicros(appender, (Date)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof Calendar) {
                    DateTimeUtils.appendAsTimestampWithMillis(appender, (Calendar)value, jdbcTimeZone);
                    break;
                }
                if (value instanceof TemporalAccessor) {
                    TemporalAccessor temporalAccessor = (TemporalAccessor)value;
                    DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS), jdbcTimeZone);
                    break;
                }
                DateTimeUtils.appendAsTimestampWithMicros(appender, javaType.unwrap(value, Date.class, options), jdbcTimeZone);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        appender.append('\"');
    }

    private static TimeZone getJdbcTimeZone(WrapperOptions options) {
        return options == null || options.getJdbcTimeZone() == null ? TimeZone.getDefault() : options.getJdbcTimeZone();
    }

    protected <X> Object getBindValue(X value, WrapperOptions options) throws SQLException {
        return StructHelper.getJdbcValues(this.embeddableMappingType, this.orderMapping, value, options);
    }

    private static class PostgreSQLAppender
    extends StringBuilderSqlAppender {
        private int quote = 1;

        public PostgreSQLAppender(StringBuilder sb) {
            super(sb);
        }

        public void quoteStart() {
            this.append('\"');
            this.quote <<= 1;
        }

        public void quoteEnd() {
            this.quote >>= 1;
            this.append('\"');
        }

        public void appendNull() {
            this.sb.append("NULL");
        }

        @Override
        public PostgreSQLAppender append(char fragment) {
            if (this.quote != 1) {
                this.appendWithQuote(fragment);
            } else {
                this.sb.append(fragment);
            }
            return this;
        }

        @Override
        public PostgreSQLAppender append(CharSequence csq) {
            return this.append(csq, 0, csq.length());
        }

        @Override
        public PostgreSQLAppender append(CharSequence csq, int start, int end) {
            if (this.quote != 1) {
                int len = end - start;
                this.sb.ensureCapacity(this.sb.length() + len);
                for (int i = start; i < end; ++i) {
                    this.appendWithQuote(csq.charAt(i));
                }
            } else {
                this.sb.append(csq, start, end);
            }
            return this;
        }

        private void appendWithQuote(char fragment) {
            if (fragment == '\"' || fragment == '\\') {
                this.sb.ensureCapacity(this.sb.length() + this.quote);
                for (int i = 1; i < this.quote; ++i) {
                    this.sb.append('\\');
                }
            }
            this.sb.append(fragment);
        }

        public void ensureCanFit(int lengthIncrease) {
            this.sb.ensureCapacity(this.sb.length() + lengthIncrease);
        }
    }
}

