/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import java.util.Locale;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;

public class Oracle12LimitHandler
extends AbstractLimitHandler {
    private boolean bindLimitParametersInReverseOrder;
    private boolean useMaxForLimit;
    private boolean supportOffset;
    public static final Oracle12LimitHandler INSTANCE = new Oracle12LimitHandler();

    Oracle12LimitHandler() {
    }

    @Override
    public String processSql(String sql, Limit limit, QueryOptions queryOptions) {
        return this.processSql(sql, Oracle12LimitHandler.hasFirstRow(limit), Oracle12LimitHandler.hasMaxRows(limit), queryOptions.getLockOptions());
    }

    protected String processSql(String sql, boolean hasFirstRow, boolean hasMaxRows, LockOptions lockOptions) {
        if (lockOptions != null) {
            LockMode lockMode = lockOptions.getLockMode();
            switch (lockMode) {
                case PESSIMISTIC_READ: 
                case PESSIMISTIC_WRITE: 
                case UPGRADE_NOWAIT: 
                case PESSIMISTIC_FORCE_INCREMENT: 
                case UPGRADE_SKIPLOCKED: {
                    return this.processSql(sql, this.getForUpdateIndex(sql), hasFirstRow, hasMaxRows);
                }
            }
            return this.processSqlOffsetFetch(sql, hasFirstRow, hasMaxRows);
        }
        return this.processSqlOffsetFetch(sql, hasFirstRow, hasMaxRows);
    }

    protected String processSqlOffsetFetch(String sql, boolean hasFirstRow, boolean hasMaxRows) {
        int forUpdateLastIndex = this.getForUpdateIndex(sql);
        if (forUpdateLastIndex > -1) {
            return this.processSql(sql, forUpdateLastIndex, hasFirstRow, hasMaxRows);
        }
        this.bindLimitParametersInReverseOrder = false;
        this.useMaxForLimit = false;
        this.supportOffset = true;
        String offsetFetchString = hasFirstRow && hasMaxRows ? " offset ? rows fetch next ? rows only" : (hasFirstRow ? " offset ? rows" : " fetch first ? rows only");
        return this.insertAtEnd(offsetFetchString, sql);
    }

    protected String processSql(String sql, int forUpdateIndex, boolean hasFirstRow, boolean hasMaxRows) {
        StringBuilder pagingSelect;
        this.bindLimitParametersInReverseOrder = true;
        this.useMaxForLimit = true;
        this.supportOffset = false;
        String forUpdateClause = null;
        boolean isForUpdate = false;
        if (forUpdateIndex > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        int forUpdateClauseLength = forUpdateClause == null ? 0 : forUpdateClause.length() + 1;
        if (hasFirstRow && hasMaxRows) {
            pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
            pagingSelect.append("select * from (select row_.*,rownum rownum_ from (");
            pagingSelect.append(sql);
            pagingSelect.append(") row_ where rownum<=?) where rownum_>?");
        } else if (hasFirstRow) {
            pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 98);
            pagingSelect.append("select * from (");
            pagingSelect.append(sql);
            pagingSelect.append(") row_ where rownum>?");
        } else {
            pagingSelect = new StringBuilder(sql.length() + forUpdateClauseLength + 37);
            pagingSelect.append("select * from (");
            pagingSelect.append(sql);
            pagingSelect.append(") where rownum<=?");
        }
        if (isForUpdate) {
            pagingSelect.append(" ");
            pagingSelect.append(forUpdateClause);
        }
        return pagingSelect.toString();
    }

    private int getForUpdateIndex(String sql) {
        int forUpdateLastIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("for update");
        int lastIndexOfQuote = sql.lastIndexOf(39);
        if (forUpdateLastIndex > -1) {
            if (lastIndexOfQuote == -1) {
                return forUpdateLastIndex;
            }
            if (lastIndexOfQuote > forUpdateLastIndex) {
                return -1;
            }
            return forUpdateLastIndex;
        }
        return forUpdateLastIndex;
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return this.supportOffset;
    }

    @Override
    public boolean bindLimitParametersInReverseOrder() {
        return this.bindLimitParametersInReverseOrder;
    }

    @Override
    public boolean useMaxForLimit() {
        return this.useMaxForLimit;
    }
}

