/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.internal.util.StringHelper;

public class DatabaseConnectionInfoImpl
implements DatabaseConnectionInfo {
    public static final String DEFAULT = "undefined/unknown";
    protected String dbUrl = "undefined/unknown";
    protected String dbDriverName = "undefined/unknown";
    protected DatabaseVersion dbVersion = SimpleDatabaseVersion.ZERO_VERSION;
    protected String dbAutoCommitMode = "undefined/unknown";
    protected String dbIsolationLevel = "undefined/unknown";
    protected String dbMinPoolSize = "undefined/unknown";
    protected String dbMaxPoolSize = "undefined/unknown";

    @Override
    public DatabaseConnectionInfo setDBUrl(String dbUrl) {
        this.dbUrl = dbUrl;
        return this;
    }

    @Override
    public DatabaseConnectionInfo setDBDriverName(String dbDriverName) {
        if (this.checkValidString(dbDriverName) && this.isDefaultStringValue(this.dbDriverName)) {
            this.dbDriverName = dbDriverName;
        }
        return this;
    }

    @Override
    public DatabaseConnectionInfo setDBVersion(DatabaseVersion dbVersion) {
        if (this.checkValidVersion(dbVersion) && SimpleDatabaseVersion.ZERO_VERSION.equals(this.dbVersion)) {
            this.dbVersion = dbVersion;
        }
        return this;
    }

    @Override
    public DatabaseConnectionInfo setDBAutoCommitMode(String dbAutoCommitMode) {
        if (this.checkValidString(dbAutoCommitMode) && this.isDefaultStringValue(this.dbAutoCommitMode)) {
            this.dbAutoCommitMode = dbAutoCommitMode;
        }
        return this;
    }

    @Override
    public DatabaseConnectionInfo setDBIsolationLevel(String dbIsolationLevel) {
        if (this.checkValidString(dbIsolationLevel) && this.isDefaultStringValue(this.dbIsolationLevel)) {
            this.dbIsolationLevel = dbIsolationLevel;
        }
        return this;
    }

    @Override
    public DatabaseConnectionInfo setDBMinPoolSize(String minPoolSize) {
        if (this.checkValidInteger(minPoolSize)) {
            this.dbMinPoolSize = minPoolSize;
        }
        return this;
    }

    @Override
    public DatabaseConnectionInfo setDBMaxPoolSize(String maxPoolSize) {
        if (this.checkValidInteger(maxPoolSize)) {
            this.dbMaxPoolSize = maxPoolSize;
        }
        return this;
    }

    private boolean checkValidInteger(String integerString) {
        try {
            return this.checkValidString(integerString) && Integer.parseInt(integerString, 10) >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean checkValidString(String value) {
        return !StringHelper.isBlank(value) && !"null".equalsIgnoreCase(value);
    }

    private boolean checkValidVersion(DatabaseVersion version) {
        return version != null && !version.isSame(SimpleDatabaseVersion.ZERO_VERSION) && !version.isSame(-9999);
    }

    private boolean isDefaultStringValue(String value) {
        return DEFAULT.equalsIgnoreCase(value);
    }

    @Override
    public String getDBInfoAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tDatabase JDBC URL [").append(this.dbUrl).append(']');
        sb.append(sb.length() > 0 ? "\n\t" : "").append("Database driver: ").append(this.dbDriverName);
        sb.append(sb.length() > 0 ? "\n\t" : "").append("Database version: ").append(this.dbVersion);
        sb.append(sb.length() > 0 ? "\n\t" : "").append("Autocommit mode: ").append(this.dbAutoCommitMode);
        sb.append(sb.length() > 0 ? "\n\t" : "").append("Isolation level: ").append(this.dbIsolationLevel);
        sb.append(sb.length() > 0 ? "\n\t" : "").append("Minimum pool size: ").append(this.dbMinPoolSize);
        sb.append(sb.length() > 0 ? "\n\t" : "").append("Maximum pool size: ").append(this.dbMaxPoolSize);
        return sb.toString();
    }
}

