/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.CascadingAction;
import org.hibernate.engine.spi.CascadingActions;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.jboss.logging.Logger;

public final class CascadeStyles {
    private static final @UnknownKeyFor @NonNull @Initialized Logger log = Logger.getLogger(CascadeStyles.class);
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle ALL_DELETE_ORPHAN = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action != CascadingActions.CHECK_ON_FLUSH;
        }

        @Override
        public boolean hasOrphanDelete() {
            return true;
        }

        public String toString() {
            return "STYLE_ALL_DELETE_ORPHAN";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle ALL = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action != CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_ALL";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle LOCK = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.LOCK || action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_LOCK";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle REFRESH = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.REFRESH || action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_REFRESH";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle EVICT = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.EVICT || action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_EVICT";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle REPLICATE = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.REPLICATE || action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_REPLICATE";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle MERGE = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.MERGE || action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_MERGE";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle PERSIST = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.PERSIST || action == CascadingActions.PERSIST_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_PERSIST";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle DELETE = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.REMOVE || action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_DELETE";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle DELETE_ORPHAN = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.REMOVE || action == CascadingActions.PERSIST_ON_FLUSH || action == CascadingActions.CHECK_ON_FLUSH;
        }

        @Override
        public boolean reallyDoCascade(CascadingAction action) {
            return action == CascadingActions.REMOVE || action == CascadingActions.CHECK_ON_FLUSH;
        }

        @Override
        public boolean hasOrphanDelete() {
            return true;
        }

        public String toString() {
            return "STYLE_DELETE_ORPHAN";
        }
    };
    public static final @UnknownKeyFor @NonNull @Initialized CascadeStyle NONE = new BaseCascadeStyle(){

        @Override
        public boolean doCascade(CascadingAction action) {
            return action == CascadingActions.CHECK_ON_FLUSH;
        }

        public String toString() {
            return "STYLE_NONE";
        }
    };
    private static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CascadeStyle> STYLES = CascadeStyles.buildBaseCascadeStyleMap();

    private CascadeStyles() {
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized CascadeStyle> buildBaseCascadeStyleMap() {
        HashMap<String, CascadeStyle> base = new HashMap<String, CascadeStyle>();
        base.put("all", ALL);
        base.put("all-delete-orphan", ALL_DELETE_ORPHAN);
        base.put("persist", PERSIST);
        base.put("merge", MERGE);
        base.put("lock", LOCK);
        base.put("refresh", REFRESH);
        base.put("replicate", REPLICATE);
        base.put("evict", EVICT);
        base.put("delete", DELETE);
        base.put("remove", DELETE);
        base.put("delete-orphan", DELETE_ORPHAN);
        base.put("none", NONE);
        return base;
    }

    public static @UnknownKeyFor @NonNull @Initialized CascadeStyle getCascadeStyle(@UnknownKeyFor @NonNull @Initialized String cascade) {
        CascadeStyle style = STYLES.get(cascade);
        if (style == null) {
            throw new MappingException("Unsupported cascade style: " + cascade);
        }
        return style;
    }

    public static void registerCascadeStyle(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized BaseCascadeStyle cascadeStyle) {
        log.tracef("Registering external cascade style [%s : %s]", (Object)name, (Object)cascadeStyle);
        CascadeStyle old = STYLES.put(name, cascadeStyle);
        if (old != null) {
            log.debugf("External cascade style registration [%s : %s] overrode base registration [%s]", (Object)name, (Object)cascadeStyle, (Object)old);
        }
    }

    public static final class MultipleCascadeStyle
    extends BaseCascadeStyle {
        private final @UnknownKeyFor @NonNull @Initialized CascadeStyle @UnknownKeyFor @NonNull @Initialized [] styles;

        public MultipleCascadeStyle(@UnknownKeyFor @NonNull @Initialized CascadeStyle @UnknownKeyFor @NonNull @Initialized [] styles) {
            this.styles = styles;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean doCascade(@UnknownKeyFor @NonNull @Initialized CascadingAction action) {
            if (action == CascadingActions.CHECK_ON_FLUSH) {
                return !this.reallyDoCascade(CascadingActions.PERSIST_ON_FLUSH);
            }
            for (CascadeStyle style : this.styles) {
                if (!style.doCascade(action)) continue;
                return true;
            }
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean reallyDoCascade(@UnknownKeyFor @NonNull @Initialized CascadingAction action) {
            for (CascadeStyle style : this.styles) {
                if (!style.reallyDoCascade(action)) continue;
                return true;
            }
            return false;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean hasOrphanDelete() {
            for (CascadeStyle style : this.styles) {
                if (!style.hasOrphanDelete()) continue;
                return true;
            }
            return false;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return ArrayHelper.toString(this.styles);
        }
    }

    public static abstract class BaseCascadeStyle
    implements CascadeStyle {
        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean reallyDoCascade(@UnknownKeyFor @NonNull @Initialized CascadingAction action) {
            return this.doCascade(action);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean hasOrphanDelete() {
            return false;
        }
    }
}

