/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.insert;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.EventType;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.internal.GeneratedValuesHelper;
import org.hibernate.id.insert.GetGeneratedKeysDelegate;
import org.hibernate.metamodel.mapping.BasicEntityIdentifierMapping;
import org.hibernate.persister.entity.EntityPersister;

public class SybaseJConnGetGeneratedKeysDelegate
extends GetGeneratedKeysDelegate {
    public SybaseJConnGetGeneratedKeysDelegate(EntityPersister persister) {
        super(persister, true, EventType.INSERT);
    }

    @Override
    public String prepareIdentifierGeneratingInsert(String insertSQL) {
        return this.dialect().getIdentityColumnSupport().appendIdentitySelectToInsert(((BasicEntityIdentifierMapping)this.persister.getRootEntityDescriptor().getIdentifierMapping()).getSelectionExpression(), insertSQL);
    }

    @Override
    public GeneratedValues executeAndExtractReturning(String sql, PreparedStatement preparedStatement, SharedSessionContractImplementor session) {
        JdbcCoordinator jdbcCoordinator = session.getJdbcCoordinator();
        JdbcServices jdbcServices = session.getJdbcServices();
        ResultSet resultSet = jdbcCoordinator.getResultSetReturn().execute(preparedStatement, sql);
        try {
            return GeneratedValuesHelper.getGeneratedValues(resultSet, this.persister, this.getTiming(), session);
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to extract generated-keys ResultSet", sql);
        }
    }
}

