/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@MessageLogger(projectCode="HHH")
@ValidIdRange(min=15001, max=20000)
public interface EntityManagerMessageLogger
extends CoreMessageLogger {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Illegal argument on static metamodel field injection : %s#%s; expected type :  %s; encountered type : %s", id=15007)
    public void illegalArgumentOnStaticMetamodelFieldInjection(String var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to locate static metamodel field : %s#%s; this may or may not indicate a problem with the static metamodel", id=15011)
    public void unableToLocateStaticMetamodelField(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Returning null (as required by JPA spec) rather than throwing EntityNotFoundException, as the entity (type=%s, id=%s) does not exist", id=15013)
    public void ignoringEntityNotFound(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=15015, value="Encountered a MappedSuperclass [%s] not used in any entity hierarchy")
    public void unusedMappedSuperclass(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15016, value="Encountered a deprecated jakarta.persistence.spi.PersistenceProvider [%s]; [%s] will be used instead.")
    public void deprecatedPersistenceProvider(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15017, value="'hibernate.ejb.use_class_enhancer' property is deprecated. Use 'hibernate.enhance.enable[...]' properties instead to enable each individual feature.")
    public void deprecatedInstrumentationProperty();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15018, value="Encountered multiple persistence-unit stanzas defining same name [%s]; persistence-unit names must be unique")
    public void duplicatedPersistenceUnitName(String var1);
}

