/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa;

import jakarta.persistence.PersistenceConfiguration;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import java.util.Map;
import java.util.Objects;
import org.hibernate.SessionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.jpa.CachingType;
import org.hibernate.resource.jdbc.spi.StatementInspector;

public class HibernatePersistenceConfiguration
extends PersistenceConfiguration {
    public HibernatePersistenceConfiguration(String name) {
        super(name);
    }

    public SessionFactory createEntityManagerFactory() {
        return (SessionFactory)super.createEntityManagerFactory();
    }

    public HibernatePersistenceConfiguration jdbcDriver(String driverName) {
        this.property("jakarta.persistence.jdbc.driver", driverName);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcUrl(String url) {
        this.property("jakarta.persistence.jdbc.url", url);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcUsername(String username) {
        this.property("jakarta.persistence.jdbc.user", username);
        return this;
    }

    public HibernatePersistenceConfiguration jdbcPassword(String password) {
        this.property("jakarta.persistence.jdbc.password", password);
        return this;
    }

    public HibernatePersistenceConfiguration queryCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.query", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration transactionCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.transaction", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration closedCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.closed", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration proxyCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.proxy", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration cachingCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.proxy", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration globalGeneratorCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.global_id_generators", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration orderByMappingCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.orderby", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration loadByIdCompliance(boolean enabled) {
        this.property("hibernate.jpa.compliance.load_by_id", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration caching(CachingType type) {
        assert (Objects.nonNull((Object)type));
        if (type == CachingType.NONE || type == CachingType.AUTO) {
            this.property("hibernate.cache.use_second_level_cache", false);
            this.property("hibernate.cache.use_query_cache", false);
        } else if (type == CachingType.BOTH) {
            this.property("hibernate.cache.use_second_level_cache", true);
            this.property("hibernate.cache.use_query_cache", true);
        } else if (type == CachingType.DATA) {
            this.property("hibernate.cache.use_second_level_cache", true);
            this.property("hibernate.cache.use_query_cache", false);
        } else if (type == CachingType.QUERY) {
            this.property("hibernate.cache.use_second_level_cache", false);
            this.property("hibernate.cache.use_query_cache", true);
        }
        return this;
    }

    public HibernatePersistenceConfiguration cachingAccessType(AccessType type) {
        this.property("hibernate.cache.default_cache_concurrency_strategy", (Object)type);
        return this;
    }

    public HibernatePersistenceConfiguration statementInspector(Class<? extends StatementInspector> inspectorImpl) {
        this.property("hibernate.session_factory.statement_inspector", inspectorImpl);
        return this;
    }

    public HibernatePersistenceConfiguration statementInspector(StatementInspector inspector) {
        this.property("hibernate.session_factory.statement_inspector", inspector);
        return this;
    }

    public HibernatePersistenceConfiguration defaultCatalog(String catalogName) {
        this.property("hibernate.default_catalog", catalogName);
        return this;
    }

    public HibernatePersistenceConfiguration defaultSchema(String schemaName) {
        this.property("hibernate.default_schema", schemaName);
        return this;
    }

    public HibernatePersistenceConfiguration nationalizedCharacterData(boolean enabled) {
        this.property("hibernate.use_nationalized_character_data", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration xmlMappings(boolean enabled) {
        this.property("hibernate.xml_mapping_enabled", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration xmlValidation(boolean enabled) {
        this.property("hibernate.validate_xml", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration collectStatistics(boolean enabled) {
        this.property("hibernate.generate_statistics", enabled);
        return this;
    }

    public HibernatePersistenceConfiguration provider(String providerClassName) {
        return (HibernatePersistenceConfiguration)super.provider(providerClassName);
    }

    public HibernatePersistenceConfiguration jtaDataSource(String dataSourceJndiName) {
        return (HibernatePersistenceConfiguration)super.jtaDataSource(dataSourceJndiName);
    }

    public HibernatePersistenceConfiguration nonJtaDataSource(String dataSourceJndiName) {
        return (HibernatePersistenceConfiguration)super.nonJtaDataSource(dataSourceJndiName);
    }

    public HibernatePersistenceConfiguration managedClass(Class<?> managedClass) {
        return (HibernatePersistenceConfiguration)super.managedClass(managedClass);
    }

    public HibernatePersistenceConfiguration mappingFile(String name) {
        return (HibernatePersistenceConfiguration)super.mappingFile(name);
    }

    public HibernatePersistenceConfiguration transactionType(PersistenceUnitTransactionType transactionType) {
        return (HibernatePersistenceConfiguration)super.transactionType(transactionType);
    }

    public HibernatePersistenceConfiguration sharedCacheMode(SharedCacheMode sharedCacheMode) {
        return (HibernatePersistenceConfiguration)super.sharedCacheMode(sharedCacheMode);
    }

    public HibernatePersistenceConfiguration validationMode(ValidationMode validationMode) {
        return (HibernatePersistenceConfiguration)super.validationMode(validationMode);
    }

    public HibernatePersistenceConfiguration property(String name, Object value) {
        return (HibernatePersistenceConfiguration)super.property(name, value);
    }

    public HibernatePersistenceConfiguration properties(Map<String, ?> properties) {
        return (HibernatePersistenceConfiguration)super.properties(properties);
    }
}

