/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.boot.model.internal.SoftDeleteHelper;
import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.internal.FetchProfileAffectee;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.Generator;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SoftDeletable;
import org.hibernate.metamodel.mapping.AttributeMetadata;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SoftDeletableModelPart;
import org.hibernate.metamodel.mapping.SoftDeleteMapping;
import org.hibernate.metamodel.mapping.TableDetails;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.OneToManyCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.mapping.ordering.OrderByFragmentTranslator;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.mutation.CollectionMutationTarget;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.internal.TableGroupJoinHelper;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.CollectionTableGroup;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.OneToManyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateCollector;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.collection.internal.DelayedCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.SelectEagerCollectionFetch;
import org.jboss.logging.Logger;

public class PluralAttributeMappingImpl
extends AbstractAttributeMapping
implements PluralAttributeMapping,
FetchProfileAffectee,
FetchOptions {
    private static final Logger log = Logger.getLogger(PluralAttributeMappingImpl.class);
    private final CollectionMappingType collectionMappingType;
    private final String referencedPropertyName;
    private final String mapKeyPropertyName;
    private final CollectionPart elementDescriptor;
    private final CollectionPart indexDescriptor;
    private final CollectionIdentifierDescriptor identifierDescriptor;
    private final FetchTiming fetchTiming;
    private final FetchStyle fetchStyle;
    private final SoftDeleteMapping softDeleteMapping;
    private Boolean hasSoftDelete;
    private final String bidirectionalAttributeName;
    private final CollectionPersister collectionDescriptor;
    private final String separateCollectionTable;
    private final String sqlAliasStem;
    private final PluralAttributeMapping.IndexMetadata indexMetadata;
    private ForeignKeyDescriptor fkDescriptor;
    private OrderByFragment orderByFragment;
    private OrderByFragment manyToManyOrderByFragment;

    public PluralAttributeMappingImpl(String attributeName, Collection bootDescriptor, PropertyAccess propertyAccess, AttributeMetadata attributeMetadata, CollectionMappingType<?> collectionMappingType, int stateArrayPosition, int fetchableIndex, CollectionPart elementDescriptor, final CollectionPart indexDescriptor, CollectionIdentifierDescriptor identifierDescriptor, FetchTiming fetchTiming, FetchStyle fetchStyle, CascadeStyle cascadeStyle, ManagedMappingType declaringType, CollectionPersister collectionDescriptor, MappingModelCreationProcess creationProcess) {
        super(attributeName, fetchableIndex, declaringType, attributeMetadata, stateArrayPosition, propertyAccess);
        this.collectionMappingType = collectionMappingType;
        this.elementDescriptor = elementDescriptor;
        this.indexDescriptor = indexDescriptor;
        this.identifierDescriptor = identifierDescriptor;
        this.fetchTiming = fetchTiming;
        this.fetchStyle = fetchStyle;
        this.collectionDescriptor = collectionDescriptor;
        this.referencedPropertyName = bootDescriptor.getReferencedPropertyName();
        this.mapKeyPropertyName = bootDescriptor instanceof Map ? ((Map)bootDescriptor).getMapKeyPropertyName() : null;
        this.bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(bootDescriptor.getMappedByProperty(), Character.valueOf('.'));
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(attributeName);
        this.separateCollectionTable = bootDescriptor.isOneToMany() ? null : collectionDescriptor.getTableName();
        final int baseIndex = bootDescriptor instanceof List ? ((List)bootDescriptor).getBaseIndex() : -1;
        this.indexMetadata = new PluralAttributeMapping.IndexMetadata(){

            @Override
            public CollectionPart getIndexDescriptor() {
                return indexDescriptor;
            }

            @Override
            public int getListIndexBase() {
                return baseIndex;
            }

            @Override
            public String getIndexPropertyName() {
                return PluralAttributeMappingImpl.this.mapKeyPropertyName;
            }
        };
        this.softDeleteMapping = SoftDeleteHelper.resolveSoftDeleteMapping((SoftDeletableModelPart)this, (SoftDeletable)bootDescriptor, this.getSeparateCollectionTable(), creationProcess.getCreationContext().getDialect());
        PluralAttributeMappingImpl.injectAttributeMapping(elementDescriptor, indexDescriptor, collectionDescriptor, this);
    }

    protected PluralAttributeMappingImpl(PluralAttributeMappingImpl original) {
        super(original);
        this.collectionMappingType = original.collectionMappingType;
        this.elementDescriptor = original.elementDescriptor;
        this.indexDescriptor = original.indexDescriptor;
        this.identifierDescriptor = original.identifierDescriptor;
        this.fetchTiming = original.fetchTiming;
        this.fetchStyle = original.fetchStyle;
        this.softDeleteMapping = original.softDeleteMapping;
        this.hasSoftDelete = original.hasSoftDelete;
        this.collectionDescriptor = original.collectionDescriptor;
        this.referencedPropertyName = original.referencedPropertyName;
        this.mapKeyPropertyName = original.mapKeyPropertyName;
        this.bidirectionalAttributeName = original.bidirectionalAttributeName;
        this.sqlAliasStem = original.sqlAliasStem;
        this.separateCollectionTable = original.separateCollectionTable;
        this.indexMetadata = original.indexMetadata;
        this.fkDescriptor = original.fkDescriptor;
        this.orderByFragment = original.orderByFragment;
        this.manyToManyOrderByFragment = original.manyToManyOrderByFragment;
        PluralAttributeMappingImpl.injectAttributeMapping(this.elementDescriptor, this.indexDescriptor, this.collectionDescriptor, this);
    }

    private static void injectAttributeMapping(CollectionPart elementDescriptor, CollectionPart indexDescriptor, CollectionPersister collectionDescriptor, PluralAttributeMapping mapping) {
        if (collectionDescriptor instanceof Aware) {
            ((Aware)((Object)collectionDescriptor)).injectAttributeMapping(mapping);
        }
        if (elementDescriptor instanceof Aware) {
            ((Aware)((Object)elementDescriptor)).injectAttributeMapping(mapping);
        }
        if (indexDescriptor instanceof Aware) {
            ((Aware)((Object)indexDescriptor)).injectAttributeMapping(mapping);
        }
    }

    @Override
    public boolean isBidirectionalAttributeName(NavigablePath fetchablePath, ToOneAttributeMapping modelPart) {
        if (this.bidirectionalAttributeName == null) {
            return this.fkDescriptor.getTargetPart() == modelPart.getForeignKeyDescriptor().getTargetPart();
        }
        return fetchablePath.getLocalName().endsWith(this.bidirectionalAttributeName);
    }

    public void finishInitialization(Property bootProperty, Collection bootDescriptor, MappingModelCreationProcess creationProcess) {
        block8: {
            boolean hasManyToManyOrder;
            boolean hasOrder;
            block7: {
                hasOrder = bootDescriptor.getOrderBy() != null;
                boolean bl = hasManyToManyOrder = bootDescriptor.getManyToManyOrdering() != null;
                if (hasOrder) break block7;
                if (!hasManyToManyOrder) break block8;
            }
            TranslationContext context = this.collectionDescriptor::getFactory;
            if (hasOrder) {
                if (log.isDebugEnabled()) {
                    log.debugf("Translating order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                }
                this.orderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getOrderBy(), this, context);
            }
            if (hasManyToManyOrder) {
                if (log.isDebugEnabled()) {
                    log.debugf("Translating many-to-many order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                }
                this.manyToManyOrderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getManyToManyOrdering(), this, context);
            }
        }
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getCollectionDescriptor().getNavigableRole();
    }

    @Override
    public CollectionMappingType getMappedType() {
        return this.collectionMappingType;
    }

    @Override
    public ForeignKeyDescriptor getKeyDescriptor() {
        return this.fkDescriptor;
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionPart getElementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public CollectionPart getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public PluralAttributeMapping.IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    @Override
    public CollectionIdentifierDescriptor getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public SoftDeleteMapping getSoftDeleteMapping() {
        return this.softDeleteMapping;
    }

    @Override
    public TableDetails getSoftDeleteTableDetails() {
        return ((CollectionMutationTarget)((Object)this.getCollectionDescriptor())).getCollectionTableMapping();
    }

    @Override
    public OrderByFragment getOrderByFragment() {
        return this.orderByFragment;
    }

    @Override
    public OrderByFragment getManyToManyOrderByFragment() {
        return this.manyToManyOrderByFragment;
    }

    @Override
    public String getSeparateCollectionTable() {
        return this.separateCollectionTable;
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return tableExpression.equals(this.separateCollectionTable);
    }

    @Override
    public Generator getGenerator() {
        return null;
    }

    @Override
    public String getFetchableName() {
        return this.getAttributeName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return this.fetchStyle;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasPartitionedSelectionMapping() {
        return false;
    }

    @Override
    public void applySoftDeleteRestrictions(TableGroup tableGroup, PluralAttributeMapping.PredicateConsumer predicateConsumer) {
        SoftDeleteMapping softDeleteMapping;
        EntityCollectionPart elementDescriptor;
        EntityMappingType associatedEntityDescriptor;
        SoftDeleteMapping softDeleteMapping2;
        if (!this.hasSoftDelete()) {
            return;
        }
        if ((this.getCollectionDescriptor().isOneToMany() || this.getCollectionDescriptor().isManyToMany()) && (softDeleteMapping2 = (associatedEntityDescriptor = (elementDescriptor = (EntityCollectionPart)this.getElementDescriptor()).getAssociatedEntityMappingType()).getSoftDeleteMapping()) != null) {
            Predicate softDeleteRestriction = SoftDeleteHelper.createNonSoftDeletedRestriction(tableGroup.resolveTableReference(associatedEntityDescriptor.getSoftDeleteTableDetails().getTableName()), softDeleteMapping2);
            predicateConsumer.applyPredicate(softDeleteRestriction);
        }
        if ((softDeleteMapping = this.getSoftDeleteMapping()) != null) {
            Predicate softDeleteRestriction = SoftDeleteHelper.createNonSoftDeletedRestriction(tableGroup.resolveTableReference(this.getSoftDeleteTableDetails().getTableName()), softDeleteMapping);
            predicateConsumer.applyPredicate(softDeleteRestriction);
        }
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup collectionTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        assert (collectionTableGroup != null);
        creationState.registerVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
        return new CollectionDomainResult(navigablePath, this, resultVariable, tableGroup, creationState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        boolean added = creationState.registerVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
        try {
            if (fetchTiming == FetchTiming.IMMEDIATE) {
                if (selected) {
                    TableGroup collectionTableGroup = this.resolveCollectionTableGroup(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                    Fetch fetch = this.buildEagerCollectionFetch(fetchablePath, this, collectionTableGroup, this.referencedPropertyName != null, fetchParent, creationState);
                    return fetch;
                }
                Fetch fetch = this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                return fetch;
            }
            if (this.getCollectionDescriptor().getCollectionType().hasHolder()) {
                Fetch fetch = this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                return fetch;
            }
            Fetch fetch = this.createDelayedCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
            return fetch;
        }
        finally {
            if (added) {
                creationState.removeVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
            }
        }
    }

    protected Fetch buildDelayedCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, FetchParent fetchParent, DomainResult<?> collectionKeyResult, boolean unfetched) {
        return new DelayedCollectionFetch(fetchedPath, fetchedAttribute, fetchParent, collectionKeyResult, unfetched);
    }

    protected Fetch buildSelectEagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, DomainResult<?> collectionKeyDomainResult, FetchParent fetchParent) {
        return new SelectEagerCollectionFetch(fetchedPath, fetchedAttribute, collectionKeyDomainResult, fetchParent);
    }

    protected Fetch buildEagerCollectionFetch(NavigablePath fetchedPath, PluralAttributeMapping fetchedAttribute, TableGroup collectionTableGroup, boolean needsCollectionKeyResult, FetchParent fetchParent, DomainResultCreationState creationState) {
        return new EagerCollectionFetch(fetchedPath, fetchedAttribute, collectionTableGroup, needsCollectionKeyResult, fetchParent, creationState);
    }

    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, FetchTiming fetchTiming, DomainResultCreationState creationState) {
        boolean alreadyVisited;
        if (fetchTiming == FetchTiming.IMMEDIATE && (alreadyVisited = creationState.isAssociationKeyVisited(this.fkDescriptor.getAssociationKey()))) {
            return this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, creationState.getSqlAstCreationState());
        }
        return null;
    }

    private Fetch createSelectEagerCollectionFetch(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        DomainResult<?> collectionKeyDomainResult = this.referencedPropertyName != null ? this.getKeyDescriptor().createTargetDomainResult(fetchablePath, sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), fetchParent, creationState) : null;
        return this.buildSelectEagerCollectionFetch(fetchablePath, this, collectionKeyDomainResult, fetchParent);
    }

    private TableGroup resolveCollectionTableGroup(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        return fromClauseAccess.resolveTableGroup(fetchablePath, p -> {
            TableGroup lhsTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, null, SqlAstJoinType.LEFT, true, false, creationState.getSqlAstCreationState());
            lhsTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
    }

    private Fetch createDelayedCollectionFetch(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        boolean unfetched;
        DomainResult<?> collectionKeyDomainResult;
        EntityMappingType containingEntityMapping = this.findContainingEntityMapping();
        if (fetchParent.getReferencedModePart() == containingEntityMapping && containingEntityMapping.getEntityPersister().getPropertyLaziness()[this.getStateArrayPosition()]) {
            collectionKeyDomainResult = null;
            unfetched = true;
        } else {
            collectionKeyDomainResult = this.referencedPropertyName != null ? this.getKeyDescriptor().createTargetDomainResult(fetchablePath, sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), fetchParent, creationState) : null;
            unfetched = false;
        }
        return this.buildDelayedCollectionFetch(fetchablePath, this, fetchParent, collectionKeyDomainResult, unfetched);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public boolean isSimpleJoinPredicate(Predicate predicate) {
        return this.fkDescriptor.isSimpleJoinPredicate(predicate);
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, SqlAstCreationState creationState) {
        PredicateCollector collectionPredicateCollector = new PredicateCollector();
        TableGroup tableGroup = this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, addsPredicate, collectionPredicateCollector::applyPredicate, creationState);
        PredicateCollector predicateCollector = tableGroup.getNestedTableGroupJoins().isEmpty() ? new PredicateCollector() : collectionPredicateCollector;
        this.getCollectionDescriptor().applyBaseRestrictions(predicateCollector::applyPredicate, tableGroup, true, creationState.getLoadQueryInfluencers().getEnabledFilters(), false, null, creationState);
        this.getCollectionDescriptor().applyBaseManyToManyRestrictions(predicateCollector::applyPredicate, tableGroup, true, creationState.getLoadQueryInfluencers().getEnabledFilters(), null, creationState);
        this.applySoftDeleteRestriction(predicateCollector::applyPredicate, tableGroup, creationState);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, this.determineSqlJoinType(lhs, requestedJoinType, fetched), tableGroup, collectionPredicateCollector.getPredicate());
        if (predicateCollector != collectionPredicateCollector) {
            TableGroupJoin joinForPredicate = TableGroupJoinHelper.determineJoinForPredicateApply(tableGroupJoin);
            joinForPredicate.applyPredicate(predicateCollector.getPredicate());
        }
        return tableGroupJoin;
    }

    private boolean hasSoftDelete() {
        if (this.hasSoftDelete == null) {
            EntityMappingType associatedEntityMapping;
            this.hasSoftDelete = this.softDeleteMapping != null ? Boolean.valueOf(true) : (this.getElementDescriptor() instanceof EntityCollectionPart ? Boolean.valueOf((associatedEntityMapping = ((EntityCollectionPart)this.getElementDescriptor()).getAssociatedEntityMappingType()).getSoftDeleteMapping() != null) : Boolean.valueOf(false));
        }
        return this.hasSoftDelete;
    }

    private void applySoftDeleteRestriction(Consumer<Predicate> predicateConsumer, TableGroup tableGroup, SqlAstCreationState creationState) {
        SoftDeleteMapping softDeleteMapping;
        EntityMappingType entityMappingType;
        SoftDeleteMapping softDeleteMapping2;
        if (!this.hasSoftDelete()) {
            return;
        }
        if (this.getElementDescriptor() instanceof EntityCollectionPart && (softDeleteMapping2 = (entityMappingType = ((EntityCollectionPart)this.getElementDescriptor()).getAssociatedEntityMappingType()).getSoftDeleteMapping()) != null) {
            TableDetails softDeleteTable = entityMappingType.getSoftDeleteTableDetails();
            predicateConsumer.accept(SoftDeleteHelper.createNonSoftDeletedRestriction(tableGroup.resolveTableReference(softDeleteTable.getTableName()), softDeleteMapping2, creationState.getSqlExpressionResolver()));
        }
        if ((softDeleteMapping = this.getSoftDeleteMapping()) != null) {
            TableDetails softDeleteTable = this.getSoftDeleteTableDetails();
            predicateConsumer.accept(SoftDeleteHelper.createNonSoftDeletedRestriction(tableGroup.resolveTableReference(softDeleteTable.getTableName()), softDeleteMapping, creationState.getSqlExpressionResolver()));
        }
    }

    @Override
    public SqlAstJoinType determineSqlJoinType(TableGroup lhs, SqlAstJoinType requestedJoinType, boolean fetched) {
        if (this.hasSoftDelete()) {
            return SqlAstJoinType.LEFT;
        }
        if (requestedJoinType == null) {
            if (fetched) {
                return this.getDefaultSqlAstJoinType(lhs);
            }
            return SqlAstJoinType.INNER;
        }
        return requestedJoinType;
    }

    @Override
    public TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType requestedJoinType, boolean fetched, Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        return this.createRootTableGroupJoin(navigablePath, lhs, explicitSourceAlias, explicitSqlAliasBase, requestedJoinType, fetched, false, predicateConsumer, creationState);
    }

    private TableGroup createRootTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstJoinType requestedJoinType, boolean fetched, boolean addsPredicate, Consumer<Predicate> predicateConsumer, SqlAstCreationState creationState) {
        CollectionPersister collectionDescriptor = this.getCollectionDescriptor();
        SqlAstJoinType joinType = this.determineSqlJoinType(lhs, requestedJoinType, fetched);
        SqlAliasBase sqlAliasBase = creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem());
        TableGroup tableGroup = collectionDescriptor.isOneToMany() ? this.createOneToManyTableGroup(lhs.canUseInnerJoins() && joinType == SqlAstJoinType.INNER, navigablePath, fetched, explicitSourceAlias, sqlAliasBase, creationState) : this.createCollectionTableGroup(lhs.canUseInnerJoins() && joinType == SqlAstJoinType.INNER, joinType, navigablePath, fetched, addsPredicate, explicitSourceAlias, sqlAliasBase, creationState);
        if (predicateConsumer != null) {
            predicateConsumer.accept(this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, creationState));
        }
        return tableGroup;
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor fkDescriptor) {
        this.fkDescriptor = fkDescriptor;
    }

    private TableGroup createOneToManyTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstCreationState creationState) {
        SqlAliasBase sqlAliasBase = SqlAliasBase.from(explicitSqlAliasBase, sourceAlias, this, creationState.getSqlAliasBaseGenerator());
        TableGroup elementTableGroup = ((OneToManyCollectionPart)this.elementDescriptor).createAssociatedTableGroup(canUseInnerJoins, navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), fetched, sourceAlias, sqlAliasBase, creationState);
        OneToManyTableGroup tableGroup = new OneToManyTableGroup(this, elementTableGroup, creationState.getCreationContext().getSessionFactory());
        if (this.indexDescriptor instanceof TableGroupJoinProducer) {
            TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)this.indexDescriptor)).createTableGroupJoin(navigablePath.append(CollectionPart.Nature.INDEX.getName()), tableGroup, null, sqlAliasBase, SqlAstJoinType.INNER, fetched, false, creationState);
            tableGroup.registerIndexTableGroup(tableGroupJoin);
        }
        return tableGroup;
    }

    private TableGroup createCollectionTableGroup(boolean canUseInnerJoins, SqlAstJoinType joinType, NavigablePath navigablePath, boolean fetched, boolean addsPredicate, String sourceAlias, SqlAliasBase explicitSqlAliasBase, SqlAstCreationState creationState) {
        TableGroupJoin tableGroupJoin;
        boolean nestedJoin;
        assert (!this.getCollectionDescriptor().isOneToMany());
        SqlAliasBase sqlAliasBase = SqlAliasBase.from(explicitSqlAliasBase, sourceAlias, this, creationState.getSqlAliasBaseGenerator());
        String collectionTableName = this.collectionDescriptor.getTableName();
        NamedTableReference collectionTableReference = new NamedTableReference(collectionTableName, sqlAliasBase.generateNewAlias(), true);
        CollectionTableGroup tableGroup = new CollectionTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, (TableReference)collectionTableReference, true, sqlAliasBase, s -> false, null, creationState.getCreationContext().getSessionFactory());
        boolean bl = nestedJoin = joinType != SqlAstJoinType.INNER && (addsPredicate || this.isAffectedByEnabledFilters(creationState.getLoadQueryInfluencers(), creationState.applyOnlyLoadByKeyFilters()) || this.collectionDescriptor.hasWhereRestrictions());
        if (this.elementDescriptor instanceof TableGroupJoinProducer) {
            tableGroupJoin = ((TableGroupJoinProducer)((Object)this.elementDescriptor)).createTableGroupJoin(navigablePath.append(CollectionPart.Nature.ELEMENT.getName()), tableGroup, null, sqlAliasBase, nestedJoin ? SqlAstJoinType.INNER : joinType, fetched, false, creationState);
            tableGroup.registerElementTableGroup(tableGroupJoin, nestedJoin);
        }
        if (this.indexDescriptor instanceof TableGroupJoinProducer) {
            tableGroupJoin = ((TableGroupJoinProducer)((Object)this.indexDescriptor)).createTableGroupJoin(navigablePath.append(CollectionPart.Nature.INDEX.getName()), tableGroup, null, sqlAliasBase, nestedJoin ? SqlAstJoinType.INNER : joinType, fetched, false, creationState);
            tableGroup.registerIndexTableGroup(tableGroupJoin, nestedJoin);
        }
        return tableGroup;
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, SqlAliasBase explicitSqlAliasBase, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState) {
        if (this.getCollectionDescriptor().isOneToMany()) {
            return this.createOneToManyTableGroup(canUseInnerJoins, navigablePath, false, explicitSourceAlias, explicitSqlAliasBase, creationState);
        }
        return this.createCollectionTableGroup(canUseInnerJoins, SqlAstJoinType.INNER, navigablePath, false, false, explicitSourceAlias, explicitSqlAliasBase, creationState);
    }

    @Override
    public int getBatchSize() {
        return this.getCollectionDescriptor().getBatchSize();
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers, boolean onlyApplyForLoadByKeyFilters) {
        return this.getCollectionDescriptor().isAffectedByEnabledFilters(influencers, onlyApplyForLoadByKeyFilters);
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEntityGraph(influencers);
    }

    @Override
    public void registerAffectingFetchProfile(String fetchProfileName) {
        if (this.collectionDescriptor instanceof FetchProfileAffectee) {
            ((FetchProfileAffectee)((Object)this.collectionDescriptor)).registerAffectingFetchProfile(fetchProfileName);
        }
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    public String getRootPathName() {
        return this.getCollectionDescriptor().getRole();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        ModelPart subPart;
        if (this.elementDescriptor instanceof ModelPartContainer && (subPart = ((ModelPartContainer)((Object)this.elementDescriptor)).findSubPart(name, null)) != null) {
            return subPart;
        }
        CollectionPart.Nature nature = CollectionPart.Nature.fromName(name);
        if (nature != null) {
            switch (nature) {
                case ELEMENT: {
                    return this.elementDescriptor;
                }
                case INDEX: {
                    return this.indexDescriptor;
                }
                case ID: {
                    return this.identifierDescriptor;
                }
            }
        }
        return null;
    }

    @Override
    public void forEachSubPart(IndexedConsumer<ModelPart> consumer, EntityMappingType treatTarget) {
        consumer.accept(0, this.elementDescriptor);
        int position = 1;
        if (this.indexDescriptor != null) {
            consumer.accept(position++, this.indexDescriptor);
        }
        if (this.identifierDescriptor != null) {
            consumer.accept(position + 1, this.identifierDescriptor);
        }
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.elementDescriptor.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.elementDescriptor.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public <X, Y> int breakDownJdbcValues(Object domainValue, int offset, X x, Y y, ModelPart.JdbcValueBiConsumer<X, Y> valueConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.elementDescriptor);
        if (this.indexDescriptor != null) {
            consumer.accept(this.indexDescriptor);
        }
    }

    @Override
    public String getContainingTableExpression() {
        return this.getKeyDescriptor().getKeyTable();
    }

    @Override
    public int getJdbcTypeCount() {
        return 0;
    }

    @Override
    public JdbcMapping getJdbcMapping(int index) {
        throw new IndexOutOfBoundsException(index);
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return null;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return 0;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.elementDescriptor.disassemble(value, session);
    }

    @Override
    public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        this.elementDescriptor.addToCacheKey(cacheKey, value, session);
    }

    @Override
    public <X, Y> int forEachDisassembledJdbcValue(Object value, int offset, X x, Y y, Bindable.JdbcValuesBiConsumer<X, Y> valuesConsumer, SharedSessionContractImplementor session) {
        return this.elementDescriptor.forEachDisassembledJdbcValue(value, offset, x, y, valuesConsumer, session);
    }

    public String toString() {
        return "PluralAttribute(" + this.getCollectionDescriptor().getRole() + ")";
    }

    public static interface Aware {
        public void injectAttributeMapping(PluralAttributeMapping var1);
    }
}

