/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.loader.NonUniqueDiscoveredSqlAliasException;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.JdbcValuesMappingImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.ResultSetMappingSqlSelection;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;

@Incubating
@Internal
public class ResultSetMappingImpl
implements ResultSetMapping {
    private final String mappingIdentifier;
    private final boolean isDynamic;
    private List<ResultBuilder> resultBuilders;
    private Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders;

    public ResultSetMappingImpl(String mappingIdentifier) {
        this(mappingIdentifier, false);
    }

    public ResultSetMappingImpl(String mappingIdentifier, boolean isDynamic) {
        this.mappingIdentifier = mappingIdentifier;
        this.isDynamic = isDynamic;
    }

    private ResultSetMappingImpl(ResultSetMappingImpl original) {
        this.mappingIdentifier = original.mappingIdentifier;
        this.isDynamic = original.isDynamic;
        if (!original.isDynamic || original.resultBuilders == null) {
            this.resultBuilders = null;
        } else {
            ArrayList<ResultBuilder> resultBuilders = new ArrayList<ResultBuilder>(original.resultBuilders.size());
            for (ResultBuilder resultBuilder : original.resultBuilders) {
                resultBuilders.add(resultBuilder.cacheKeyInstance());
            }
            this.resultBuilders = resultBuilders;
        }
        if (!original.isDynamic || original.legacyFetchBuilders == null) {
            this.legacyFetchBuilders = null;
        } else {
            HashMap<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders = new HashMap<String, Map<String, DynamicFetchBuilderLegacy>>(original.legacyFetchBuilders.size());
            for (Map.Entry entry : original.legacyFetchBuilders.entrySet()) {
                HashMap<String, DynamicFetchBuilderLegacy> newValue = new HashMap<String, DynamicFetchBuilderLegacy>(((Map)entry.getValue()).size());
                for (Map.Entry builderEntry : ((Map)entry.getValue()).entrySet()) {
                    newValue.put((String)builderEntry.getKey(), ((DynamicFetchBuilderLegacy)builderEntry.getValue()).cacheKeyInstance());
                }
                legacyFetchBuilders.put((String)entry.getKey(), newValue);
            }
            this.legacyFetchBuilders = legacyFetchBuilders;
        }
    }

    @Override
    public String getMappingIdentifier() {
        return this.mappingIdentifier;
    }

    @Override
    public boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public int getNumberOfResultBuilders() {
        return this.resultBuilders == null ? 0 : this.resultBuilders.size();
    }

    @Override
    public List<ResultBuilder> getResultBuilders() {
        if (this.resultBuilders == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.resultBuilders);
    }

    @Override
    public void visitResultBuilders(BiConsumer<Integer, ResultBuilder> resultBuilderConsumer) {
        if (this.resultBuilders == null) {
            return;
        }
        for (int i = 0; i < this.resultBuilders.size(); ++i) {
            resultBuilderConsumer.accept(i, this.resultBuilders.get(i));
        }
    }

    @Override
    public void visitLegacyFetchBuilders(Consumer<DynamicFetchBuilderLegacy> resultBuilderConsumer) {
        if (this.legacyFetchBuilders == null) {
            return;
        }
        for (Map.Entry<String, Map<String, DynamicFetchBuilderLegacy>> entry : this.legacyFetchBuilders.entrySet()) {
            for (DynamicFetchBuilderLegacy fetchBuilder : entry.getValue().values()) {
                resultBuilderConsumer.accept(fetchBuilder);
            }
        }
    }

    @Override
    public void addResultBuilder(ResultBuilder resultBuilder) {
        if (this.resultBuilders == null) {
            this.resultBuilders = new ArrayList<ResultBuilder>();
        }
        this.resultBuilders.add(resultBuilder);
    }

    @Override
    public void addLegacyFetchBuilder(DynamicFetchBuilderLegacy fetchBuilder) {
        Map<String, DynamicFetchBuilderLegacy> fetchBuildersByOwner;
        Map<String, DynamicFetchBuilderLegacy> existingFetchBuildersByOwner;
        if (this.legacyFetchBuilders == null) {
            this.legacyFetchBuilders = new HashMap<String, Map<String, DynamicFetchBuilderLegacy>>();
            existingFetchBuildersByOwner = null;
        } else {
            existingFetchBuildersByOwner = this.legacyFetchBuilders.get(fetchBuilder.getOwnerAlias());
        }
        if (existingFetchBuildersByOwner == null) {
            fetchBuildersByOwner = new HashMap<String, DynamicFetchBuilderLegacy>();
            this.legacyFetchBuilders.put(fetchBuilder.getOwnerAlias(), fetchBuildersByOwner);
        } else {
            fetchBuildersByOwner = existingFetchBuildersByOwner;
        }
        DynamicFetchBuilderLegacy previousBuilder = fetchBuildersByOwner.put(fetchBuilder.getFetchableName(), fetchBuilder);
        if (previousBuilder != null) {
            // empty if block
        }
    }

    @Override
    public void addAffectedTableNames(Set<String> affectedTableNames, SessionFactoryImplementor sessionFactory) {
        if (StringHelper.isEmpty(this.mappingIdentifier)) {
            return;
        }
        EntityPersister entityDescriptor = sessionFactory.getRuntimeMetamodels().getMappingMetamodel().findEntityDescriptor(this.mappingIdentifier);
        if (entityDescriptor == null) {
            return;
        }
        Collections.addAll(affectedTableNames, (String[])entityDescriptor.getQuerySpaces());
    }

    @Override
    public JdbcValuesMapping resolve(JdbcValuesMetadata jdbcResultsMetadata, LoadQueryInfluencers loadQueryInfluencers, SessionFactoryImplementor sessionFactory) {
        DomainResult<Object> domainResult;
        int rowSize = jdbcResultsMetadata.getColumnCount();
        int numberOfResults = this.resultBuilders == null ? rowSize : this.resultBuilders.size();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(rowSize);
        ArrayList domainResults = new ArrayList(numberOfResults);
        DomainResultCreationStateImpl creationState = new DomainResultCreationStateImpl(this.mappingIdentifier, jdbcResultsMetadata, this.legacyFetchBuilders, sqlSelections::add, loadQueryInfluencers, sessionFactory);
        for (int i = 0; i < numberOfResults; ++i) {
            ResultBuilder resultBuilder;
            ResultBuilder resultBuilder2 = resultBuilder = this.resultBuilders != null ? this.resultBuilders.get(i) : null;
            domainResult = resultBuilder == null ? this.makeImplicitDomainResult(i, sqlSelections::add, jdbcResultsMetadata, sessionFactory) : resultBuilder.buildResult(jdbcResultsMetadata, domainResults.size(), creationState.getLegacyFetchResolver()::resolve, creationState);
            if (domainResult.containsAnyNonScalarResults()) {
                creationState.disallowPositionalSelections();
            }
            domainResults.add(domainResult);
        }
        if (this.resultBuilders != null) {
            EntityResult entityResult;
            EntityPersister persister;
            boolean polymorphic;
            TreeSet<String> knownDuplicateAliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            if (this.resultBuilders.size() == 1 && domainResults.size() == 1 && (domainResult = domainResults.get(0)) instanceof EntityResult && (polymorphic = (persister = (entityResult = (EntityResult)domainResult).getReferencedMappingContainer().getEntityPersister()).getEntityMetamodel().isPolymorphic()) && (this.legacyFetchBuilders == null || this.legacyFetchBuilders.isEmpty()) && !entityResult.hasJoinFetches()) {
                TreeSet<String> aliases = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                for (String[] columns : persister.getConstraintOrderedTableKeyColumnClosure()) {
                    ResultSetMappingImpl.addColumns(aliases, knownDuplicateAliases, columns);
                }
                ResultSetMappingImpl.addColumn(aliases, knownDuplicateAliases, persister.getDiscriminatorColumnName());
                ResultSetMappingImpl.addColumn(aliases, knownDuplicateAliases, persister.getVersionColumnName());
                for (int i = 0; i < persister.countSubclassProperties(); ++i) {
                    ResultSetMappingImpl.addColumns(aliases, knownDuplicateAliases, persister.getSubclassPropertyColumnNames(i));
                }
            }
            String[] aliases = new String[rowSize];
            HashMap<String, Boolean> aliasHasDuplicates = new HashMap<String, Boolean>(rowSize);
            for (int i = 0; i < rowSize; ++i) {
                aliases[i] = jdbcResultsMetadata.resolveColumnName(i + 1);
                aliasHasDuplicates.compute(aliases[i], (k, v) -> v == null ? Boolean.FALSE : Boolean.TRUE);
            }
            for (SqlSelection sqlSelection : sqlSelections) {
                String alias = aliases[sqlSelection.getValuesArrayPosition()];
                if (knownDuplicateAliases.contains(alias) || aliasHasDuplicates.get(alias) != Boolean.TRUE) continue;
                throw new NonUniqueDiscoveredSqlAliasException("Encountered a duplicated sql alias [" + alias + "] during auto-discovery of a native-sql query");
            }
        }
        return new JdbcValuesMappingImpl(sqlSelections, domainResults, rowSize, creationState.getRegisteredLockModes());
    }

    private static void addColumns(Set<String> aliases, Set<String> knownDuplicateAliases, String[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            ResultSetMappingImpl.addColumn(aliases, knownDuplicateAliases, columns[i]);
        }
    }

    private static void addColumn(Set<String> aliases, Set<String> knownDuplicateAliases, String column) {
        if (column != null && !aliases.add(column)) {
            knownDuplicateAliases.add(column);
        }
    }

    private DomainResult<?> makeImplicitDomainResult(int valuesArrayPosition, Consumer<SqlSelection> sqlSelectionConsumer, JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        int jdbcPosition = valuesArrayPosition + 1;
        BasicType jdbcMapping = jdbcResultsMetadata.resolveType(jdbcPosition, null, sessionFactory);
        String name = jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        ResultSetMappingSqlSelection sqlSelection = new ResultSetMappingSqlSelection(valuesArrayPosition, jdbcMapping);
        sqlSelectionConsumer.accept(sqlSelection);
        return new BasicResult(valuesArrayPosition, name, jdbcMapping, null, false, false);
    }

    @Override
    public NamedResultSetMappingMemento toMemento(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JdbcValuesMappingProducer cacheKeyInstance() {
        return new ResultSetMappingImpl(this);
    }

    public int hashCode() {
        if (this.isDynamic) {
            int result = this.mappingIdentifier != null ? this.mappingIdentifier.hashCode() : 0;
            result = 31 * result + (this.resultBuilders != null ? this.resultBuilders.hashCode() : 0);
            result = 31 * result + (this.legacyFetchBuilders != null ? this.legacyFetchBuilders.hashCode() : 0);
            return result;
        }
        return this.mappingIdentifier.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultSetMappingImpl that = (ResultSetMappingImpl)o;
        if (this.isDynamic) {
            return that.isDynamic && Objects.equals(this.mappingIdentifier, that.mappingIdentifier) && Objects.equals(this.resultBuilders, that.resultBuilders) && Objects.equals(this.legacyFetchBuilders, that.legacyFetchBuilders);
        }
        return !that.isDynamic && this.mappingIdentifier != null && this.mappingIdentifier.equals(that.mappingIdentifier);
    }
}

