/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.BitSet;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmMapEntryResult<K, V, R extends Map.Entry<K, V>>
implements DomainResult<R> {
    private final DomainResult<K> keyResult;
    private final DomainResult<V> valueResult;
    private final JavaType<R> javaType;
    private final String alias;

    public SqmMapEntryResult(DomainResult<K> keyResult, DomainResult<V> valueResult, String alias, JavaType<R> javaType) {
        this.alias = alias;
        this.keyResult = keyResult;
        this.valueResult = valueResult;
        this.javaType = javaType;
    }

    @Override
    public String getResultVariable() {
        return this.alias;
    }

    @Override
    public DomainResultAssembler<R> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        DomainResultAssembler<K> keyAssembler = this.keyResult.createResultAssembler(null, creationState);
        DomainResultAssembler<V> valueAssembler = this.valueResult.createResultAssembler(null, creationState);
        return new EntryDomainResultAssembler<K, V, R>(this.javaType, keyAssembler, valueAssembler);
    }

    public JavaType<R> getResultJavaType() {
        return this.javaType;
    }

    @Override
    public void collectValueIndexesToCache(BitSet valueIndexes) {
        this.keyResult.collectValueIndexesToCache(valueIndexes);
        this.valueResult.collectValueIndexesToCache(valueIndexes);
    }

    private static class EntryDomainResultAssembler<K, V, R>
    implements DomainResultAssembler<R> {
        private final JavaType<R> javaType;
        private final DomainResultAssembler<K> keyAssembler;
        private final DomainResultAssembler<V> valueAssembler;

        public EntryDomainResultAssembler(JavaType<R> javaType, DomainResultAssembler<K> keyAssembler, DomainResultAssembler<V> valueAssembler) {
            this.javaType = javaType;
            this.keyAssembler = keyAssembler;
            this.valueAssembler = valueAssembler;
        }

        @Override
        public R assemble(RowProcessingState rowProcessingState) {
            K key = this.keyAssembler.assemble(rowProcessingState);
            V value = this.valueAssembler.assemble(rowProcessingState);
            return (R)Map.entry(key, value);
        }

        @Override
        public JavaType<R> getAssembledJavaType() {
            return this.javaType;
        }

        @Override
        public <X> void forEachResultAssembler(BiConsumer<Initializer<?>, X> consumer, X arg) {
            this.keyAssembler.forEachResultAssembler(consumer, arg);
            this.valueAssembler.forEachResultAssembler(consumer, arg);
        }
    }
}

