/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.Type;
import java.util.Arrays;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.internal.BasicSqmPathSource;
import org.hibernate.metamodel.model.domain.internal.EmbeddedSqmPathSource;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.TreatException;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.spi.NavigablePath;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;

public class SqmFunctionPath<T>
extends AbstractSqmPath<T> {
    private final SqmFunction<?> function;

    public SqmFunctionPath(SqmFunction<?> function) {
        this(new NavigablePath(function.toHqlString()), function);
    }

    public SqmFunctionPath(NavigablePath navigablePath, SqmFunction<?> function) {
        super(navigablePath, SqmFunctionPath.determinePathSource(navigablePath, function), null, function.nodeBuilder());
        this.function = function;
    }

    private static <X> SqmPathSource<X> determinePathSource(NavigablePath navigablePath, SqmFunction<?> function) {
        SqmExpressible nodeType = function.getNodeType();
        Class bindableJavaType = nodeType.getBindableJavaType();
        ManagedDomainType managedType = function.nodeBuilder().getJpaMetamodel().findManagedType(bindableJavaType);
        if (managedType == null) {
            BasicType basicType = function.nodeBuilder().getTypeConfiguration().getBasicTypeForJavaType(bindableJavaType);
            return new BasicSqmPathSource(navigablePath.getFullPath(), null, basicType, basicType.getRelationalJavaType(), Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
        }
        if (managedType.getPersistenceType() == Type.PersistenceType.EMBEDDABLE) {
            return new EmbeddedSqmPathSource(navigablePath.getFullPath(), null, (EmbeddableDomainType)managedType, Bindable.BindableType.SINGULAR_ATTRIBUTE, false);
        }
        throw new IllegalArgumentException("Unsupported return type for function: " + bindableJavaType.getName());
    }

    public SqmFunction<?> getFunction() {
        return this.function;
    }

    @Override
    public SqmFunctionPath<T> copy(SqmCopyContext context) {
        SqmFunctionPath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmFunctionPath<T> path = context.registerCopy(this, new SqmFunctionPath<T>(this.getNavigablePath(), (SqmFunction)this.function.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        JpaPath sqmPath = this.get(name);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register((SqmPath<?>)sqmPath);
        return sqmPath;
    }

    @Override
    public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState creationState) {
        SqmPathRegistry pathRegistry = creationState.getCurrentProcessingState().getPathRegistry();
        String alias = selector.toHqlString();
        NavigablePath navigablePath = this.getNavigablePath().getParent().append(CollectionPart.Nature.ELEMENT.getName(), alias);
        Object indexedPath = pathRegistry.findFromByPath(navigablePath);
        if (indexedPath != null) {
            return indexedPath;
        }
        if (!(this.getNodeType().getSqmPathType() instanceof BasicPluralType)) {
            throw new UnsupportedOperationException("Index access is only supported for basic plural types.");
        }
        QueryEngine queryEngine = creationState.getCreationContext().getQueryEngine();
        SelfRenderingSqmFunction result = queryEngine.getSqmFunctionRegistry().findFunctionDescriptor("array_get").generateSqmExpression(Arrays.asList(this.function, selector), null, queryEngine);
        SqmFunctionPath<T> path = new SqmFunctionPath<T>(result);
        pathRegistry.register(path);
        return path;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFunctionPath(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        this.function.appendHqlString(sb);
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) {
        throw new TreatException("Embeddable paths cannot be TREAT-ed");
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) {
        throw new TreatException("Embeddable paths cannot be TREAT-ed");
    }
}

