/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.spi;

import java.sql.Connection;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class JdbcEventHandler {
    private static final Logger log = Logger.getLogger(JdbcEventHandler.class);
    private final StatisticsImplementor statistics;
    private final SessionEventListenerManager sessionListener;
    private final Supplier<JdbcCoordinator> jdbcCoordinatorSupplier;

    public JdbcEventHandler(StatisticsImplementor statistics, SessionEventListenerManager sessionListener, Supplier<JdbcCoordinator> jdbcCoordinatorSupplier) {
        this.statistics = statistics;
        this.sessionListener = sessionListener;
        this.jdbcCoordinatorSupplier = jdbcCoordinatorSupplier;
    }

    public JdbcEventHandler() {
        this(null, null, null);
    }

    public void jdbcConnectionAcquisitionStart() {
    }

    public void jdbcConnectionAcquisitionEnd(Connection connection) {
        if (this.statistics != null && this.statistics.isStatisticsEnabled()) {
            this.statistics.connect();
        }
    }

    public void jdbcConnectionReleaseStart() {
    }

    public void jdbcConnectionReleaseEnd() {
    }

    public void jdbcPrepareStatementStart() {
        if (this.sessionListener != null) {
            this.sessionListener.jdbcPrepareStatementStart();
        }
    }

    public void jdbcPrepareStatementEnd() {
        if (this.sessionListener != null) {
            this.sessionListener.jdbcPrepareStatementEnd();
        }
        if (this.statistics != null && this.statistics.isStatisticsEnabled()) {
            this.statistics.prepareStatement();
        }
    }

    public void jdbcExecuteStatementStart() {
        if (this.sessionListener != null) {
            this.sessionListener.jdbcExecuteStatementStart();
        }
    }

    public void jdbcExecuteStatementEnd() {
        if (this.sessionListener != null) {
            this.sessionListener.jdbcExecuteStatementEnd();
        }
    }

    public void jdbcExecuteBatchStart() {
        if (this.sessionListener != null) {
            this.sessionListener.jdbcExecuteBatchStart();
        }
    }

    public void jdbcExecuteBatchEnd() {
        if (this.sessionListener != null) {
            this.sessionListener.jdbcExecuteBatchEnd();
        }
    }

    public void jdbcReleaseRegistryResourcesStart() {
        JdbcCoordinator jdbcCoordinator;
        if (this.jdbcCoordinatorSupplier != null && (jdbcCoordinator = this.jdbcCoordinatorSupplier.get()) != null) {
            log.debug((Object)"Aborting batches as part of ResourceRegistryStandardImpl#releaseResources");
            jdbcCoordinator.abortBatch();
        }
    }

    public void jdbcReleaseRegistryResourcesEnd() {
    }
}

