/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.result.internal;

import jakarta.persistence.ParameterMode;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.JDBCException;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.procedure.internal.ProcedureCallImpl;
import org.hibernate.procedure.internal.ScalarDomainResultBuilder;
import org.hibernate.query.procedure.ProcedureParameter;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.result.Output;
import org.hibernate.result.Outputs;
import org.hibernate.result.internal.OutputsExecutionContext;
import org.hibernate.result.internal.ResultSetOutputImpl;
import org.hibernate.result.internal.UpdateCountOutputImpl;
import org.hibernate.result.spi.ResultContext;
import org.hibernate.sql.results.NoMoreOutputsException;
import org.hibernate.sql.results.internal.ResultsHelper;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.jdbc.internal.DirectResultSetAccess;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.jboss.logging.Logger;

public class OutputsImpl
implements Outputs {
    private static final Logger log = CoreLogging.logger(OutputsImpl.class);
    private final ResultContext context;
    private final PreparedStatement jdbcStatement;
    private final SqlStatementLogger sqlStatementLogger;
    private final String sql;
    private CurrentReturnState currentReturnState;

    public OutputsImpl(ResultContext context, PreparedStatement jdbcStatement, String sql) {
        this.context = context;
        this.jdbcStatement = jdbcStatement;
        this.sqlStatementLogger = context.getSession().getJdbcServices().getSqlStatementLogger();
        this.sql = sql;
    }

    protected ResultContext getResultContext() {
        return this.context;
    }

    protected void executeStatement() {
        long executeStartNanos = 0L;
        if (this.sqlStatementLogger.getLogSlowQuery() > 0L) {
            executeStartNanos = System.nanoTime();
        }
        EventManager eventManager = this.context.getSession().getEventManager();
        HibernateMonitoringEvent jdbcPreparedStatementExecutionEvent = eventManager.beginJdbcPreparedStatementExecutionEvent();
        try {
            boolean isResultSet = this.jdbcStatement.execute();
            this.currentReturnState = this.buildCurrentReturnState(isResultSet);
        }
        catch (SQLException e) {
            throw this.convert(e, "Error calling CallableStatement.getMoreResults");
        }
        finally {
            eventManager.completeJdbcPreparedStatementExecutionEvent(jdbcPreparedStatementExecutionEvent, this.sql);
            this.sqlStatementLogger.logSlowQuery(this.sql, executeStartNanos, this.context.getSession().getJdbcSessionContext());
        }
    }

    private CurrentReturnState buildCurrentReturnState(boolean isResultSet) {
        int updateCount = -1;
        if (!isResultSet) {
            try {
                updateCount = this.jdbcStatement.getUpdateCount();
            }
            catch (SQLException e) {
                throw this.convert(e, "Error calling CallableStatement.getUpdateCount");
            }
        }
        return this.buildCurrentReturnState(isResultSet, updateCount);
    }

    protected CurrentReturnState buildCurrentReturnState(boolean isResultSet, int updateCount) {
        return new CurrentReturnState(isResultSet, updateCount);
    }

    protected JDBCException convert(SQLException e, String message) {
        return this.context.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, message, this.jdbcStatement.toString());
    }

    @Override
    public Output getCurrent() {
        if (this.currentReturnState == null) {
            return null;
        }
        return this.currentReturnState.getOutput();
    }

    @Override
    public boolean goToNext() {
        if (this.currentReturnState == null) {
            return false;
        }
        if (this.currentReturnState.indicatesMoreOutputs()) {
            try {
                boolean isResultSet = this.jdbcStatement.getMoreResults();
                this.currentReturnState = this.buildCurrentReturnState(isResultSet);
            }
            catch (SQLException e) {
                throw this.convert(e, "Error calling CallableStatement.getMoreResults");
            }
        }
        return this.currentReturnState != null && this.currentReturnState.indicatesMoreOutputs();
    }

    @Override
    public void release() {
        this.context.getSession().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.jdbcStatement);
    }

    private List<?> extractCurrentResults() {
        try {
            return this.extractResults(this.jdbcStatement.getResultSet());
        }
        catch (SQLException e) {
            throw this.convert(e, "Error calling CallableStatement.getResultSet");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Object> extractResults(ResultSet resultSet) {
        DirectResultSetAccess resultSetAccess = new DirectResultSetAccess(this.context.getSession(), this.jdbcStatement, resultSet);
        ProcedureCallImpl procedureCall = (ProcedureCallImpl)this.context;
        ResultSetMapping resultSetMapping = procedureCall.getResultSetMapping();
        JavaTypeRegistry javaTypeRegistry = this.context.getSession().getTypeConfiguration().getJavaTypeRegistry();
        procedureCall.getParameterBindings().visitBindings((parameterImplementor, queryParameterBinding) -> {
            ProcedureParameter parameter = (ProcedureParameter)((Object)parameterImplementor);
            if (parameter.getMode() == ParameterMode.INOUT) {
                JavaType basicType = javaTypeRegistry.getDescriptor(parameterImplementor.getParameterType());
                if (basicType != null) {
                    resultSetMapping.addResultBuilder(new ScalarDomainResultBuilder(basicType));
                } else {
                    throw new UnsupportedOperationException();
                }
            }
        });
        OutputsExecutionContext executionContext = new OutputsExecutionContext(this.context.getSession());
        JdbcValuesResultSetImpl jdbcValues = new JdbcValuesResultSetImpl(resultSetAccess, null, null, this.context.getQueryOptions(), true, resultSetMapping.resolve(resultSetAccess, this.context.getSession().getLoadQueryInfluencers(), this.getSessionFactory()), null, executionContext);
        try {
            RowProcessingStateStandardImpl rowProcessingState;
            ArrayList<Object> results;
            JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState;
            RowReader rowReader;
            block9: {
                rowReader = ResultsHelper.createRowReader(this.getSessionFactory(), RowTransformerStandardImpl.INSTANCE, null, jdbcValues);
                JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

                    @Override
                    public Object getEffectiveOptionalObject() {
                        return null;
                    }

                    @Override
                    public String getEffectiveOptionalEntityName() {
                        return null;
                    }

                    @Override
                    public Serializable getEffectiveOptionalId() {
                        return null;
                    }

                    @Override
                    public boolean shouldReturnProxies() {
                        return true;
                    }
                };
                jdbcValuesSourceProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
                results = new ArrayList<Object>();
                rowProcessingState = new RowProcessingStateStandardImpl(jdbcValuesSourceProcessingState, executionContext, rowReader, jdbcValues);
                try {
                    rowReader.startLoading(rowProcessingState);
                    while (rowProcessingState.next()) {
                        results.add(rowReader.readRow(rowProcessingState));
                        rowProcessingState.finishRowProcessing(true);
                    }
                    if (resultSetMapping.getNumberOfResultBuilders() != 0 || !procedureCall.isFunctionCall() || procedureCall.getFunctionReturn().getJdbcTypeCode() != 2012 || results.size() != 1 || !(results.get(0) instanceof ResultSet)) break block9;
                    List<Object> list = this.extractResults((ResultSet)results.get(0));
                    rowReader.finishUp(rowProcessingState);
                    jdbcValuesSourceProcessingState.finishUp(results.size() > 1);
                    return list;
                }
                catch (Throwable throwable) {
                    rowReader.finishUp(rowProcessingState);
                    jdbcValuesSourceProcessingState.finishUp(results.size() > 1);
                    throw throwable;
                }
            }
            ArrayList<Object> arrayList = results;
            rowReader.finishUp(rowProcessingState);
            jdbcValuesSourceProcessingState.finishUp(results.size() > 1);
            return arrayList;
        }
        finally {
            jdbcValues.finishUp(this.context.getSession());
        }
    }

    private SessionFactoryImplementor getSessionFactory() {
        return this.context.getSession().getFactory();
    }

    protected class CurrentReturnState {
        private final boolean isResultSet;
        private final int updateCount;
        private Output rtn;

        protected CurrentReturnState(boolean isResultSet, int updateCount) {
            this.isResultSet = isResultSet;
            this.updateCount = updateCount;
        }

        public boolean indicatesMoreOutputs() {
            return this.isResultSet() || this.getUpdateCount() >= 0;
        }

        public boolean isResultSet() {
            return this.isResultSet;
        }

        public int getUpdateCount() {
            return this.updateCount;
        }

        public Output getOutput() {
            if (this.rtn == null) {
                this.rtn = this.buildOutput();
            }
            return this.rtn;
        }

        protected Output buildOutput() {
            if (log.isDebugEnabled()) {
                log.debugf("Building Return [isResultSet=%s, updateCount=%s, extendedReturn=%s]", (Object)this.isResultSet(), (Object)this.getUpdateCount(), (Object)this.hasExtendedReturns());
            }
            if (this.isResultSet()) {
                return this.buildResultSetOutput(OutputsImpl.this.extractCurrentResults());
            }
            if (this.getUpdateCount() >= 0) {
                return this.buildUpdateCountOutput(this.updateCount);
            }
            if (this.hasExtendedReturns()) {
                return this.buildExtendedReturn();
            }
            if (this.hasFunctionReturns()) {
                return this.buildFunctionReturn();
            }
            throw new NoMoreOutputsException();
        }

        protected Output buildResultSetOutput(List<?> list) {
            return new ResultSetOutputImpl(list);
        }

        protected Output buildResultSetOutput(Supplier<List<?>> listSupplier) {
            return new ResultSetOutputImpl(listSupplier);
        }

        protected Output buildUpdateCountOutput(int updateCount) {
            return new UpdateCountOutputImpl(updateCount);
        }

        protected boolean hasExtendedReturns() {
            return false;
        }

        protected Output buildExtendedReturn() {
            throw new IllegalStateException("State does not define extended returns");
        }

        protected boolean hasFunctionReturns() {
            return false;
        }

        protected Output buildFunctionReturn() {
            throw new IllegalStateException("State does not define function returns");
        }
    }
}

