/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.PersistentMap;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class MapInitializer
extends AbstractImmediateCollectionInitializer<AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData> {
    private static final String CONCRETE_NAME = MapInitializer.class.getSimpleName();
    private final DomainResultAssembler<?> mapKeyAssembler;
    private final DomainResultAssembler<?> mapValueAssembler;

    public MapInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, InitializerParent<?> parent, LockMode lockMode, DomainResult<?> collectionKeyResult, DomainResult<?> collectionValueKeyResult, boolean isResultInitializer, AssemblerCreationState creationState, Fetch mapKeyFetch, Fetch mapValueFetch) {
        super(navigablePath, attributeMapping, parent, lockMode, collectionKeyResult, collectionValueKeyResult, isResultInitializer, creationState);
        this.mapKeyAssembler = mapKeyFetch.createAssembler(this, creationState);
        this.mapValueAssembler = mapValueFetch.createAssembler(this, creationState);
    }

    @Override
    protected String getSimpleConcreteImplName() {
        return CONCRETE_NAME;
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> valueInitializer;
        super.forEachSubInitializer(consumer, data);
        Initializer<?> keyInitializer = this.mapKeyAssembler.getInitializer();
        if (keyInitializer != null) {
            consumer.accept(keyInitializer, data.getRowProcessingState());
        }
        if ((valueInitializer = this.mapValueAssembler.getInitializer()) != null) {
            consumer.accept(valueInitializer, data.getRowProcessingState());
        }
    }

    public @Nullable PersistentMap<?, ?> getCollectionInstance(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        return (PersistentMap)super.getCollectionInstance(data);
    }

    @Override
    protected void readCollectionRow(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data, List<Object> loadingState) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        Object key = this.mapKeyAssembler.assemble(rowProcessingState);
        if (key == null) {
            return;
        }
        Object value = this.mapValueAssembler.assemble(rowProcessingState);
        if (value == null) {
            return;
        }
        loadingState.add(new Object[]{key, value});
    }

    @Override
    protected void initializeSubInstancesFromParent(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> keyInitializer = this.mapKeyAssembler.getInitializer();
        Initializer<?> valueInitializer = this.mapValueAssembler.getInitializer();
        if (keyInitializer != null || valueInitializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentMap<?, ?> map = this.getCollectionInstance(data);
            assert (map != null);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (keyInitializer != null) {
                    keyInitializer.initializeInstanceFromParent(entry.getKey(), rowProcessingState);
                }
                if (valueInitializer == null) continue;
                valueInitializer.initializeInstanceFromParent(entry.getValue(), rowProcessingState);
            }
        }
    }

    @Override
    protected void resolveInstanceSubInitializers(AbstractImmediateCollectionInitializer.ImmediateCollectionInitializerData data) {
        Initializer<?> keyInitializer = this.mapKeyAssembler.getInitializer();
        Initializer<?> valueInitializer = this.mapValueAssembler.getInitializer();
        if (keyInitializer != null || valueInitializer != null) {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            PersistentMap<?, ?> map = this.getCollectionInstance(data);
            assert (map != null);
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (keyInitializer != null) {
                    keyInitializer.resolveInstance(entry.getKey(), rowProcessingState);
                }
                if (valueInitializer == null) continue;
                valueInitializer.resolveInstance(entry.getValue(), rowProcessingState);
            }
        }
    }

    @Override
    public DomainResultAssembler<?> getIndexAssembler() {
        return this.mapKeyAssembler;
    }

    @Override
    public DomainResultAssembler<?> getElementAssembler() {
        return this.mapValueAssembler;
    }

    public String toString() {
        return "MapInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

