/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.lang.reflect.Type;
import org.hibernate.engine.FetchTiming;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.embeddable.internal.AggregateEmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.type.spi.TypeConfiguration;

public class AggregateEmbeddableFetchImpl
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
Fetch,
InitializerProducer<AggregateEmbeddableFetchImpl> {
    private final FetchParent fetchParent;
    private final FetchTiming fetchTiming;
    private final TableGroup tableGroup;
    private final boolean hasTableGroup;
    private final SqlSelection aggregateSelection;
    private final EmbeddableMappingType fetchContainer;
    private final BasicFetch<?> discriminatorFetch;

    public AggregateEmbeddableFetchImpl(NavigablePath navigablePath, EmbeddableValuedFetchable embeddedPartDescriptor, FetchParent fetchParent, FetchTiming fetchTiming, boolean hasTableGroup, DomainResultCreationState creationState) {
        super(navigablePath);
        this.fetchContainer = embeddedPartDescriptor.getEmbeddableTypeDescriptor();
        this.fetchParent = fetchParent;
        this.fetchTiming = fetchTiming;
        this.hasTableGroup = hasTableGroup;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        this.tableGroup = sqlAstCreationState.getFromClauseAccess().resolveTableGroup(this.getNavigablePath(), np -> {
            TableGroup lhsTableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.getReferencedMappingContainer().createTableGroupJoin(this.getNavigablePath(), lhsTableGroup, null, null, SqlAstJoinType.INNER, true, false, sqlAstCreationState);
            lhsTableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = this.tableGroup.getPrimaryTableReference();
        SelectableMapping selectableMapping = this.fetchContainer.getAggregateMapping();
        Expression expression = sqlExpressionResolver.resolveSqlExpression(tableReference, selectableMapping);
        TypeConfiguration typeConfiguration = sqlAstCreationState.getCreationContext().getSessionFactory().getTypeConfiguration();
        this.aggregateSelection = sqlExpressionResolver.resolveSqlSelection(expression, typeConfiguration.getJavaTypeRegistry().resolveDescriptor((Type)((Object)Object[].class)), fetchParent, typeConfiguration);
        this.discriminatorFetch = creationState.visitEmbeddableDiscriminatorFetch(this, true);
        this.resetFetches(creationState.visitNestedFetches(this));
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public boolean hasTableGroup() {
        return this.hasTableGroup;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath resolveNavigablePath(Fetchable fetchable) {
        if (fetchable instanceof TableGroupProducer) {
            for (TableGroupJoin tableGroupJoin : this.tableGroup.getTableGroupJoins()) {
                NavigablePath navigablePath = tableGroupJoin.getNavigablePath();
                if (!tableGroupJoin.getJoinedGroup().isFetched() || !fetchable.getFetchableName().equals(navigablePath.getLocalName()) || tableGroupJoin.getJoinedGroup().getModelPart() != fetchable || !NullnessUtil.castNonNull(navigablePath.getParent()).equals(this.getNavigablePath())) continue;
                return navigablePath;
            }
        }
        return super.resolveNavigablePath(fetchable);
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    public DomainResultAssembler createAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableAssembler(creationState.resolveInitializer(this, parent, this).asEmbeddableInitializer());
    }

    @Override
    public EmbeddableInitializer<?> createInitializer(AggregateEmbeddableFetchImpl resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer((InitializerParent)parent, creationState);
    }

    public EmbeddableInitializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new AggregateEmbeddableInitializerImpl(this, this.discriminatorFetch, parent, creationState, false, this.aggregateSelection);
    }

    @Override
    public FetchParent asFetchParent() {
        return this;
    }
}

