/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.ValueAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class NonAggregatedIdentifierMappingInitializer
extends AbstractInitializer<NonAggregatedIdentifierMappingInitializerData>
implements EmbeddableInitializer<NonAggregatedIdentifierMappingInitializerData> {
    private final NavigablePath navigablePath;
    private final NonAggregatedIdentifierMapping embedded;
    private final EmbeddableMappingType representationEmbeddable;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final @Nullable InitializerParent<?> parent;
    private final SessionFactoryImplementor sessionFactory;
    private final boolean isResultInitializer;
    private final DomainResultAssembler<?>[] assemblers;
    private final Initializer<InitializerData>[] initializers;
    private final boolean hasIdClass;

    public NonAggregatedIdentifierMappingInitializer(EmbeddableResultGraphNode resultDescriptor, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer) {
        this(resultDescriptor, parent, creationState, isResultInitializer, Function.identity());
    }

    protected NonAggregatedIdentifierMappingInitializer(EmbeddableResultGraphNode resultDescriptor, InitializerParent<?> parent, AssemblerCreationState creationState, boolean isResultInitializer, Function<Fetch, Fetch> fetchConverter) {
        super(creationState);
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embedded = (NonAggregatedIdentifierMapping)resultDescriptor.getReferencedMappingContainer();
        this.parent = parent;
        this.isResultInitializer = isResultInitializer;
        EmbeddableMappingType virtualIdEmbeddable = this.embedded.getEmbeddableTypeDescriptor();
        this.representationEmbeddable = this.embedded.getMappedIdEmbeddableTypeDescriptor();
        this.representationStrategy = this.representationEmbeddable.getRepresentationStrategy();
        this.hasIdClass = this.embedded.hasContainingClass() && virtualIdEmbeddable != this.representationEmbeddable;
        this.sessionFactory = creationState.getSqlAstCreationContext().getSessionFactory();
        this.assemblers = NonAggregatedIdentifierMappingInitializer.createAssemblers(this, resultDescriptor, creationState, virtualIdEmbeddable, fetchConverter);
        ArrayList initializers = new ArrayList(this.assemblers.length);
        for (DomainResultAssembler<?> assembler : this.assemblers) {
            Initializer<?> initializer = assembler.getInitializer();
            if (initializer == null) continue;
            initializers.add(initializer);
        }
        this.initializers = initializers.isEmpty() ? Initializer.EMPTY_ARRAY : initializers.toArray(EMPTY_ARRAY);
    }

    protected static DomainResultAssembler<?>[] createAssemblers(InitializerParent<?> parent, EmbeddableResultGraphNode resultDescriptor, AssemblerCreationState creationState, EmbeddableMappingType embeddableTypeDescriptor, Function<Fetch, Fetch> fetchConverter) {
        int size = embeddableTypeDescriptor.getNumberOfFetchables();
        DomainResultAssembler[] assemblers = new DomainResultAssembler[size];
        for (int i = 0; i < size; ++i) {
            DomainResultAssembler<?> stateAssembler;
            Fetchable stateArrayContributor = embeddableTypeDescriptor.getFetchable(i);
            Fetch fetch = fetchConverter.apply(resultDescriptor.findFetch(stateArrayContributor));
            assemblers[i] = stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaType()) : fetch.createAssembler(parent, creationState);
        }
        return assemblers;
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embedded;
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isResultInitializer() {
        return this.isResultInitializer;
    }

    @Override
    public Object getCompositeInstance(NonAggregatedIdentifierMappingInitializerData data) {
        Initializer.State state = data.getState();
        return state == Initializer.State.RESOLVED || state == Initializer.State.INITIALIZED ? data.getInstance() : null;
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new NonAggregatedIdentifierMappingInitializerData(this, rowProcessingState);
    }

    @Override
    public void resolveKey(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.UNINITIALIZED) {
            return;
        }
        data.setInstance(null);
        data.setState(Initializer.State.KEY_RESOLVED);
        if (this.initializers.length == 0) {
            this.resolveInstance(data);
        } else {
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            for (Initializer<InitializerData> initializer : this.initializers) {
                InitializerData subData = initializer.getData(rowProcessingState);
                initializer.resolveKey(subData);
                if (subData.getState() != Initializer.State.MISSING) continue;
                data.setState(Initializer.State.MISSING);
                return;
            }
        }
    }

    @Override
    public void resolveInstance(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        if (this.isFindByIdLookup(data.getRowProcessingState())) {
            data.setInstance(data.getRowProcessingState().getEntityId());
            data.setState(Initializer.State.INITIALIZED);
            return;
        }
        data.setState(Initializer.State.RESOLVED);
        this.extractRowState(data);
        if (data.getState() == Initializer.State.MISSING) {
            data.setInstance(null);
        } else {
            data.setInstance(this.representationStrategy.getInstantiator().instantiate(data, this.sessionFactory));
        }
    }

    @Override
    public void resolveInstance(@Nullable Object instance, NonAggregatedIdentifierMappingInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.setInstance(null);
        } else {
            data.setState(Initializer.State.INITIALIZED);
            data.setInstance(instance);
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            for (Initializer<InitializerData> initializer : this.initializers) {
                Object subInstance = initializer.getInitializedPart().asAttributeMapping().getValue(instance);
                if (subInstance == LazyPropertyInitializer.UNFETCHED_PROPERTY) {
                    initializer.resolveKey(rowProcessingState);
                    continue;
                }
                initializer.resolveInstance(subInstance, rowProcessingState);
            }
            if (rowProcessingState.needsResolveState()) {
                for (DomainResultAssembler<?> assembler : this.assemblers) {
                    assembler.resolveState(rowProcessingState);
                }
            }
        }
    }

    @Override
    public void initializeInstance(NonAggregatedIdentifierMappingInitializerData data) {
        if (data.getState() != Initializer.State.RESOLVED) {
            return;
        }
        data.setState(Initializer.State.INITIALIZED);
        if (this.parent != null) {
            assert (this.parent.isEntityInitializer());
            Object parentInstance = this.parent.getResolvedInstance(data.getRowProcessingState());
            assert (parentInstance != null);
            LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(parentInstance);
            if (lazyInitializer != null) {
                this.embedded.getVirtualIdEmbeddable().setValues(lazyInitializer.getImplementation(), data.virtualIdState);
            } else {
                this.embedded.getVirtualIdEmbeddable().setValues(parentInstance, data.virtualIdState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        for (Initializer<InitializerData> initializer : this.initializers) {
            consumer.accept(initializer, rowProcessingState);
        }
    }

    private boolean isFindByIdLookup(RowProcessingState rowProcessingState) {
        return !this.hasIdClass && rowProcessingState.getEntityId() != null && this.navigablePath.getParent().getParent() == null && this.navigablePath instanceof EntityIdentifierNavigablePath;
    }

    private void extractRowState(NonAggregatedIdentifierMappingInitializerData data) {
        for (int i = 0; i < this.assemblers.length; ++i) {
            Object associationKey;
            DomainResultAssembler<?> assembler = this.assemblers[i];
            Object contributorValue = assembler.assemble(data.getRowProcessingState());
            if (contributorValue == null) {
                data.setState(Initializer.State.MISSING);
                return;
            }
            if (contributorValue == BatchEntityInsideEmbeddableSelectFetchInitializer.BATCH_PROPERTY) {
                data.virtualIdState[i] = null;
                data.idClassState[i] = null;
                continue;
            }
            data.virtualIdState[i] = contributorValue;
            data.idClassState[i] = contributorValue;
            if (!this.hasIdClass) continue;
            AttributeMapping virtualIdAttribute = this.embedded.getEmbeddableTypeDescriptor().getAttributeMapping(i);
            AttributeMapping mappedIdAttribute = this.representationEmbeddable.getAttributeMapping(i);
            if (!(virtualIdAttribute instanceof ToOneAttributeMapping) || mappedIdAttribute instanceof ToOneAttributeMapping) continue;
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)virtualIdAttribute;
            ForeignKeyDescriptor fkDescriptor = toOneAttributeMapping.getForeignKeyDescriptor();
            data.idClassState[i] = associationKey = fkDescriptor.getAssociationKeyFromSide(data.virtualIdState[i], toOneAttributeMapping.getSideNature().inverse(), data.getRowProcessingState().getSession());
        }
    }

    @Override
    public void resolveState(RowProcessingState rowProcessingState) {
        if (!this.isFindByIdLookup(rowProcessingState)) {
            for (DomainResultAssembler<?> assembler : this.assemblers) {
                assembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    public boolean isPartOfKey() {
        return true;
    }

    protected Initializer<InitializerData>[] getInitializers() {
        return this.initializers;
    }

    public String toString() {
        return "NonAggregatedIdentifierMappingInitializer(" + this.navigablePath + ") : `" + this.getInitializedPart().getJavaType().getJavaTypeClass() + "`";
    }

    public static class NonAggregatedIdentifierMappingInitializerData
    extends InitializerData
    implements ValueAccess {
        protected final InitializerData parentData;
        protected final Object[] virtualIdState;
        protected final Object[] idClassState;

        public NonAggregatedIdentifierMappingInitializerData(NonAggregatedIdentifierMappingInitializer initializer, RowProcessingState rowProcessingState) {
            super(rowProcessingState);
            this.parentData = initializer.parent == null ? null : initializer.parent.getData(rowProcessingState);
            EmbeddableMappingType virtualIdEmbeddable = initializer.embedded.getEmbeddableTypeDescriptor();
            int size = virtualIdEmbeddable.getNumberOfFetchables();
            this.virtualIdState = new Object[size];
            this.idClassState = new Object[size];
        }

        @Override
        public Object[] getValues() {
            assert (this.getState() == Initializer.State.RESOLVED);
            return this.idClassState;
        }

        @Override
        public <T> T getValue(int i, Class<T> clazz) {
            assert (this.getState() == Initializer.State.RESOLVED);
            return clazz.cast(this.idClassState[i]);
        }

        @Override
        public Object getOwner() {
            return this.parentData == null ? null : this.parentData.getInstance();
        }
    }
}

