/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.FetchNotFoundException;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.EntityUniqueKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerData;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.basic.BasicResultAssembler;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntityInitializerImpl;
import org.hibernate.sql.results.graph.internal.AbstractInitializer;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;
import org.hibernate.type.Type;

public class EntityDelayedFetchInitializer
extends AbstractInitializer<EntityDelayedFetchInitializerData>
implements EntityInitializer<EntityDelayedFetchInitializerData> {
    private final InitializerParent<?> parent;
    private final NavigablePath navigablePath;
    private final boolean isPartOfKey;
    private final ToOneAttributeMapping referencedModelPart;
    private final boolean selectByUniqueKey;
    private final DomainResultAssembler<?> identifierAssembler;
    private final @Nullable BasicResultAssembler<?> discriminatorAssembler;

    public EntityDelayedFetchInitializer(InitializerParent<?> parent, NavigablePath fetchedNavigable, ToOneAttributeMapping referencedModelPart, boolean selectByUniqueKey, DomainResult<?> keyResult, @Nullable BasicFetch<?> discriminatorResult, AssemblerCreationState creationState) {
        super(creationState);
        assert (!referencedModelPart.hasNotFoundAction() || referencedModelPart.getEntityMappingType().isConcreteProxy());
        this.parent = parent;
        this.navigablePath = fetchedNavigable;
        this.isPartOfKey = Initializer.isPartOfKey(fetchedNavigable, parent);
        this.referencedModelPart = referencedModelPart;
        this.selectByUniqueKey = selectByUniqueKey;
        this.identifierAssembler = keyResult.createResultAssembler(this, creationState);
        this.discriminatorAssembler = discriminatorResult == null ? null : (BasicResultAssembler)discriminatorResult.createResultAssembler(this, creationState);
    }

    @Override
    protected InitializerData createInitializerData(RowProcessingState rowProcessingState) {
        return new EntityDelayedFetchInitializerData(rowProcessingState);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPart getInitializedPart() {
        return this.referencedModelPart;
    }

    @Override
    public void resolveFromPreviousRow(EntityDelayedFetchInitializerData data) {
        if (data.getState() == Initializer.State.UNINITIALIZED) {
            if (data.entityIdentifier == null) {
                data.setState(Initializer.State.MISSING);
                data.setInstance(null);
            } else {
                Initializer<?> initializer = this.identifierAssembler.getInitializer();
                if (initializer != null) {
                    initializer.resolveFromPreviousRow(data.getRowProcessingState());
                }
                data.setState(Initializer.State.RESOLVED);
            }
        }
    }

    @Override
    public void resolveInstance(EntityDelayedFetchInitializerData data) {
        if (data.getState() != Initializer.State.KEY_RESOLVED) {
            return;
        }
        data.setState(Initializer.State.RESOLVED);
        RowProcessingState rowProcessingState = data.getRowProcessingState();
        data.entityIdentifier = this.identifierAssembler.assemble(rowProcessingState);
        if (data.entityIdentifier == null) {
            data.setInstance(null);
            data.setState(Initializer.State.MISSING);
        } else {
            EntityPersister concreteDescriptor;
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister entityPersister = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            if (this.discriminatorAssembler != null) {
                concreteDescriptor = EntityInitializerImpl.determineConcreteEntityDescriptor(rowProcessingState, this.discriminatorAssembler, entityPersister);
                if (concreteDescriptor == null) {
                    if (!this.referencedModelPart.isOptional()) {
                        throw new FetchNotFoundException(entityPersister.getEntityName(), data.entityIdentifier);
                    }
                    data.setInstance(null);
                    data.setState(Initializer.State.MISSING);
                    return;
                }
            } else {
                concreteDescriptor = entityPersister;
            }
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            if (this.selectByUniqueKey) {
                String uniqueKeyPropertyName = this.referencedModelPart.getReferencedPropertyName();
                Type uniqueKeyPropertyType = this.referencedModelPart.getReferencedPropertyName() == null ? concreteDescriptor.getIdentifierType() : session.getFactory().getReferencedPropertyType(concreteDescriptor.getEntityName(), uniqueKeyPropertyName);
                EntityUniqueKey euk = new EntityUniqueKey(concreteDescriptor.getEntityName(), uniqueKeyPropertyName, data.entityIdentifier, uniqueKeyPropertyType, session.getFactory());
                data.setInstance(persistenceContext.getEntity(euk));
                if (data.getInstance() == null) {
                    if (this.referencedModelPart.isLazy()) {
                        data.setInstance(LazyPropertyInitializer.UNFETCHED_PROPERTY);
                    } else {
                        data.setInstance(concreteDescriptor.loadByUniqueKey(uniqueKeyPropertyName, data.entityIdentifier, session));
                        if (data.getInstance() != null) {
                            persistenceContext.addEntity(euk, data.getInstance());
                        }
                    }
                }
                if (data.getInstance() != null) {
                    data.setInstance(persistenceContext.proxyFor(data.getInstance()));
                }
            } else {
                EntityKey entityKey = new EntityKey(data.entityIdentifier, concreteDescriptor);
                EntityHolder holder = persistenceContext.getEntityHolder(entityKey);
                if (holder != null && holder.getEntity() != null) {
                    data.setInstance(persistenceContext.proxyFor(holder, concreteDescriptor));
                } else if (this.referencedModelPart.isOptional() && this.referencedModelPart.isLazy()) {
                    data.setInstance(LazyPropertyInitializer.UNFETCHED_PROPERTY);
                } else {
                    data.setInstance(session.internalLoad(concreteDescriptor.getEntityName(), data.entityIdentifier, false, false));
                    LazyInitializer lazyInitializer = HibernateProxy.extractLazyInitializer(data.getInstance());
                    if (lazyInitializer != null) {
                        lazyInitializer.setUnwrap(this.referencedModelPart.isUnwrapProxy() && concreteDescriptor.isInstrumented());
                    }
                }
            }
        }
    }

    @Override
    public void resolveInstance(Object instance, EntityDelayedFetchInitializerData data) {
        if (instance == null) {
            data.setState(Initializer.State.MISSING);
            data.entityIdentifier = null;
            data.setInstance(null);
        } else {
            data.setState(Initializer.State.RESOLVED);
            RowProcessingState rowProcessingState = data.getRowProcessingState();
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            EntityPersister concreteDescriptor = this.referencedModelPart.getEntityMappingType().getEntityPersister();
            data.entityIdentifier = concreteDescriptor.getIdentifier(instance, session);
            data.setInstance(instance);
            Initializer<?> initializer = this.identifierAssembler.getInitializer();
            if (initializer != null) {
                initializer.resolveInstance(data.entityIdentifier, rowProcessingState);
            } else if (rowProcessingState.needsResolveState()) {
                this.identifierAssembler.resolveState(rowProcessingState);
            }
        }
    }

    @Override
    protected void forEachSubInitializer(BiConsumer<Initializer<?>, RowProcessingState> consumer, InitializerData data) {
        Initializer<?> initializer = this.identifierAssembler.getInitializer();
        if (initializer != null) {
            consumer.accept(initializer, data.getRowProcessingState());
        }
    }

    @Override
    public EntityPersister getEntityDescriptor() {
        return this.referencedModelPart.getEntityMappingType().getEntityPersister();
    }

    @Override
    public Object getEntityInstance(EntityDelayedFetchInitializerData data) {
        return data.getInstance();
    }

    @Override
    public @Nullable InitializerParent<?> getParent() {
        return this.parent;
    }

    @Override
    public boolean isPartOfKey() {
        return this.isPartOfKey;
    }

    @Override
    public boolean isResultInitializer() {
        return false;
    }

    @Override
    public EntityPersister getConcreteDescriptor(EntityDelayedFetchInitializerData data) {
        return this.getEntityDescriptor();
    }

    @Override
    public @Nullable Object getEntityIdentifier(EntityDelayedFetchInitializerData data) {
        return data.entityIdentifier;
    }

    public String toString() {
        return "EntityDelayedFetchInitializer(" + LoggingHelper.toLoggableString(this.navigablePath) + ")";
    }

    protected boolean isSelectByUniqueKey() {
        return this.selectByUniqueKey;
    }

    protected DomainResultAssembler<?> getIdentifierAssembler() {
        return this.identifierAssembler;
    }

    protected @Nullable BasicResultAssembler<?> getDiscriminatorAssembler() {
        return this.discriminatorAssembler;
    }

    public static class EntityDelayedFetchInitializerData
    extends InitializerData {
        protected @Nullable Object entityIdentifier;

        public EntityDelayedFetchInitializerData(RowProcessingState rowProcessingState) {
            super(rowProcessingState);
        }
    }
}

