/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.collection.internal.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.graph.instantiation.DynamicInstantiationResult;
import org.hibernate.sql.results.internal.InitializersList;
import org.hibernate.sql.results.internal.NavigablePathMapToInitializer;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesMappingResolutionImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingResolution;

public class StandardJdbcValuesMapping
implements JdbcValuesMapping {
    private final List<SqlSelection> sqlSelections;
    private final List<DomainResult<?>> domainResults;
    private JdbcValuesMappingResolutionImpl resolution;

    public StandardJdbcValuesMapping(List<SqlSelection> sqlSelections, List<DomainResult<?>> domainResults) {
        this.sqlSelections = sqlSelections;
        this.domainResults = domainResults;
    }

    @Override
    public List<SqlSelection> getSqlSelections() {
        return this.sqlSelections;
    }

    @Override
    public List<DomainResult<?>> getDomainResults() {
        return this.domainResults;
    }

    @Override
    public int getRowSize() {
        return this.sqlSelections.size();
    }

    @Override
    public JdbcValuesMappingResolution resolveAssemblers(SessionFactoryImplementor sessionFactory) {
        JdbcValuesMappingResolutionImpl resolution = this.resolution;
        if (resolution != null) {
            return resolution;
        }
        AssemblerCreationStateImpl creationState = new AssemblerCreationStateImpl(this, sessionFactory);
        DomainResultAssembler[] domainResultAssemblers = this.resolveAssemblers(creationState).toArray(new DomainResultAssembler[0]);
        creationState.initializerMap.logInitializers();
        this.resolution = new JdbcValuesMappingResolutionImpl(domainResultAssemblers, creationState.hasCollectionInitializers, creationState.initializerListBuilder.build());
        return this.resolution;
    }

    private List<DomainResultAssembler<?>> resolveAssemblers(AssemblerCreationState creationState) {
        ArrayList<DomainResultAssembler<?>> assemblers = CollectionHelper.arrayList(this.domainResults.size());
        for (int i = 0; i < this.domainResults.size(); ++i) {
            DomainResultAssembler<?> resultAssembler = this.domainResults.get(i).createResultAssembler(null, creationState);
            assemblers.add(resultAssembler);
        }
        return assemblers;
    }

    @Override
    public LockMode determineDefaultLockMode(String alias, LockMode defaultLockMode) {
        return defaultLockMode;
    }

    private static class AssemblerCreationStateImpl
    implements AssemblerCreationState {
        private final JdbcValuesMapping jdbcValuesMapping;
        private final SessionFactoryImplementor sessionFactory;
        private final NavigablePathMapToInitializer initializerMap = new NavigablePathMapToInitializer();
        private final InitializersList.Builder initializerListBuilder = new InitializersList.Builder();
        private int initializerId;
        boolean hasCollectionInitializers;
        Boolean dynamicInstantiation;
        Boolean containsMultipleCollectionFetches;

        public AssemblerCreationStateImpl(JdbcValuesMapping jdbcValuesMapping, SessionFactoryImplementor sessionFactory) {
            this.jdbcValuesMapping = jdbcValuesMapping;
            this.sessionFactory = sessionFactory;
        }

        @Override
        public boolean isDynamicInstantiation() {
            if (this.dynamicInstantiation == null) {
                this.dynamicInstantiation = this.jdbcValuesMapping.getDomainResults().stream().anyMatch(domainResult -> domainResult instanceof DynamicInstantiationResult);
            }
            return this.dynamicInstantiation;
        }

        @Override
        public boolean containsMultipleCollectionFetches() {
            if (this.containsMultipleCollectionFetches == null) {
                int collectionFetchesCount = 0;
                for (DomainResult<?> domainResult : this.jdbcValuesMapping.getDomainResults()) {
                    if (!(domainResult instanceof FetchParent)) continue;
                    collectionFetchesCount += ((FetchParent)((Object)domainResult)).getCollectionFetchesCount();
                }
                this.containsMultipleCollectionFetches = collectionFetchesCount > 1;
            }
            return this.containsMultipleCollectionFetches;
        }

        @Override
        public int acquireInitializerId() {
            return this.initializerId++;
        }

        @Override
        public Initializer<?> resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, Supplier<Initializer<?>> producer) {
            return this.resolveInitializer(navigablePath, fetchedModelPart, null, null, (resultGraphNode, parent, creationState) -> (Initializer)producer.get());
        }

        @Override
        public <P extends FetchParent> Initializer<?> resolveInitializer(P resultGraphNode, InitializerParent<?> parent, InitializerProducer<P> producer) {
            return this.resolveInitializer(resultGraphNode.getNavigablePath(), resultGraphNode.getReferencedModePart(), resultGraphNode, parent, producer);
        }

        public <T extends FetchParent> Initializer<?> resolveInitializer(NavigablePath navigablePath, ModelPart fetchedModelPart, T resultGraphNode, InitializerParent<?> parent, InitializerProducer<T> producer) {
            Initializer<?> existing = this.initializerMap.get(navigablePath);
            if (existing != null && fetchedModelPart.getNavigableRole().equals(existing.getInitializedPart().getNavigableRole())) {
                ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("Returning previously-registered initializer : %s", existing);
                return existing;
            }
            Initializer<?> initializer = producer.createInitializer(resultGraphNode, parent, this);
            ResultsLogger.RESULTS_MESSAGE_LOGGER.tracef("Registering initializer : %s", initializer);
            if (initializer instanceof AbstractImmediateCollectionInitializer) {
                this.hasCollectionInitializers = true;
            }
            this.initializerMap.put(navigablePath, initializer);
            this.initializerListBuilder.addInitializer(initializer);
            return initializer;
        }

        @Override
        public SqlAstCreationContext getSqlAstCreationContext() {
            return this.sessionFactory;
        }
    }
}

