/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.hbm.transform;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.EntityInfo;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UnionSubclass;

public class TransformationHelper {
    public static String determineEntityName(EntityInfo hbmEntity, JaxbHbmHibernateMapping hibernateMapping) {
        if (StringHelper.isNotEmpty(hbmEntity.getEntityName())) {
            return hbmEntity.getEntityName();
        }
        String className = hbmEntity.getName();
        assert (StringHelper.isNotEmpty(className));
        return StringHelper.qualifyConditionallyIfNot(hibernateMapping.getPackage(), className);
    }

    public static <T> void transfer(Supplier<T> source, Consumer<T> target) {
        T value = source.get();
        if (value != null) {
            target.accept(value);
        }
    }

    public static Table determineEntityTable(PersistentClass persistentClass) {
        if (persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)persistentClass;
            return rootClass.getTable();
        }
        if (persistentClass instanceof SingleTableSubclass) {
            SingleTableSubclass discriminatedSubclass = (SingleTableSubclass)persistentClass;
            return discriminatedSubclass.getRootTable();
        }
        if (persistentClass instanceof JoinedSubclass) {
            JoinedSubclass joinedSubclass = (JoinedSubclass)persistentClass;
            return joinedSubclass.getTable();
        }
        if (persistentClass instanceof UnionSubclass) {
            UnionSubclass unionSubclass = (UnionSubclass)persistentClass;
            return unionSubclass.getTable();
        }
        throw new MappingException("Unexpected PersistentClass subtype : " + persistentClass);
    }
}

