/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.mapping;

import java.util.EnumSet;
import java.util.Locale;
import org.hibernate.generator.EventType;

public enum GenerationTiming {
    NEVER,
    INSERT,
    UPDATE,
    ALWAYS;


    public boolean includesInsert() {
        return this == INSERT || this == ALWAYS;
    }

    public boolean includesUpdate() {
        return this == UPDATE || this == ALWAYS;
    }

    public boolean includes(GenerationTiming timing) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NEVER -> {
                if (timing == NEVER) {
                    yield true;
                }
                yield false;
            }
            case INSERT -> timing.includesInsert();
            case UPDATE -> timing.includesUpdate();
            case ALWAYS -> true;
        };
    }

    public static GenerationTiming parseFromName(String name) {
        return switch (name.toLowerCase(Locale.ROOT)) {
            case "insert" -> INSERT;
            case "update" -> UPDATE;
            case "always" -> ALWAYS;
            default -> NEVER;
        };
    }

    public EnumSet<EventType> getEventTypes() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ALWAYS -> EnumSet.allOf(EventType.class);
            case INSERT -> EnumSet.of(EventType.INSERT);
            case UPDATE -> EnumSet.of(EventType.UPDATE);
            case NEVER -> null;
        };
    }
}

