/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.Array;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Checks;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.FractionalSeconds;
import org.hibernate.annotations.GeneratedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.CannotForceNonNullableException;
import org.hibernate.boot.model.internal.DialectOverridesAnnotationHelper;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.jboss.logging.Logger;

public class AnnotatedColumn {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)AnnotatedColumn.class.getName());
    private org.hibernate.mapping.Column mappingColumn;
    private boolean insertable = true;
    private boolean updatable = true;
    private String explicitTableName;
    private boolean isImplicit;
    public String sqlType;
    private Long length;
    private Integer precision;
    private Integer scale;
    private Integer temporalPrecision;
    private Integer arrayLength;
    private String logicalColumnName;
    private boolean unique;
    private boolean nullable = true;
    private String formulaString;
    private Formula formula;
    private String readExpression;
    private String writeExpression;
    private String defaultValue;
    private String generatedAs;
    private final List<CheckConstraint> checkConstraints = new ArrayList<CheckConstraint>();
    private AnnotatedColumns parent;
    private String options;
    private String comment;

    public AnnotatedColumns getParent() {
        return this.parent;
    }

    public void setParent(AnnotatedColumns parent) {
        parent.addColumn(this);
        this.parent = parent;
    }

    public String getLogicalColumnName() {
        return this.logicalColumnName;
    }

    public String getSqlType() {
        return this.sqlType;
    }

    public Long getLength() {
        return this.length;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public void setArrayLength(Integer arrayLength) {
        this.arrayLength = arrayLength;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isFormula() {
        return StringHelper.isNotEmpty(this.formulaString);
    }

    public String getExplicitTableName() {
        return this.explicitTableName;
    }

    public void setExplicitTableName(String explicitTableName) {
        this.explicitTableName = "``".equals(explicitTableName) ? "" : explicitTableName;
    }

    public void setFormula(String formula) {
        this.formulaString = formula;
    }

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setImplicit(boolean implicit) {
        this.isImplicit = implicit;
    }

    public void setSqlType(String sqlType) {
        this.sqlType = sqlType;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setTemporalPrecision(Integer temporalPrecision) {
        this.temporalPrecision = temporalPrecision;
    }

    public void setLogicalColumnName(String logicalColumnName) {
        this.logicalColumnName = logicalColumnName;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isNullable() {
        return this.isFormula() || this.mappingColumn.isNullable();
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addCheckConstraint(String name, String constraint) {
        this.checkConstraints.add(new CheckConstraint(name, constraint));
    }

    public void addCheckConstraint(String name, String constraint, String options) {
        this.checkConstraints.add(new CheckConstraint(name, constraint, options));
    }

    public String getGeneratedAs() {
        return this.generatedAs;
    }

    private void setGeneratedAs(String as) {
        this.generatedAs = as;
    }

    public void bind() {
        if (StringHelper.isNotEmpty(this.formulaString)) {
            LOG.debugf("Binding formula %s", this.formulaString);
            this.formula = new Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            this.initMappingColumn(this.logicalColumnName, this.getParent().getPropertyName(), this.length, this.precision, this.scale, this.temporalPrecision, this.arrayLength, this.nullable, this.sqlType, this.unique, true);
            if (this.defaultValue != null) {
                this.mappingColumn.setDefaultValue(this.defaultValue);
            }
            for (CheckConstraint constraint : this.checkConstraints) {
                this.mappingColumn.addCheckConstraint(constraint);
            }
            this.mappingColumn.setOptions(this.options);
            if (StringHelper.isNotEmpty(this.comment)) {
                this.mappingColumn.setComment(this.comment);
            }
            if (this.generatedAs != null) {
                this.mappingColumn.setGeneratedAs(this.generatedAs);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding column: %s", this.toString());
            }
        }
    }

    protected void initMappingColumn(String columnName, String propertyName, Long length, Integer precision, Integer scale, Integer temporalPrecision, Integer arrayLength, boolean nullable, String sqlType, boolean unique, boolean applyNamingStrategy) {
        if (StringHelper.isNotEmpty(this.formulaString)) {
            this.formula = new Formula();
            this.formula.setFormula(this.formulaString);
        } else {
            int numberOfJdbcParams;
            this.mappingColumn = new org.hibernate.mapping.Column();
            this.mappingColumn.setExplicit(!this.isImplicit);
            this.redefineColumnName(columnName, propertyName, applyNamingStrategy);
            this.mappingColumn.setLength(length);
            if (precision != null && precision > 0) {
                this.mappingColumn.setPrecision(precision);
                this.mappingColumn.setScale(scale);
            }
            if (temporalPrecision != null) {
                this.mappingColumn.setTemporalPrecision(temporalPrecision);
            }
            this.mappingColumn.setArrayLength(arrayLength);
            this.mappingColumn.setNullable(nullable);
            this.mappingColumn.setSqlType(sqlType);
            if (unique) {
                this.getParent().getTable().createUniqueKey(this.mappingColumn, this.getBuildingContext());
            }
            for (CheckConstraint constraint : this.checkConstraints) {
                this.mappingColumn.addCheckConstraint(constraint);
            }
            this.mappingColumn.setDefaultValue(this.defaultValue);
            this.mappingColumn.setOptions(this.options);
            this.mappingColumn.setComment(this.comment);
            if (this.writeExpression != null && (numberOfJdbcParams = StringHelper.count(this.writeExpression, '?')) != 1) {
                throw new AnnotationException("Write expression in '@ColumnTransformer' for property '" + propertyName + "' and column '" + this.logicalColumnName + "' must contain exactly one placeholder character ('?')");
            }
            this.mappingColumn.setResolvedCustomRead(this.readExpression);
            this.mappingColumn.setCustomWrite(this.writeExpression);
        }
    }

    public boolean isNameDeferred() {
        return this.mappingColumn == null || StringHelper.isEmpty(this.mappingColumn.getName());
    }

    public void redefineColumnName(String columnName, String propertyName, boolean applyNamingStrategy) {
        if (StringHelper.isNotEmpty(columnName)) {
            this.mappingColumn.setName(this.processColumnName(columnName, applyNamingStrategy));
        } else if (propertyName != null && applyNamingStrategy) {
            this.mappingColumn.setName(this.inferColumnName(propertyName));
        }
    }

    private String processColumnName(String columnName, boolean applyNamingStrategy) {
        if (applyNamingStrategy) {
            Database database = this.getBuildingContext().getMetadataCollector().getDatabase();
            return this.getBuildingContext().getBuildingOptions().getPhysicalNamingStrategy().toPhysicalColumnName(database.toIdentifier(columnName), database.getJdbcEnvironment()).render(database.getDialect());
        }
        return this.getBuildingContext().getObjectNameNormalizer().toDatabaseIdentifierText(columnName);
    }

    private String inferColumnName(final String propertyName) {
        ImplicitNamingStrategy implicitNamingStrategy;
        Database database = this.getBuildingContext().getMetadataCollector().getDatabase();
        ObjectNameNormalizer normalizer = this.getBuildingContext().getObjectNameNormalizer();
        Identifier implicitName = normalizer.normalizeIdentifierQuoting((implicitNamingStrategy = this.getBuildingContext().getBuildingOptions().getImplicitNamingStrategy()).determineBasicColumnName(new ImplicitBasicColumnNameSource(){
            final AttributePath attributePath;
            {
                this.attributePath = AttributePath.parse(propertyName);
            }

            @Override
            public AttributePath getAttributePath() {
                return this.attributePath;
            }

            @Override
            public boolean isCollectionElement() {
                PropertyHolder propertyHolder = AnnotatedColumn.this.getParent().getPropertyHolder();
                return !propertyHolder.isComponent() && !propertyHolder.isEntity();
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return AnnotatedColumn.this.getBuildingContext();
            }
        }));
        if (implicitName.getText().contains("_{element}_")) {
            implicitName = Identifier.toIdentifier(implicitName.getText().replace("_{element}_", "_"), implicitName.isQuoted());
        }
        return this.getBuildingContext().getBuildingOptions().getPhysicalNamingStrategy().toPhysicalColumnName(implicitName, database.getJdbcEnvironment()).render(database.getDialect());
    }

    public String getName() {
        return this.mappingColumn.getName();
    }

    public org.hibernate.mapping.Column getMappingColumn() {
        return this.mappingColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
        if (this.mappingColumn != null) {
            this.mappingColumn.setNullable(nullable);
        }
    }

    protected void setMappingColumn(org.hibernate.mapping.Column mappingColumn) {
        this.mappingColumn = mappingColumn;
    }

    public void linkWithAggregateValue(SimpleValue value, Component component) {
        this.mappingColumn = new AggregateColumn(this.mappingColumn, component);
        this.linkWithValue(value);
    }

    public void linkWithValue(SimpleValue value) {
        if (this.formula != null) {
            value.addFormula(this.formula);
        } else {
            Table table = value.getTable();
            this.getParent().setTable(table);
            this.getMappingColumn().setValue(value);
            value.addColumn(this.getMappingColumn(), this.insertable, this.updatable);
            table.addColumn(this.getMappingColumn());
            this.addColumnBinding(value);
        }
    }

    protected void addColumnBinding(SimpleValue value) {
        String logicalColumnName;
        final MetadataBuildingContext context = this.getBuildingContext();
        InFlightMetadataCollector collector = context.getMetadataCollector();
        if (StringHelper.isNotEmpty(this.logicalColumnName)) {
            logicalColumnName = this.logicalColumnName;
        } else {
            Identifier implicitName = context.getObjectNameNormalizer().normalizeIdentifierQuoting(context.getBuildingOptions().getImplicitNamingStrategy().determineBasicColumnName(new ImplicitBasicColumnNameSource(){

                @Override
                public AttributePath getAttributePath() {
                    return AttributePath.parse(AnnotatedColumn.this.getParent().getPropertyName());
                }

                @Override
                public boolean isCollectionElement() {
                    return false;
                }

                @Override
                public MetadataBuildingContext getBuildingContext() {
                    return context;
                }
            }));
            logicalColumnName = implicitName.render(collector.getDatabase().getDialect());
        }
        collector.addColumnNameBinding(value.getTable(), logicalColumnName, this.getMappingColumn());
    }

    public void forceNotNull() {
        if (this.mappingColumn == null) {
            throw new CannotForceNonNullableException("Cannot perform #forceNotNull because internal org.hibernate.mapping.Column reference is null: likely a formula");
        }
        this.nullable = false;
        this.mappingColumn.setNullable(false);
    }

    public static AnnotatedColumns buildFormulaFromAnnotation(org.hibernate.annotations.Formula formulaAnn, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnOrFormulaFromAnnotation(null, formulaAnn, null, nullability, propertyHolder, inferredData, secondaryTables, context);
    }

    public static AnnotatedColumns buildColumnFromNoAnnotation(FractionalSeconds fractionalSeconds, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsFromAnnotations(null, fractionalSeconds, nullability, propertyHolder, inferredData, secondaryTables, context);
    }

    public static AnnotatedColumns buildColumnFromAnnotation(Column column, FractionalSeconds fractionalSeconds, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnOrFormulaFromAnnotation(column, null, fractionalSeconds, nullability, propertyHolder, inferredData, secondaryTables, context);
    }

    public static AnnotatedColumns buildColumnsFromAnnotations(Column[] columns, FractionalSeconds fractionalSeconds, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsOrFormulaFromAnnotation(columns, null, fractionalSeconds, nullability, propertyHolder, inferredData, null, secondaryTables, context);
    }

    public static AnnotatedColumns buildColumnsFromAnnotations(Column[] columns, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        return AnnotatedColumn.buildColumnsOrFormulaFromAnnotation(columns, null, null, nullability, propertyHolder, inferredData, suffixForDefaultColumnName, secondaryTables, context);
    }

    public static AnnotatedColumns buildColumnOrFormulaFromAnnotation(Column column, org.hibernate.annotations.Formula formulaAnn, FractionalSeconds fractionalSeconds, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        Column[] columnArray;
        if (column == null) {
            columnArray = null;
        } else {
            Column[] columnArray2 = new Column[1];
            columnArray = columnArray2;
            columnArray2[0] = column;
        }
        return AnnotatedColumn.buildColumnsOrFormulaFromAnnotation(columnArray, formulaAnn, fractionalSeconds, nullability, propertyHolder, inferredData, null, secondaryTables, context);
    }

    public static AnnotatedColumns buildColumnsOrFormulaFromAnnotation(Column[] columns, org.hibernate.annotations.Formula formulaAnn, FractionalSeconds fractionalSeconds, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context) {
        if (formulaAnn != null) {
            AnnotatedColumns parent = new AnnotatedColumns();
            parent.setPropertyHolder(propertyHolder);
            parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
            parent.setBuildingContext(context);
            parent.setJoins(secondaryTables);
            AnnotatedColumn formulaColumn = new AnnotatedColumn();
            formulaColumn.setFormula(formulaAnn.value());
            formulaColumn.setImplicit(false);
            formulaColumn.setParent(parent);
            formulaColumn.bind();
            return parent;
        }
        Object[] actualColumns = AnnotatedColumn.overrideColumns(columns, propertyHolder, inferredData);
        if (ArrayHelper.isEmpty(actualColumns)) {
            return AnnotatedColumn.buildImplicitColumn(fractionalSeconds, inferredData, suffixForDefaultColumnName, secondaryTables, propertyHolder, nullability, context);
        }
        return AnnotatedColumn.buildExplicitColumns(propertyHolder, inferredData, suffixForDefaultColumnName, secondaryTables, context, (Column[])actualColumns, fractionalSeconds);
    }

    private static Column[] overrideColumns(Column[] columns, PropertyHolder propertyHolder, PropertyData inferredData) {
        String path = BinderHelper.getPath(propertyHolder, inferredData);
        Object[] overriddenCols = propertyHolder.getOverriddenColumn(path);
        if (overriddenCols != null) {
            if (columns != null && overriddenCols.length != columns.length) {
                throw new AnnotationException("Property '" + path + "' specifies " + columns.length + " '@AttributeOverride's but the overridden property has " + overriddenCols.length + " columns (every column must have exactly one '@AttributeOverride')");
            }
            LOG.debugf("Column(s) overridden for property %s", inferredData.getPropertyName());
            return ArrayHelper.isEmpty(overriddenCols) ? null : overriddenCols;
        }
        return columns;
    }

    private static AnnotatedColumns buildExplicitColumns(PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, MetadataBuildingContext context, Column[] actualCols, FractionalSeconds fractionalSeconds) {
        AnnotatedColumns parent = new AnnotatedColumns();
        parent.setPropertyHolder(propertyHolder);
        parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
        parent.setJoins(secondaryTables);
        parent.setBuildingContext(context);
        for (Column column : actualCols) {
            Database database = context.getMetadataCollector().getDatabase();
            String sqlType = AnnotatedColumn.getSqlType(context, column);
            String tableName = AnnotatedColumn.getTableName(column, database);
            AnnotatedColumn.buildColumn(propertyHolder, inferredData, suffixForDefaultColumnName, parent, actualCols.length, database, column, fractionalSeconds, sqlType, tableName, context.getMetadataCollector().getSourceModelBuildingContext());
        }
        return parent;
    }

    private static String getTableName(Column column, Database database) {
        String table = column.table();
        return table.isEmpty() ? "" : database.getJdbcEnvironment().getIdentifierHelper().toIdentifier(table).render();
    }

    private static String getSqlType(MetadataBuildingContext context, Column column) {
        String columnDefinition = column.columnDefinition();
        return columnDefinition.isEmpty() ? null : context.getObjectNameNormalizer().applyGlobalQuoting(columnDefinition);
    }

    private static AnnotatedColumn buildColumn(PropertyHolder propertyHolder, PropertyData inferredData, String suffixForDefaultColumnName, AnnotatedColumns parent, int numberOfColumns, Database database, Column column, FractionalSeconds fractionalSeconds, String sqlType, String tableName, SourceModelBuildingContext sourceModelContext) {
        String columnName = AnnotatedColumn.logicalColumnName(inferredData, suffixForDefaultColumnName, database, column);
        AnnotatedColumn annotatedColumn = new AnnotatedColumn();
        annotatedColumn.setLogicalColumnName(columnName);
        annotatedColumn.setImplicit(false);
        annotatedColumn.setSqlType(sqlType);
        annotatedColumn.setLength(Long.valueOf(column.length()));
        if (fractionalSeconds != null) {
            annotatedColumn.setTemporalPrecision(fractionalSeconds.value());
        } else {
            annotatedColumn.setPrecision(column.precision());
            Integer secondPrecision = column.annotationType() == Column.class ? Integer.valueOf(column.secondPrecision()) : null;
            annotatedColumn.setTemporalPrecision(secondPrecision == null || secondPrecision == -1 ? null : secondPrecision);
        }
        annotatedColumn.setScale(column.scale());
        annotatedColumn.handleArrayLength(inferredData);
        annotatedColumn.setNullable(column.nullable());
        annotatedColumn.setUnique(column.unique());
        annotatedColumn.setInsertable(column.insertable());
        annotatedColumn.setUpdatable(column.updatable());
        annotatedColumn.setExplicitTableName(tableName);
        annotatedColumn.setParent(parent);
        annotatedColumn.applyColumnDefault(inferredData, numberOfColumns);
        annotatedColumn.applyGeneratedAs(inferredData, numberOfColumns);
        annotatedColumn.applyColumnCheckConstraint(column);
        annotatedColumn.applyColumnOptions(column);
        annotatedColumn.applyColumnComment(column);
        annotatedColumn.applyCheckConstraint(inferredData, numberOfColumns);
        annotatedColumn.extractDataFromPropertyData(propertyHolder, inferredData, sourceModelContext);
        annotatedColumn.bind();
        return annotatedColumn;
    }

    private void handleArrayLength(PropertyData inferredData) {
        Array arrayAnn = (Array)inferredData.getAttributeMember().getDirectAnnotationUsage(Array.class);
        if (arrayAnn != null) {
            this.setArrayLength(arrayAnn.length());
        }
    }

    private static String logicalColumnName(PropertyData inferredData, String suffixForDefaultColumnName, Database database, Column column) {
        String columnName = AnnotatedColumn.getColumnName(database, column);
        return StringHelper.isEmpty(columnName) && StringHelper.isNotEmpty(suffixForDefaultColumnName) ? inferredData.getPropertyName() + suffixForDefaultColumnName : columnName;
    }

    private static String getColumnName(Database database, Column column) {
        String name = column.name();
        return name.isEmpty() ? null : database.getJdbcEnvironment().getIdentifierHelper().toIdentifier(name).render();
    }

    void applyColumnDefault(PropertyData inferredData, int length) {
        MemberDetails attributeMember = inferredData.getAttributeMember();
        if (attributeMember != null) {
            ColumnDefault columnDefault = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)attributeMember, ColumnDefault.class, this.getBuildingContext());
            if (columnDefault != null) {
                if (length != 1) {
                    throw new AnnotationException("'@ColumnDefault' may only be applied to single-column mappings but '" + attributeMember.getName() + "' maps to " + length + " columns");
                }
                this.setDefaultValue(columnDefault.value());
            }
        } else {
            LOG.trace("Could not perform @ColumnDefault lookup as 'PropertyData' did not give access to XProperty");
        }
    }

    void applyGeneratedAs(PropertyData inferredData, int length) {
        MemberDetails attributeMember = inferredData.getAttributeMember();
        if (attributeMember != null) {
            GeneratedColumn generatedColumn = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)attributeMember, GeneratedColumn.class, this.getBuildingContext());
            if (generatedColumn != null) {
                if (length != 1) {
                    throw new AnnotationException("'@GeneratedColumn' may only be applied to single-column mappings but '" + attributeMember.getName() + "' maps to " + length + " columns");
                }
                this.setGeneratedAs(generatedColumn.value());
            }
        } else {
            LOG.trace("Could not perform @GeneratedColumn lookup as 'PropertyData' did not give access to XProperty");
        }
    }

    private void applyColumnCheckConstraint(Column column) {
        this.applyCheckConstraints(column.check());
    }

    void applyCheckConstraints(jakarta.persistence.CheckConstraint[] checkConstraintAnnotationUsages) {
        if (CollectionHelper.isNotEmpty(checkConstraintAnnotationUsages)) {
            for (jakarta.persistence.CheckConstraint checkConstraintAnnotationUsage : checkConstraintAnnotationUsages) {
                this.addCheckConstraint(checkConstraintAnnotationUsage.name(), checkConstraintAnnotationUsage.constraint(), checkConstraintAnnotationUsage.options());
            }
        }
    }

    void applyCheckConstraint(PropertyData inferredData, int length) {
        MemberDetails attributeMember = inferredData.getAttributeMember();
        if (attributeMember != null) {
            Checks checksAnn = (Checks)attributeMember.getDirectAnnotationUsage(Checks.class);
            if (checksAnn != null) {
                Check[] checkAnns;
                for (Check checkAnn : checkAnns = checksAnn.value()) {
                    this.addCheckConstraint(checkAnn.name(), checkAnn.constraints());
                }
            } else {
                Check checkAnn = DialectOverridesAnnotationHelper.getOverridableAnnotation((AnnotationTarget)attributeMember, Check.class, this.getBuildingContext());
                if (checkAnn != null) {
                    if (length != 1) {
                        throw new AnnotationException("'@Check' may only be applied to single-column mappings but '" + attributeMember.getName() + "' maps to " + length + " columns (use a table-level '@Check')");
                    }
                    this.addCheckConstraint(StringHelper.nullIfEmpty(checkAnn.name()), checkAnn.constraints());
                }
            }
        } else {
            LOG.trace("Could not perform @Check lookup as 'PropertyData' did not give access to XProperty");
        }
    }

    private void extractDataFromPropertyData(PropertyHolder propertyHolder, PropertyData inferredData, SourceModelBuildingContext context) {
        MemberDetails attributeMember;
        if (inferredData != null && (attributeMember = inferredData.getAttributeMember()) != null) {
            if (propertyHolder.isComponent()) {
                this.processColumnTransformerExpressions(propertyHolder.getOverriddenColumnTransformer(this.logicalColumnName));
            }
            attributeMember.forEachAnnotationUsage(ColumnTransformer.class, context, this::processColumnTransformerExpressions);
        }
    }

    private void processColumnTransformerExpressions(ColumnTransformer annotation) {
        if (annotation == null) {
            return;
        }
        String targetColumnName = annotation.forColumn();
        if (StringHelper.isEmpty(targetColumnName) || targetColumnName.equals(this.logicalColumnName != null ? this.logicalColumnName : "")) {
            this.readExpression = StringHelper.nullIfEmpty(annotation.read());
            this.writeExpression = StringHelper.nullIfEmpty(annotation.write());
        }
    }

    private static AnnotatedColumns buildImplicitColumn(FractionalSeconds fractionalSeconds, PropertyData inferredData, String suffixForDefaultColumnName, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, Nullability nullability, MetadataBuildingContext context) {
        AnnotatedColumns columns = new AnnotatedColumns();
        columns.setPropertyHolder(propertyHolder);
        columns.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
        columns.setBuildingContext(context);
        columns.setJoins(secondaryTables);
        columns.setPropertyHolder(propertyHolder);
        AnnotatedColumn column = new AnnotatedColumn();
        if (nullability != Nullability.FORCED_NULL && !PropertyBinder.isOptional(inferredData.getAttributeMember(), propertyHolder)) {
            column.setNullable(false);
        }
        String propertyName = inferredData.getPropertyName();
        boolean implicit = StringHelper.isEmpty(suffixForDefaultColumnName);
        if (!implicit) {
            column.setLogicalColumnName(propertyName + suffixForDefaultColumnName);
        }
        column.setImplicit(implicit);
        column.setParent(columns);
        column.applyColumnDefault(inferredData, 1);
        column.applyGeneratedAs(inferredData, 1);
        column.applyCheckConstraint(inferredData, 1);
        column.extractDataFromPropertyData(propertyHolder, inferredData, context.getMetadataCollector().getSourceModelBuildingContext());
        column.handleArrayLength(inferredData);
        if (fractionalSeconds != null) {
            column.setTemporalPrecision(fractionalSeconds.value());
        }
        column.bind();
        return columns;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName()).append("(");
        if (StringHelper.isNotEmpty(this.logicalColumnName)) {
            string.append("column='").append(this.logicalColumnName).append("',");
        }
        if (StringHelper.isNotEmpty(this.formulaString)) {
            string.append("formula='").append(this.formulaString).append("',");
        }
        if (string.charAt(string.length() - 1) == ',') {
            string.setLength(string.length() - 1);
        }
        string.append(")");
        return string.toString();
    }

    MetadataBuildingContext getBuildingContext() {
        return this.getParent().getBuildingContext();
    }

    private void applyColumnOptions(Column column) {
        this.options = column.options();
    }

    private void applyColumnComment(Column column) {
        if (!column.comment().isEmpty()) {
            this.comment = column.comment();
        }
    }

    void setOptions(String options) {
        this.options = options;
    }
}

