/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.JoinColumn;
import jakarta.persistence.PrimaryKeyJoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;

public class AnnotatedJoinColumn
extends AnnotatedColumn {
    private String referencedColumn;

    private AnnotatedJoinColumn() {
    }

    public void setReferencedColumn(String referencedColumn) {
        this.referencedColumn = StringHelper.nullIfEmpty(referencedColumn);
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public boolean isReferenceImplicit() {
        return StringHelper.isEmpty(this.referencedColumn);
    }

    static AnnotatedJoinColumn buildJoinColumn(JoinColumn joinColumn, String mappedBy, AnnotatedJoinColumns parent, PropertyHolder propertyHolder, PropertyData inferredData) {
        String path = StringHelper.qualify(propertyHolder.getPath(), inferredData.getPropertyName());
        JoinColumn[] overrides = propertyHolder.getOverriddenJoinColumn(path);
        if (overrides != null) {
            throw new AnnotationException("Property '" + path + "' overrides mapping specified using '@JoinColumnOrFormula'");
        }
        return AnnotatedJoinColumn.buildJoinColumn(joinColumn, mappedBy, parent, propertyHolder, inferredData, "");
    }

    public static AnnotatedJoinColumn buildJoinFormula(JoinFormula joinFormula, AnnotatedJoinColumns parent) {
        AnnotatedJoinColumn formulaColumn = new AnnotatedJoinColumn();
        formulaColumn.setFormula(joinFormula.value());
        formulaColumn.setReferencedColumn(joinFormula.referencedColumnName());
        formulaColumn.setParent(parent);
        formulaColumn.bind();
        return formulaColumn;
    }

    static AnnotatedJoinColumn buildJoinColumn(JoinColumn joinColumn, String mappedBy, AnnotatedJoinColumns parent, PropertyHolder propertyHolder, PropertyData inferredData, String defaultColumnSuffix) {
        if (joinColumn != null) {
            if (mappedBy != null) {
                throw new AnnotationException("Association '" + BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()) + "' is 'mappedBy' a different entity and may not explicitly specify the '@JoinColumn'");
            }
            return AnnotatedJoinColumn.explicitJoinColumn(joinColumn, parent, inferredData, defaultColumnSuffix);
        }
        return AnnotatedJoinColumn.implicitJoinColumn(parent, inferredData, defaultColumnSuffix);
    }

    private static AnnotatedJoinColumn explicitJoinColumn(JoinColumn joinColumn, AnnotatedJoinColumns parent, PropertyData inferredData, String defaultColumnSuffix) {
        AnnotatedJoinColumn column = new AnnotatedJoinColumn();
        if (StringHelper.isEmpty(column.getLogicalColumnName()) && StringHelper.isNotEmpty(defaultColumnSuffix)) {
            column.setLogicalColumnName(inferredData.getPropertyName() + defaultColumnSuffix);
        }
        column.setImplicit(false);
        column.setParent(parent);
        column.applyJoinAnnotation(joinColumn, null);
        column.applyColumnDefault(inferredData, parent.getColumns().size());
        column.bind();
        return column;
    }

    private static AnnotatedJoinColumn implicitJoinColumn(AnnotatedJoinColumns parent, PropertyData inferredData, String defaultColumnSuffix) {
        AnnotatedJoinColumn column = new AnnotatedJoinColumn();
        if (StringHelper.isNotEmpty(defaultColumnSuffix)) {
            column.setLogicalColumnName(inferredData.getPropertyName() + defaultColumnSuffix);
            column.setImplicit(false);
        } else {
            column.setImplicit(true);
        }
        column.setParent(parent);
        column.applyColumnDefault(inferredData, parent.getColumns().size());
        column.bind();
        return column;
    }

    public void applyJoinAnnotation(JoinColumn joinColumn, String defaultName) {
        if (joinColumn == null) {
            this.setImplicit(true);
        } else {
            String columnDefinition;
            this.setImplicit(false);
            String name = joinColumn.name();
            if (!name.isEmpty()) {
                this.setLogicalColumnName(name);
            }
            if (!(columnDefinition = joinColumn.columnDefinition()).isEmpty()) {
                this.setSqlType(this.getBuildingContext().getObjectNameNormalizer().applyGlobalQuoting(columnDefinition));
            }
            this.setNullable(joinColumn.nullable());
            this.setUnique(joinColumn.unique());
            this.setInsertable(joinColumn.insertable());
            this.setUpdatable(joinColumn.updatable());
            this.setReferencedColumn(joinColumn.referencedColumnName());
            this.applyColumnCheckConstraint(joinColumn);
            this.setOptions(joinColumn.options());
            String table = joinColumn.table();
            if (table.isEmpty()) {
                this.setExplicitTableName("");
            } else {
                Database database = this.getBuildingContext().getMetadataCollector().getDatabase();
                Identifier logicalIdentifier = database.toIdentifier(table);
                Identifier physicalIdentifier = this.getBuildingContext().getBuildingOptions().getPhysicalNamingStrategy().toPhysicalTableName(logicalIdentifier, database.getJdbcEnvironment());
                this.setExplicitTableName(physicalIdentifier.render(database.getDialect()));
            }
        }
    }

    public static AnnotatedJoinColumn buildInheritanceJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn, JoinColumn joinColumn, Value identifier, AnnotatedJoinColumns parent, MetadataBuildingContext context) {
        String defaultColumnName = context.getMetadataCollector().getLogicalColumnName(identifier.getTable(), identifier.getColumns().get(0).getQuotedName());
        return primaryKeyJoinColumn != null || joinColumn != null ? AnnotatedJoinColumn.buildExplicitInheritanceJoinColumn(primaryKeyJoinColumn, joinColumn, parent, context, defaultColumnName) : AnnotatedJoinColumn.buildImplicitInheritanceJoinColumn(parent, context, defaultColumnName);
    }

    private static AnnotatedJoinColumn buildExplicitInheritanceJoinColumn(PrimaryKeyJoinColumn primaryKeyJoinColumn, JoinColumn joinColumn, AnnotatedJoinColumns parent, MetadataBuildingContext context, String defaultColumnName) {
        String options;
        String referencedColumnName;
        String columnDefinition;
        String columnName;
        if (primaryKeyJoinColumn != null) {
            columnName = primaryKeyJoinColumn.name();
            columnDefinition = primaryKeyJoinColumn.columnDefinition();
            referencedColumnName = primaryKeyJoinColumn.referencedColumnName();
            options = primaryKeyJoinColumn.options();
        } else {
            columnName = joinColumn.name();
            columnDefinition = joinColumn.columnDefinition();
            referencedColumnName = joinColumn.referencedColumnName();
            options = joinColumn.options();
        }
        ObjectNameNormalizer normalizer = context.getObjectNameNormalizer();
        String columnDef = columnDefinition.isEmpty() ? null : normalizer.toDatabaseIdentifierText(columnDefinition);
        String logicalColumnName = columnName.isEmpty() ? normalizer.normalizeIdentifierQuotingAsString(defaultColumnName) : normalizer.normalizeIdentifierQuotingAsString(columnName);
        AnnotatedJoinColumn column = new AnnotatedJoinColumn();
        column.setSqlType(columnDef);
        column.setLogicalColumnName(logicalColumnName);
        column.setReferencedColumn(referencedColumnName);
        column.setOptions(options);
        column.setImplicit(false);
        column.setNullable(false);
        column.setParent(parent);
        column.bind();
        return column;
    }

    private static AnnotatedJoinColumn buildImplicitInheritanceJoinColumn(AnnotatedJoinColumns parent, MetadataBuildingContext context, String defaultColumnName) {
        AnnotatedJoinColumn column = new AnnotatedJoinColumn();
        ObjectNameNormalizer normalizer = context.getObjectNameNormalizer();
        column.setLogicalColumnName(normalizer.normalizeIdentifierQuotingAsString(defaultColumnName));
        column.setImplicit(true);
        column.setNullable(false);
        column.setParent(parent);
        column.bind();
        return column;
    }

    public static void checkIfJoinColumn(Object columns, PropertyHolder holder, PropertyData property) {
        if (!(columns instanceof AnnotatedJoinColumn[])) {
            throw new AnnotationException("Property '" + BinderHelper.getRelativePath(holder, property.getPropertyName()) + "' is an association and may not use '@Column' to specify column mappings (use '@JoinColumn' instead)");
        }
    }

    public void copyReferencedStructureAndCreateDefaultJoinColumns(PersistentClass referencedEntity, SimpleValue referencedValue, SimpleValue value) {
        if (!this.isNameDeferred()) {
            throw new AssertionFailure("Building implicit column but the column is not implicit");
        }
        for (Column synthCol : referencedValue.getColumns()) {
            this.linkValueUsingDefaultColumnNaming(synthCol, referencedEntity, value);
        }
        this.setMappingColumn(null);
    }

    public void linkValueUsingDefaultColumnNaming(Column referencedColumn, PersistentClass referencedEntity, SimpleValue value) {
        int columnIndex = this.getParent().getJoinColumns().indexOf(this);
        this.linkValueUsingDefaultColumnNaming(columnIndex, referencedColumn, referencedEntity, value);
    }

    public void linkValueUsingDefaultColumnNaming(int columnIndex, Column referencedColumn, PersistentClass referencedEntity, SimpleValue value) {
        String logicalReferencedColumn = this.getBuildingContext().getMetadataCollector().getLogicalColumnName(referencedEntity.getTable(), referencedColumn.getQuotedName());
        String columnName = this.defaultColumnName(columnIndex, referencedEntity, logicalReferencedColumn);
        this.setLogicalColumnName(columnName);
        this.setImplicit(true);
        this.setReferencedColumn(logicalReferencedColumn);
        Column mappingColumn = this.getMappingColumn();
        this.initMappingColumn(columnName, null, referencedColumn.getLength(), referencedColumn.getPrecision(), referencedColumn.getScale(), referencedColumn.getTemporalPrecision(), referencedColumn.getArrayLength(), mappingColumn != null && mappingColumn.isNullable(), referencedColumn.getSqlType(), mappingColumn != null && mappingColumn.isUnique(), false);
        this.linkWithValue(value);
    }

    private String defaultColumnName(int columnIndex, PersistentClass referencedEntity, String logicalReferencedColumn) {
        Column column;
        AnnotatedJoinColumns parent = this.getParent();
        if (parent.hasMapsId() && (column = parent.resolveMapsId().getValue().getColumns().get(columnIndex)).isExplicit()) {
            throw new AnnotationException("Association '" + parent.getPropertyName() + "' in entity '" + parent.getPropertyHolder().getEntityName() + "' is annotated '@MapsId' but refers to a property '" + parent.getMapsId() + "' which has an explicit column mapping");
        }
        return parent.buildDefaultColumnName(referencedEntity, logicalReferencedColumn);
    }

    public void addDefaultJoinColumnName(PersistentClass referencedEntity, String logicalReferencedColumn) {
        String columnName = this.getParent().buildDefaultColumnName(referencedEntity, logicalReferencedColumn);
        this.getMappingColumn().setName(columnName);
        this.setLogicalColumnName(columnName);
    }

    public void linkValueUsingAColumnCopy(Column column, SimpleValue value) {
        this.initMappingColumn(column.getQuotedName(), null, column.getLength(), column.getPrecision(), column.getScale(), column.getTemporalPrecision(), column.getArrayLength(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique(), false);
        this.linkWithValue(value);
    }

    @Override
    protected void addColumnBinding(SimpleValue value) {
        if (!this.getParent().hasMappedBy()) {
            boolean isLogicalColumnQuoted = StringHelper.isQuoted(this.getLogicalColumnName());
            ObjectNameNormalizer normalizer = this.getBuildingContext().getObjectNameNormalizer();
            String logicalColumnName = normalizer.normalizeIdentifierQuotingAsString(this.getLogicalColumnName());
            String referencedColumn = normalizer.normalizeIdentifierQuotingAsString(this.getReferencedColumn());
            String unquotedLogColName = StringHelper.unquote(logicalColumnName);
            String unquotedRefColumn = StringHelper.unquote(referencedColumn);
            String collectionColName = StringHelper.isNotEmpty(unquotedLogColName) ? unquotedLogColName : this.getParent().getPropertyName() + "_" + unquotedRefColumn;
            InFlightMetadataCollector collector = this.getBuildingContext().getMetadataCollector();
            String logicalCollectionColumnName = collector.getDatabase().getJdbcEnvironment().getIdentifierHelper().toIdentifier(collectionColName, isLogicalColumnQuoted).render();
            collector.addColumnNameBinding(value.getTable(), logicalCollectionColumnName, this.getMappingColumn());
        }
    }

    public void overrideFromReferencedColumnIfNecessary(Column column) {
        Column mappingColumn = this.getMappingColumn();
        if (mappingColumn != null) {
            if (StringHelper.isEmpty(this.sqlType)) {
                this.sqlType = column.getSqlType();
                mappingColumn.setSqlType(this.sqlType);
            }
            mappingColumn.setLength(column.getLength());
            mappingColumn.setPrecision(column.getPrecision());
            mappingColumn.setScale(column.getScale());
            mappingColumn.setArrayLength(column.getArrayLength());
        }
    }

    @Override
    public void redefineColumnName(String columnName, String propertyName, boolean applyNamingStrategy) {
        super.redefineColumnName(columnName, null, applyNamingStrategy);
    }

    static AnnotatedJoinColumn buildImplicitJoinTableJoinColumn(AnnotatedJoinColumns parent, PropertyHolder propertyHolder, PropertyData inferredData) {
        AnnotatedJoinColumn column = new AnnotatedJoinColumn();
        column.setImplicit(true);
        column.setParent(parent);
        column.bind();
        column.setNullable(false);
        return column;
    }

    static AnnotatedJoinColumn buildExplicitJoinTableJoinColumn(AnnotatedJoinColumns parent, PropertyHolder propertyHolder, PropertyData inferredData, JoinColumn joinColumn) {
        AnnotatedJoinColumn column = new AnnotatedJoinColumn();
        column.setImplicit(true);
        column.setParent(parent);
        column.applyJoinAnnotation(joinColumn, inferredData.getPropertyName());
        column.bind();
        column.setNullable(false);
        return column;
    }

    @Override
    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName()).append("(");
        if (StringHelper.isNotEmpty(this.getLogicalColumnName())) {
            string.append("column='").append(this.getLogicalColumnName()).append("',");
        }
        if (StringHelper.isNotEmpty(this.referencedColumn)) {
            string.append("referencedColumn='").append(this.referencedColumn).append("',");
        }
        if (string.charAt(string.length() - 1) == ',') {
            string.setLength(string.length() - 1);
        }
        string.append(")");
        return string.toString();
    }

    @Override
    public AnnotatedJoinColumns getParent() {
        return (AnnotatedJoinColumns)super.getParent();
    }

    @Override
    public void setParent(AnnotatedColumns parent) {
        if (!(parent instanceof AnnotatedJoinColumns)) {
            throw new UnsupportedOperationException("wrong kind of parent");
        }
        super.setParent(parent);
    }

    public void setParent(AnnotatedJoinColumns parent) {
        super.setParent(parent);
    }

    private void applyColumnCheckConstraint(JoinColumn column) {
        this.applyCheckConstraints(column.check());
    }
}

