/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.JoinColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.JoinColumnOrFormula;
import org.hibernate.annotations.JoinFormula;
import org.hibernate.annotations.PropertyRef;
import org.hibernate.boot.internal.FailedSecondPassException;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedJoinColumn;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.ForeignKeyType;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitJoinColumnNameSource;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.boot.model.naming.ImplicitPrimaryKeyJoinColumnNameSource;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.AttributeContainer;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.MemberDetails;

public class AnnotatedJoinColumns
extends AnnotatedColumns {
    private final List<AnnotatedJoinColumn> columns = new ArrayList<AnnotatedJoinColumn>();
    private String referencedProperty;
    private String mappedBy;
    private String mapsId;
    private String mappedByPropertyName;
    private String mappedByTableName;
    private String mappedByEntityName;
    private boolean elementCollection;
    private String manyToManyOwnerSideEntityName;

    public static AnnotatedJoinColumns buildJoinColumnsOrFormulas(JoinColumnOrFormula[] joinColumnOrFormulas, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext context) {
        AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
        parent.setBuildingContext(context);
        parent.setJoins(joins);
        parent.setPropertyHolder(propertyHolder);
        parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
        parent.setMappedBy(mappedBy);
        for (JoinColumnOrFormula columnOrFormula : joinColumnOrFormulas) {
            JoinFormula formula = columnOrFormula.formula();
            JoinColumn column = columnOrFormula.column();
            String annotationString = formula.value();
            if (StringHelper.isNotEmpty(annotationString)) {
                AnnotatedJoinColumn.buildJoinFormula(formula, parent);
                continue;
            }
            AnnotatedJoinColumn.buildJoinColumn(column, mappedBy, parent, propertyHolder, inferredData);
        }
        AnnotatedJoinColumns.handlePropertyRef(inferredData.getAttributeMember(), parent);
        return parent;
    }

    private static void handlePropertyRef(MemberDetails attributeMember, AnnotatedJoinColumns parent) {
        PropertyRef propertyRefUsage = (PropertyRef)attributeMember.getDirectAnnotationUsage(PropertyRef.class);
        if (propertyRefUsage == null) {
            return;
        }
        String referencedPropertyName = propertyRefUsage.value();
        if (StringHelper.isEmpty(referencedPropertyName)) {
            throw new AnnotationException("@PropertyRef did not specify target attribute name : " + attributeMember);
        }
        parent.referencedProperty = referencedPropertyName;
    }

    static AnnotatedJoinColumns buildJoinColumnsWithFormula(JoinFormula joinFormula, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext context) {
        AnnotatedJoinColumns joinColumns = new AnnotatedJoinColumns();
        joinColumns.setBuildingContext(context);
        joinColumns.setJoins(secondaryTables);
        joinColumns.setPropertyHolder(propertyHolder);
        joinColumns.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
        AnnotatedJoinColumn.buildJoinFormula(joinFormula, joinColumns);
        AnnotatedJoinColumns.handlePropertyRef(inferredData.getAttributeMember(), joinColumns);
        return joinColumns;
    }

    public static AnnotatedJoinColumns buildJoinColumns(JoinColumn[] joinColumns, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, PropertyData inferredData, MetadataBuildingContext buildingContext) {
        return AnnotatedJoinColumns.buildJoinColumnsWithDefaultColumnSuffix(joinColumns, mappedBy, joins, propertyHolder, inferredData, "", buildingContext);
    }

    public static AnnotatedJoinColumns buildJoinColumnsWithDefaultColumnSuffix(JoinColumn[] joinColumns, String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, PropertyData inferredData, String defaultColumnSuffix, MetadataBuildingContext context) {
        assert (mappedBy == null || !mappedBy.isEmpty());
        String propertyName = inferredData.getPropertyName();
        String path = StringHelper.qualify(propertyHolder.getPath(), propertyName);
        JoinColumn[] overrides = propertyHolder.getOverriddenJoinColumn(path);
        Object[] actualColumns = overrides == null ? joinColumns : overrides;
        AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
        parent.setBuildingContext(context);
        parent.setJoins(joins);
        parent.setPropertyHolder(propertyHolder);
        parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        parent.setMappedBy(mappedBy);
        MemberDetails memberDetails = inferredData.getAttributeMember();
        if (ArrayHelper.isEmpty(actualColumns)) {
            AnnotatedJoinColumn.buildJoinColumn(null, mappedBy, parent, propertyHolder, inferredData, defaultColumnSuffix);
        } else {
            parent.setMappedBy(mappedBy);
            for (Object actualColumn : actualColumns) {
                AnnotatedJoinColumn.buildJoinColumn((JoinColumn)actualColumn, mappedBy, parent, propertyHolder, inferredData, defaultColumnSuffix);
            }
        }
        AnnotatedJoinColumns.handlePropertyRef(memberDetails, parent);
        return parent;
    }

    public static AnnotatedJoinColumns buildJoinTableJoinColumns(JoinColumn[] joinColumns, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, MetadataBuildingContext context) {
        AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
        parent.setBuildingContext(context);
        parent.setJoins(secondaryTables);
        parent.setPropertyHolder(propertyHolder);
        parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, inferredData.getPropertyName()));
        parent.setMappedBy(mappedBy);
        if (joinColumns == null) {
            AnnotatedJoinColumn.buildImplicitJoinTableJoinColumn(parent, propertyHolder, inferredData);
        } else {
            for (JoinColumn joinColumn : joinColumns) {
                AnnotatedJoinColumn.buildExplicitJoinTableJoinColumn(parent, propertyHolder, inferredData, joinColumn);
            }
        }
        AnnotatedJoinColumns.handlePropertyRef(inferredData.getAttributeMember(), parent);
        return parent;
    }

    Property resolveMapsId() {
        PersistentClass persistentClass = this.getPropertyHolder().getPersistentClass();
        KeyValue identifier = persistentClass.getIdentifier();
        try {
            if (identifier instanceof Component) {
                Component embeddedIdType = (Component)identifier;
                return embeddedIdType.getProperty(this.getMapsId());
            }
            return persistentClass.getProperty(this.getMapsId());
        }
        catch (MappingException me) {
            throw new AnnotationException("Identifier field '" + this.getMapsId() + "' named in '@MapsId' does not exist in entity '" + persistentClass.getEntityName() + "'", (Throwable)((Object)me));
        }
    }

    public List<AnnotatedJoinColumn> getJoinColumns() {
        return this.columns;
    }

    @Override
    public void addColumn(AnnotatedColumn child) {
        if (!(child instanceof AnnotatedJoinColumn)) {
            throw new AssertionFailure("wrong sort of column");
        }
        this.addColumn((AnnotatedJoinColumn)child);
    }

    public void addColumn(AnnotatedJoinColumn child) {
        super.addColumn(child);
        this.columns.add(child);
    }

    public String getReferencedProperty() {
        return this.referencedProperty;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = StringHelper.nullIfEmpty(mappedBy);
    }

    public boolean hasMappedBy() {
        return this.mappedBy != null;
    }

    public String getMappedByEntityName() {
        return this.mappedByEntityName;
    }

    public String getMappedByPropertyName() {
        return this.mappedByPropertyName;
    }

    public String getMappedByTableName() {
        return this.mappedByTableName;
    }

    public boolean isElementCollection() {
        return this.elementCollection;
    }

    public void setElementCollection(boolean elementCollection) {
        this.elementCollection = elementCollection;
    }

    public void setManyToManyOwnerSideEntityName(String entityName) {
        this.manyToManyOwnerSideEntityName = entityName;
    }

    public String getManyToManyOwnerSideEntityName() {
        return this.manyToManyOwnerSideEntityName;
    }

    public void setMappedBy(String entityName, String logicalTableName, String mappedByProperty) {
        this.mappedByEntityName = entityName;
        this.mappedByTableName = logicalTableName;
        this.mappedByPropertyName = mappedByProperty;
    }

    public ForeignKeyType getReferencedColumnsType(PersistentClass referencedEntity) {
        if (this.referencedProperty != null) {
            return ForeignKeyType.NON_PRIMARY_KEY_REFERENCE;
        }
        if (this.columns.isEmpty()) {
            return ForeignKeyType.IMPLICIT_PRIMARY_KEY_REFERENCE;
        }
        AnnotatedJoinColumn firstColumn = this.columns.get(0);
        AttributeContainer columnOwner = BinderHelper.findReferencedColumnOwner(referencedEntity, firstColumn, this.getBuildingContext());
        if (columnOwner == null) {
            try {
                throw new MappingException("A '@JoinColumn' references a column named '" + firstColumn.getReferencedColumn() + "' but the target entity '" + referencedEntity.getEntityName() + "' has no property which maps to this column");
            }
            catch (MappingException me) {
                throw new FailedSecondPassException(me.getMessage(), (Throwable)((Object)me));
            }
        }
        Table table = AnnotatedJoinColumns.table(columnOwner);
        List<Selectable> keyColumns = table.getPrimaryKey() == null ? referencedEntity.getKey().getSelectables() : table.getPrimaryKey().getColumns();
        boolean explicitColumnReference = false;
        for (AnnotatedJoinColumn column : this.columns) {
            if (column.isReferenceImplicit()) continue;
            explicitColumnReference = true;
            if (keyColumns.contains(AnnotatedJoinColumns.column(this.getBuildingContext(), table, column.getReferencedColumn()))) continue;
            return ForeignKeyType.NON_PRIMARY_KEY_REFERENCE;
        }
        if (explicitColumnReference) {
            return keyColumns.size() == this.columns.size() ? ForeignKeyType.EXPLICIT_PRIMARY_KEY_REFERENCE : ForeignKeyType.NON_PRIMARY_KEY_REFERENCE;
        }
        return ForeignKeyType.IMPLICIT_PRIMARY_KEY_REFERENCE;
    }

    private static Table table(Object persistentClassOrJoin) {
        return persistentClassOrJoin instanceof PersistentClass ? ((PersistentClass)persistentClassOrJoin).getTable() : ((Join)persistentClassOrJoin).getTable();
    }

    private static Column column(MetadataBuildingContext context, Table table, String logicalReferencedColumnName) {
        try {
            return new Column(context.getMetadataCollector().getPhysicalColumnName(table, logicalReferencedColumnName));
        }
        catch (MappingException me) {
            throw new MappingException("No column with logical name '" + logicalReferencedColumnName + "' in table '" + table.getName() + "'");
        }
    }

    String buildDefaultColumnName(PersistentClass referencedEntity, String logicalReferencedColumn) {
        MetadataBuildingOptions options = this.getBuildingContext().getBuildingOptions();
        InFlightMetadataCollector collector = this.getBuildingContext().getMetadataCollector();
        Database database = collector.getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        Identifier columnIdentifier = this.columnIdentifier(referencedEntity, logicalReferencedColumn, options.getImplicitNamingStrategy(), collector, database);
        return options.getPhysicalNamingStrategy().toPhysicalColumnName(columnIdentifier, jdbcEnvironment).render(jdbcEnvironment.getDialect());
    }

    private Identifier columnIdentifier(PersistentClass referencedEntity, final String logicalReferencedColumn, ImplicitNamingStrategy implicitNamingStrategy, InFlightMetadataCollector collector, final Database database) {
        boolean isRefColumnQuoted = StringHelper.isQuoted(logicalReferencedColumn);
        if (this.isMappedBySide()) {
            Identifier columnIdentifier = implicitNamingStrategy.determineJoinColumnName(new UnownedImplicitJoinColumnNameSource(referencedEntity, logicalReferencedColumn));
            return AnnotatedJoinColumns.quoteIfNecessary(isRefColumnQuoted, this.getMappedByTableName(), columnIdentifier);
        }
        if (this.isOwnerSide()) {
            String logicalTableName = collector.getLogicalTableName(referencedEntity.getTable());
            Identifier columnIdentifier = implicitNamingStrategy.determineJoinColumnName(new OwnedImplicitJoinColumnNameSource(referencedEntity, logicalTableName, logicalReferencedColumn));
            if (columnIdentifier.getText().contains("_{element}_")) {
                columnIdentifier = Identifier.toIdentifier(columnIdentifier.getText().replace("_{element}_", "_"), columnIdentifier.isQuoted());
            }
            return AnnotatedJoinColumns.quoteIfNecessary(isRefColumnQuoted, logicalTableName, columnIdentifier);
        }
        final Identifier logicalTableName = database.toIdentifier(collector.getLogicalTableName(referencedEntity.getTable()));
        Identifier columnIdentifier = implicitNamingStrategy.determinePrimaryKeyJoinColumnName(new ImplicitPrimaryKeyJoinColumnNameSource(){

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return AnnotatedJoinColumns.this.getBuildingContext();
            }

            @Override
            public Identifier getReferencedTableName() {
                return logicalTableName;
            }

            @Override
            public Identifier getReferencedPrimaryKeyColumnName() {
                return database.toIdentifier(logicalReferencedColumn);
            }
        });
        return AnnotatedJoinColumns.quoteIfNecessary(isRefColumnQuoted, logicalTableName, columnIdentifier);
    }

    private static Identifier quoteIfNecessary(boolean isRefColumnQuoted, Identifier logicalTableName, Identifier columnIdentifier) {
        return !columnIdentifier.isQuoted() && (isRefColumnQuoted || logicalTableName.isQuoted()) ? Identifier.quote(columnIdentifier) : columnIdentifier;
    }

    private static Identifier quoteIfNecessary(boolean isRefColumnQuoted, String logicalTableName, Identifier columnIdentifier) {
        return isRefColumnQuoted || StringHelper.isQuoted(logicalTableName) ? Identifier.quote(columnIdentifier) : columnIdentifier;
    }

    private boolean isOwnerSide() {
        return this.getPropertyName() != null;
    }

    private boolean isMappedBySide() {
        return this.getMappedByTableName() != null || this.getMappedByPropertyName() != null;
    }

    private ImplicitJoinColumnNameSource.Nature getImplicitNature() {
        if (this.getPropertyHolder().isEntity()) {
            return ImplicitJoinColumnNameSource.Nature.ENTITY;
        }
        if (this.isElementCollection()) {
            return ImplicitJoinColumnNameSource.Nature.ELEMENT_COLLECTION;
        }
        return ImplicitJoinColumnNameSource.Nature.ENTITY_COLLECTION;
    }

    public boolean hasMapsId() {
        return this.mapsId != null;
    }

    public String getMapsId() {
        return this.mapsId;
    }

    public void setMapsId(String mapsId) {
        this.mapsId = StringHelper.nullIfEmpty(mapsId);
    }

    private class UnownedImplicitJoinColumnNameSource
    implements ImplicitJoinColumnNameSource {
        final AttributePath attributePath;
        final ImplicitJoinColumnNameSource.Nature implicitNamingNature;
        private final EntityNaming entityNaming;
        private final Identifier referencedTableName;
        private final String logicalReferencedColumn;
        final InFlightMetadataCollector collector = this.getBuildingContext().getMetadataCollector();
        final Database database = this.collector.getDatabase();

        public UnownedImplicitJoinColumnNameSource(final PersistentClass referencedEntity, String logicalReferencedColumn) {
            this.logicalReferencedColumn = logicalReferencedColumn;
            this.attributePath = AttributePath.parse(AnnotatedJoinColumns.this.getMappedByPropertyName());
            this.implicitNamingNature = AnnotatedJoinColumns.this.getImplicitNature();
            this.entityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return referencedEntity.getClassName();
                }

                @Override
                public String getEntityName() {
                    return referencedEntity.getEntityName();
                }

                @Override
                public String getJpaEntityName() {
                    return referencedEntity.getJpaEntityName();
                }
            };
            this.referencedTableName = this.database.toIdentifier(AnnotatedJoinColumns.this.getMappedByTableName());
        }

        @Override
        public ImplicitJoinColumnNameSource.Nature getNature() {
            return this.implicitNamingNature;
        }

        @Override
        public EntityNaming getEntityNaming() {
            return this.entityNaming;
        }

        @Override
        public AttributePath getAttributePath() {
            return this.attributePath;
        }

        @Override
        public Identifier getReferencedTableName() {
            return this.referencedTableName;
        }

        @Override
        public Identifier getReferencedColumnName() {
            if (this.logicalReferencedColumn != null) {
                return this.database.toIdentifier(this.logicalReferencedColumn);
            }
            if (AnnotatedJoinColumns.this.getMappedByEntityName() == null || AnnotatedJoinColumns.this.getMappedByPropertyName() == null) {
                return null;
            }
            Property mappedByProperty = this.collector.getEntityBinding(AnnotatedJoinColumns.this.getMappedByEntityName()).getProperty(AnnotatedJoinColumns.this.getMappedByPropertyName());
            SimpleValue value = (SimpleValue)mappedByProperty.getValue();
            if (value.getSelectables().isEmpty()) {
                throw new AnnotationException(String.format(Locale.ENGLISH, "Association '%s' is 'mappedBy' a property '%s' of entity '%s' with no columns", AnnotatedJoinColumns.this.getPropertyHolder().getPath(), AnnotatedJoinColumns.this.getMappedByPropertyName(), AnnotatedJoinColumns.this.getMappedByEntityName()));
            }
            Selectable selectable = value.getSelectables().get(0);
            if (!(selectable instanceof Column)) {
                throw new AnnotationException(String.format(Locale.ENGLISH, "Association '%s' is 'mappedBy' a property '%s' of entity '%s' which maps to a formula", AnnotatedJoinColumns.this.getPropertyHolder().getPath(), AnnotatedJoinColumns.this.getMappedByPropertyName(), AnnotatedJoinColumns.this.getPropertyHolder().getPath()));
            }
            if (value.getSelectables().size() > 1) {
                throw new AnnotationException(String.format(Locale.ENGLISH, "Association '%s' is 'mappedBy' a property '%s' of entity '%s' with multiple columns", AnnotatedJoinColumns.this.getPropertyHolder().getPath(), AnnotatedJoinColumns.this.getMappedByPropertyName(), AnnotatedJoinColumns.this.getPropertyHolder().getPath()));
            }
            Column column = (Column)selectable;
            return column.getNameIdentifier(this.getBuildingContext());
        }

        @Override
        public MetadataBuildingContext getBuildingContext() {
            return AnnotatedJoinColumns.this.getBuildingContext();
        }
    }

    private class OwnedImplicitJoinColumnNameSource
    implements ImplicitJoinColumnNameSource {
        final ImplicitJoinColumnNameSource.Nature implicitNamingNature;
        private final EntityNaming entityNaming;
        private final AttributePath attributePath;
        private final Identifier referencedTableName;
        private final Identifier referencedColumnName;
        final InFlightMetadataCollector collector = this.getBuildingContext().getMetadataCollector();
        final Database database = this.collector.getDatabase();

        public OwnedImplicitJoinColumnNameSource(final PersistentClass referencedEntity, String logicalTableName, String logicalReferencedColumn) {
            this.implicitNamingNature = AnnotatedJoinColumns.this.getImplicitNature();
            this.entityNaming = new EntityNaming(){

                @Override
                public String getClassName() {
                    return referencedEntity.getClassName();
                }

                @Override
                public String getEntityName() {
                    return referencedEntity.getEntityName();
                }

                @Override
                public String getJpaEntityName() {
                    return referencedEntity.getJpaEntityName();
                }
            };
            this.attributePath = AttributePath.parse(AnnotatedJoinColumns.this.getPropertyName());
            this.referencedTableName = this.database.toIdentifier(logicalTableName);
            this.referencedColumnName = this.database.toIdentifier(logicalReferencedColumn);
        }

        @Override
        public ImplicitJoinColumnNameSource.Nature getNature() {
            return this.implicitNamingNature;
        }

        @Override
        public EntityNaming getEntityNaming() {
            return this.entityNaming;
        }

        @Override
        public AttributePath getAttributePath() {
            return this.attributePath;
        }

        @Override
        public Identifier getReferencedTableName() {
            return this.referencedTableName;
        }

        @Override
        public Identifier getReferencedColumnName() {
            return this.referencedColumnName;
        }

        @Override
        public MetadataBuildingContext getBuildingContext() {
            return AnnotatedJoinColumns.this.getBuildingContext();
        }
    }
}

