/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.annotations.DialectOverride;
import org.hibernate.boot.models.annotations.spi.DialectOverrider;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class DialectOverridesAnnotationHelper {
    private static final Map<Class<? extends Annotation>, Class<? extends Annotation>> OVERRIDE_MAP = DialectOverridesAnnotationHelper.buildOverrideMap();

    private static Map<Class<? extends Annotation>, Class<? extends Annotation>> buildOverrideMap() {
        Class<?>[] dialectOverrideMembers;
        HashMap<Class<? extends Annotation>, Class<? extends Annotation>> results = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>();
        for (Class<?> dialectOverrideMember : dialectOverrideMembers = DialectOverride.class.getNestMembers()) {
            DialectOverride.OverridesAnnotation overrideAnnotation;
            if (!dialectOverrideMember.isAnnotation() || (overrideAnnotation = dialectOverrideMember.getAnnotation(DialectOverride.OverridesAnnotation.class)) == null) continue;
            Class<? extends Annotation> baseAnnotation = overrideAnnotation.value();
            Class<?> dialectOverrideAnnotation = dialectOverrideMember;
            results.put(baseAnnotation, dialectOverrideAnnotation);
        }
        return results;
    }

    public static <A extends Annotation, O extends Annotation> Class<O> getOverrideAnnotation(Class<A> annotationType) {
        Class<O> overrideAnnotation = DialectOverridesAnnotationHelper.findOverrideAnnotation(annotationType);
        if (overrideAnnotation != null) {
            return overrideAnnotation;
        }
        throw new HibernateException(String.format(Locale.ROOT, "Specified Annotation type (%s) does not have an override form", annotationType.getName()));
    }

    public static <A extends Annotation, O extends Annotation> Class<O> findOverrideAnnotation(Class<A> annotationType) {
        return OVERRIDE_MAP.get(annotationType);
    }

    public static <T extends Annotation> T getOverridableAnnotation(AnnotationTarget element, Class<T> annotationType, MetadataBuildingContext context) {
        SourceModelBuildingContext sourceModelContext = context.getMetadataCollector().getSourceModelBuildingContext();
        Class<? extends Annotation> overrideAnnotation = OVERRIDE_MAP.get(annotationType);
        if (overrideAnnotation != null) {
            Dialect dialect = context.getMetadataCollector().getDatabase().getDialect();
            Object[] overrides = element.getRepeatedAnnotationUsages(overrideAnnotation, sourceModelContext);
            if (CollectionHelper.isNotEmpty(overrides)) {
                for (int i = 0; i < overrides.length; ++i) {
                    DialectOverrider override = (DialectOverrider)overrides[i];
                    if (!override.matches(dialect)) continue;
                    return (T)override.override();
                }
            }
        }
        return (T)element.getAnnotationUsage(annotationType, sourceModelContext);
    }

    public static boolean overrideMatchesDialect(DialectOverrider<?> override, Dialect dialect) {
        return override.matches(dialect);
    }
}

