/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GenerationType;
import java.util.UUID;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.generator.Generator;
import org.hibernate.id.Assigned;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.SelectGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.id.enhanced.TableGenerator;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.models.spi.TypeDetails;

public class GeneratorStrategies {
    public static String generatorStrategy(GenerationType generationType, String name, TypeDetails type) {
        switch (generationType) {
            case IDENTITY: {
                return "identity";
            }
            case SEQUENCE: {
                return SequenceStyleGenerator.class.getName();
            }
            case TABLE: {
                return TableGenerator.class.getName();
            }
            case UUID: {
                return UUIDGenerator.class.getName();
            }
            case AUTO: {
                if (UUID.class.isAssignableFrom(type.determineRawClass().toJavaClass())) {
                    return UUIDGenerator.class.getName();
                }
                if ("increment".equalsIgnoreCase(name)) {
                    return IncrementGenerator.class.getName();
                }
                return SequenceStyleGenerator.class.getName();
            }
        }
        throw new IllegalArgumentException("Unsupported generation type:" + generationType);
    }

    public static Class<? extends Generator> generatorClass(String strategy, SimpleValue idValue) {
        if ("native".equals(strategy)) {
            strategy = idValue.getMetadata().getDatabase().getDialect().getNativeIdentifierGeneratorStrategy();
        }
        switch (strategy) {
            case "assigned": {
                return Assigned.class;
            }
            case "enhanced-sequence": 
            case "sequence": {
                return SequenceStyleGenerator.class;
            }
            case "enhanced-table": 
            case "table": {
                return TableGenerator.class;
            }
            case "identity": {
                return IdentityGenerator.class;
            }
            case "increment": {
                return IncrementGenerator.class;
            }
            case "foreign": {
                return ForeignGenerator.class;
            }
            case "uuid": 
            case "uuid.hex": {
                return UUIDHexGenerator.class;
            }
            case "uuid2": {
                return UUIDGenerator.class;
            }
            case "select": {
                return SelectGenerator.class;
            }
            case "guid": {
                return GUIDGenerator.class;
            }
        }
        Class clazz = idValue.getServiceRegistry().requireService(ClassLoaderService.class).classForName(strategy);
        if (!Generator.class.isAssignableFrom(clazz)) {
            throw new MappingException(clazz.getName() + " does not implement 'Generator'");
        }
        return clazz;
    }

    public static Class<? extends Generator> mapLegacyNamedGenerator(String strategy, Dialect dialect) {
        if ("native".equals(strategy)) {
            strategy = dialect.getNativeIdentifierGeneratorStrategy();
        }
        switch (strategy) {
            case "assigned": {
                return Assigned.class;
            }
            case "enhanced-sequence": 
            case "sequence": {
                return SequenceStyleGenerator.class;
            }
            case "enhanced-table": 
            case "table": {
                return TableGenerator.class;
            }
            case "identity": {
                return IdentityGenerator.class;
            }
            case "increment": {
                return IncrementGenerator.class;
            }
            case "foreign": {
                return ForeignGenerator.class;
            }
            case "uuid": 
            case "uuid.hex": {
                return UUIDHexGenerator.class;
            }
            case "uuid2": {
                return UUIDGenerator.class;
            }
            case "select": {
                return SelectGenerator.class;
            }
            case "guid": {
                return GUIDGenerator.class;
            }
        }
        return null;
    }

    public static Class<? extends Generator> mapLegacyNamedGenerator(String strategy, MetadataBuildingContext buildingContext) {
        return GeneratorStrategies.mapLegacyNamedGenerator(strategy, buildingContext.getMetadataCollector().getDatabase().getDialect());
    }

    public static Class<? extends Generator> mapLegacyNamedGenerator(String strategy, SimpleValue idValue) {
        return GeneratorStrategies.mapLegacyNamedGenerator(strategy, idValue.getMetadata().getDatabase().getDialect());
    }
}

