/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.Parameter;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.usertype.UserCollectionType;

public class CollectionTypeRegistrationAnnotation
implements CollectionTypeRegistration {
    private CollectionClassification classification;
    private Class<? extends UserCollectionType> type;
    private Parameter[] parameters;

    public CollectionTypeRegistrationAnnotation(SourceModelBuildingContext modelContext) {
        this.parameters = new Parameter[0];
    }

    public CollectionTypeRegistrationAnnotation(CollectionTypeRegistration annotation, SourceModelBuildingContext modelContext) {
        this.classification = annotation.classification();
        this.type = annotation.type();
        this.parameters = (Parameter[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.COLLECTION_TYPE_REGISTRATION, "parameters", modelContext);
    }

    public CollectionTypeRegistrationAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.classification = (CollectionClassification)((Object)attributeValues.get("classification"));
        this.type = (Class)attributeValues.get("type");
        this.parameters = (Parameter[])attributeValues.get("parameters");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return CollectionTypeRegistration.class;
    }

    @Override
    public CollectionClassification classification() {
        return this.classification;
    }

    public void classification(CollectionClassification value) {
        this.classification = value;
    }

    @Override
    public Class<? extends UserCollectionType> type() {
        return this.type;
    }

    public void type(Class<? extends UserCollectionType> value) {
        this.type = value;
    }

    @Override
    public Parameter[] parameters() {
        return this.parameters;
    }

    public void parameters(Parameter[] value) {
        this.parameters = value;
    }
}

