/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class ConstructorResultJpaAnnotation
implements ConstructorResult {
    private Class<?> targetClass;
    private ColumnResult[] columns;

    public ConstructorResultJpaAnnotation(SourceModelBuildingContext modelContext) {
    }

    public ConstructorResultJpaAnnotation(ConstructorResult annotation, SourceModelBuildingContext modelContext) {
        this.targetClass = annotation.targetClass();
        this.columns = (ColumnResult[])OrmAnnotationHelper.extractJdkValue(annotation, JpaAnnotations.CONSTRUCTOR_RESULT, "columns", modelContext);
    }

    public ConstructorResultJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.targetClass = (Class)attributeValues.get("targetClass");
        this.columns = (ColumnResult[])attributeValues.get("columns");
    }

    public Class<? extends Annotation> annotationType() {
        return ConstructorResult.class;
    }

    public Class<?> targetClass() {
        return this.targetClass;
    }

    public void targetClass(Class<?> value) {
        this.targetClass = value;
    }

    public ColumnResult[] columns() {
        return this.columns;
    }

    public void columns(ColumnResult[] value) {
        this.columns = value;
    }
}

