/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.OrderColumn;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOrderColumnImpl;
import org.hibernate.boot.models.annotations.spi.ColumnDetails;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class OrderColumnJpaAnnotation
implements OrderColumn,
ColumnDetails,
ColumnDetails.Definable,
ColumnDetails.Nullable,
ColumnDetails.Mutable {
    private String name;
    private boolean nullable;
    private boolean insertable;
    private boolean updatable;
    private String columnDefinition;
    private String options;

    public OrderColumnJpaAnnotation(SourceModelBuildingContext modelContext) {
        this.name = "";
        this.nullable = true;
        this.insertable = true;
        this.updatable = true;
        this.columnDefinition = "";
        this.options = "";
    }

    public OrderColumnJpaAnnotation(OrderColumn annotation, SourceModelBuildingContext modelContext) {
        this.name = annotation.name();
        this.nullable = annotation.nullable();
        this.insertable = annotation.insertable();
        this.updatable = annotation.updatable();
        this.columnDefinition = annotation.columnDefinition();
        this.options = annotation.options();
    }

    public OrderColumnJpaAnnotation(Map<String, Object> attributeValues, SourceModelBuildingContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.nullable = (Boolean)attributeValues.get("nullable");
        this.insertable = (Boolean)attributeValues.get("insertable");
        this.updatable = (Boolean)attributeValues.get("updatable");
        this.columnDefinition = (String)attributeValues.get("columnDefinition");
        this.options = (String)attributeValues.get("options");
    }

    public Class<? extends Annotation> annotationType() {
        return OrderColumn.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void name(String value) {
        this.name = value;
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public void nullable(boolean value) {
        this.nullable = value;
    }

    @Override
    public boolean insertable() {
        return this.insertable;
    }

    @Override
    public void insertable(boolean value) {
        this.insertable = value;
    }

    @Override
    public boolean updatable() {
        return this.updatable;
    }

    @Override
    public void updatable(boolean value) {
        this.updatable = value;
    }

    @Override
    public String columnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void columnDefinition(String value) {
        this.columnDefinition = value;
    }

    @Override
    public String options() {
        return this.options;
    }

    @Override
    public void options(String value) {
        this.options = value;
    }

    public void apply(JaxbOrderColumnImpl jaxbColumn, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbColumn.getName())) {
            this.name(jaxbColumn.getName());
        }
        if (jaxbColumn.isNullable() != null) {
            this.nullable(jaxbColumn.isNullable());
        }
        if (jaxbColumn.isInsertable() != null) {
            this.insertable(jaxbColumn.isInsertable());
        }
        if (jaxbColumn.isUpdatable() != null) {
            this.updatable(jaxbColumn.isUpdatable());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getColumnDefinition())) {
            this.columnDefinition(jaxbColumn.getColumnDefinition());
        }
        if (StringHelper.isNotEmpty(jaxbColumn.getOptions())) {
            this.options(jaxbColumn.getOptions());
        }
    }
}

