/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.models.categorize.internal.EntityHierarchyImpl;
import org.hibernate.boot.models.categorize.internal.HierarchyTypeConsumer;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;

public class EntityHierarchyBuilder {
    private final ModelCategorizationContext modelContext;

    public static Set<EntityHierarchy> createEntityHierarchies(Set<ClassDetails> rootEntities, HierarchyTypeConsumer typeConsumer, ModelCategorizationContext buildingContext) {
        return new EntityHierarchyBuilder(buildingContext).process(rootEntities, typeConsumer);
    }

    public static Set<EntityHierarchy> createEntityHierarchies(HierarchyTypeConsumer typeConsumer, ModelCategorizationContext buildingContext) {
        return EntityHierarchyBuilder.createEntityHierarchies(EntityHierarchyBuilder.collectRootEntityTypes(buildingContext.getClassDetailsRegistry()), typeConsumer, buildingContext);
    }

    public EntityHierarchyBuilder(ModelCategorizationContext modelContext) {
        this.modelContext = modelContext;
    }

    private Set<EntityHierarchy> process(Set<ClassDetails> rootEntities, HierarchyTypeConsumer typeConsumer) {
        HashSet<EntityHierarchy> hierarchies = CollectionHelper.setOfSize(rootEntities.size());
        rootEntities.forEach(rootEntity -> {
            AccessType defaultAccessType = this.determineDefaultAccessTypeForHierarchy((ClassDetails)rootEntity);
            hierarchies.add(new EntityHierarchyImpl((ClassDetails)rootEntity, defaultAccessType, org.hibernate.cache.spi.access.AccessType.TRANSACTIONAL, typeConsumer, this.modelContext));
        });
        return hierarchies;
    }

    private AccessType determineDefaultAccessTypeForHierarchy(ClassDetails rootEntityType) {
        assert (rootEntityType != null);
        AccessType accessFromAttribute = this.resolveDefaultAccessTypeFromMembers(rootEntityType);
        if (accessFromAttribute != null) {
            return accessFromAttribute;
        }
        return null;
    }

    private AccessType resolveDefaultAccessTypeFromClassAnnotation(ClassDetails rootEntityType) {
        for (ClassDetails current = rootEntityType; current != null; current = current.getSuperClass()) {
            Access accessAnnotation = (Access)current.getDirectAnnotationUsage(Access.class);
            if (accessAnnotation == null) continue;
            return accessAnnotation.value();
        }
        return null;
    }

    private AccessType resolveDefaultAccessTypeFromMembers(ClassDetails rootEntityType) {
        for (ClassDetails current = rootEntityType; current != null; current = current.getSuperClass()) {
            AnnotationTarget idMember = this.determineIdMember(current);
            if (idMember == null) continue;
            switch (idMember.getKind()) {
                case FIELD: {
                    return AccessType.FIELD;
                }
                case METHOD: {
                    return AccessType.PROPERTY;
                }
            }
            throw new IllegalStateException("@Id / @EmbeddedId found on target other than field or method : " + idMember);
        }
        return null;
    }

    private AnnotationTarget determineIdMember(ClassDetails current) {
        List methods = current.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            MethodDetails methodDetails = (MethodDetails)methods.get(i);
            if (!methodDetails.hasDirectAnnotationUsage(Id.class) && !methodDetails.hasDirectAnnotationUsage(EmbeddedId.class) || methodDetails.getDirectAnnotationUsage(Access.class) != null) continue;
            return methodDetails;
        }
        List fields = current.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = (FieldDetails)fields.get(i);
            if (!fieldDetails.hasDirectAnnotationUsage(Id.class) && !fieldDetails.hasDirectAnnotationUsage(EmbeddedId.class) || fieldDetails.getDirectAnnotationUsage(Access.class) != null) continue;
            return fieldDetails;
        }
        return null;
    }

    private Set<ClassDetails> collectRootEntityTypes() {
        return EntityHierarchyBuilder.collectRootEntityTypes(this.modelContext.getClassDetailsRegistry());
    }

    private static Set<ClassDetails> collectRootEntityTypes(ClassDetailsRegistry classDetailsRegistry) {
        HashSet<ClassDetails> collectedTypes = new HashSet<ClassDetails>();
        classDetailsRegistry.forEachClassDetails(managedType -> {
            if (managedType.getDirectAnnotationUsage(Entity.class) != null && EntityHierarchyBuilder.isRoot(managedType)) {
                collectedTypes.add(managedType);
            }
        });
        return collectedTypes;
    }

    public static boolean isRoot(ClassDetails classInfo) {
        if (classInfo.getSuperClass() == null) {
            return true;
        }
        for (ClassDetails current = classInfo.getSuperClass(); current != null; current = current.getSuperClass()) {
            if (current.getDirectAnnotationUsage(Entity.class) == null || current.isAbstract()) continue;
            return false;
        }
        return true;
    }

    public static Set<EntityHierarchy> createEntityHierarchies(ModelCategorizationContext processingContext) {
        return new EntityHierarchyBuilder(processingContext).process(EntityHierarchyBuilder.collectRootEntityTypes(processingContext.getClassDetailsRegistry()), EntityHierarchyBuilder::ignore);
    }

    private static void ignore(IdentifiableTypeMetadata it) {
    }
}

