/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.AccessType;
import java.util.List;
import org.hibernate.boot.models.categorize.internal.AbstractIdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.internal.HierarchyTypeConsumer;
import org.hibernate.boot.models.categorize.internal.LifecycleCallbackCollector;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.MappedSuperclassTypeMetadata;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.boot.models.spi.JpaEventListener;
import org.hibernate.models.spi.ClassDetails;

public class MappedSuperclassTypeMetadataImpl
extends AbstractIdentifiableTypeMetadata
implements MappedSuperclassTypeMetadata {
    private final List<AttributeMetadata> attributeList;
    private final List<JpaEventListener> hierarchyEventListeners;
    private final List<JpaEventListener> completeEventListeners;

    public MappedSuperclassTypeMetadataImpl(ClassDetails classDetails, EntityHierarchy hierarchy, MappedSuperclassTypeMetadataImpl superTypeMetadata, AccessType defaultAccessType, HierarchyTypeConsumer typeConsumer, ModelCategorizationContext modelContext) {
        super(classDetails, hierarchy, superTypeMetadata, defaultAccessType, modelContext);
        LifecycleCallbackCollector lifecycleCallbackCollector = new LifecycleCallbackCollector(classDetails, modelContext);
        this.attributeList = this.resolveAttributes(lifecycleCallbackCollector);
        this.hierarchyEventListeners = this.collectHierarchyEventListeners(lifecycleCallbackCollector.resolve());
        this.completeEventListeners = this.collectCompleteEventListeners(modelContext);
        if (superTypeMetadata != null) {
            superTypeMetadata.addSubclass(this);
        }
        this.postInstantiate(false, typeConsumer);
    }

    public MappedSuperclassTypeMetadataImpl(ClassDetails classDetails, EntityHierarchy hierarchy, AbstractIdentifiableTypeMetadata superType, HierarchyTypeConsumer typeConsumer, ModelCategorizationContext modelContext) {
        super(classDetails, hierarchy, superType, modelContext);
        LifecycleCallbackCollector lifecycleCallbackCollector = new LifecycleCallbackCollector(classDetails, modelContext);
        this.attributeList = this.resolveAttributes(lifecycleCallbackCollector);
        this.hierarchyEventListeners = this.collectHierarchyEventListeners(lifecycleCallbackCollector.resolve());
        this.completeEventListeners = this.collectCompleteEventListeners(modelContext);
        this.postInstantiate(true, typeConsumer);
    }

    @Override
    protected List<AttributeMetadata> attributeList() {
        return this.attributeList;
    }

    @Override
    public List<JpaEventListener> getHierarchyJpaEventListeners() {
        return this.hierarchyEventListeners;
    }

    @Override
    public List<JpaEventListener> getCompleteJpaEventListeners() {
        return this.completeEventListeners;
    }
}

