/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.internal;

import java.util.function.Supplier;
import org.hibernate.annotations.TenantId;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.models.internal.MutableClassDetailsRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.RegistryPrimer;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class ModelsHelper {
    public static void preFillRegistries(RegistryPrimer.Contributions contributions, SourceModelBuildingContext buildingContext) {
        OrmAnnotationHelper.forEachOrmAnnotation(arg_0 -> ((RegistryPrimer.Contributions)contributions).registerAnnotation(arg_0));
        buildingContext.getAnnotationDescriptorRegistry().getDescriptor(TenantId.class);
    }

    public static ClassDetails resolveClassDetails(String className, ClassDetailsRegistry classDetailsRegistry, Supplier<ClassDetails> classDetailsSupplier) {
        ClassDetails classDetails = classDetailsRegistry.findClassDetails(className);
        if (classDetails != null) {
            return classDetails;
        }
        classDetails = classDetailsSupplier.get();
        ((MutableClassDetailsRegistry)classDetailsRegistry.as(MutableClassDetailsRegistry.class)).addClassDetails(className, classDetails);
        return classDetails;
    }
}

