/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.spi;

import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.PostLoadJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PostPersistJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PostRemoveJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PostUpdateJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PrePersistJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PreRemoveJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.PreUpdateJpaAnnotation;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class JpaEventListener {
    private final JpaEventListenerStyle consumerType;
    private final ClassDetails listenerClass;
    private final MethodDetails prePersistMethod;
    private final MethodDetails postPersistMethod;
    private final MethodDetails preRemoveMethod;
    private final MethodDetails postRemoveMethod;
    private final MethodDetails preUpdateMethod;
    private final MethodDetails postUpdateMethod;
    private final MethodDetails postLoadMethod;

    public JpaEventListener(JpaEventListenerStyle consumerType, ClassDetails listenerClass, MethodDetails prePersistMethod, MethodDetails postPersistMethod, MethodDetails preRemoveMethod, MethodDetails postRemoveMethod, MethodDetails preUpdateMethod, MethodDetails postUpdateMethod, MethodDetails postLoadMethod) {
        this.consumerType = consumerType;
        this.listenerClass = listenerClass;
        this.prePersistMethod = prePersistMethod;
        this.postPersistMethod = postPersistMethod;
        this.preRemoveMethod = preRemoveMethod;
        this.postRemoveMethod = postRemoveMethod;
        this.preUpdateMethod = preUpdateMethod;
        this.postUpdateMethod = postUpdateMethod;
        this.postLoadMethod = postLoadMethod;
    }

    public JpaEventListenerStyle getStyle() {
        return this.consumerType;
    }

    public ClassDetails getCallbackClass() {
        return this.listenerClass;
    }

    public MethodDetails getPrePersistMethod() {
        return this.prePersistMethod;
    }

    public MethodDetails getPostPersistMethod() {
        return this.postPersistMethod;
    }

    public MethodDetails getPreRemoveMethod() {
        return this.preRemoveMethod;
    }

    public MethodDetails getPostRemoveMethod() {
        return this.postRemoveMethod;
    }

    public MethodDetails getPreUpdateMethod() {
        return this.preUpdateMethod;
    }

    public MethodDetails getPostUpdateMethod() {
        return this.postUpdateMethod;
    }

    public MethodDetails getPostLoadMethod() {
        return this.postLoadMethod;
    }

    public static JpaEventListener from(JpaEventListenerStyle consumerType, ClassDetails listenerClassDetails, JaxbEntityListenerImpl jaxbMapping, SourceModelBuildingContext modelsContext) {
        MutableObject prePersistMethod = new MutableObject();
        MutableObject postPersistMethod = new MutableObject();
        MutableObject preRemoveMethod = new MutableObject();
        MutableObject postRemoveMethod = new MutableObject();
        MutableObject preUpdateMethod = new MutableObject();
        MutableObject postUpdateMethod = new MutableObject();
        MutableObject postLoadMethod = new MutableObject();
        if (JpaEventListener.isImplicitMethodMappings(jaxbMapping)) {
            return JpaEventListener.from(consumerType, listenerClassDetails);
        }
        listenerClassDetails.forEachMethod((index, methodDetails) -> {
            MutableMemberDetails mutableMethodDetails = (MutableMemberDetails)methodDetails;
            if (jaxbMapping.getPrePersist() != null && methodDetails.getName().equals(jaxbMapping.getPrePersist().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                prePersistMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PrePersistJpaAnnotation)((Object)JpaAnnotations.PRE_PERSIST.createUsage(modelsContext)))));
            } else if (jaxbMapping.getPostPersist() != null && methodDetails.getName().equals(jaxbMapping.getPostPersist().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postPersistMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PostPersistJpaAnnotation)((Object)JpaAnnotations.POST_PERSIST.createUsage(modelsContext)))));
            } else if (jaxbMapping.getPreRemove() != null && methodDetails.getName().equals(jaxbMapping.getPreRemove().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                preRemoveMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PreRemoveJpaAnnotation)((Object)JpaAnnotations.PRE_REMOVE.createUsage(modelsContext)))));
            } else if (jaxbMapping.getPostRemove() != null && methodDetails.getName().equals(jaxbMapping.getPostRemove().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postRemoveMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PostRemoveJpaAnnotation)((Object)JpaAnnotations.POST_REMOVE.createUsage(modelsContext)))));
            } else if (jaxbMapping.getPreUpdate() != null && methodDetails.getName().equals(jaxbMapping.getPreUpdate().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                preUpdateMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PreUpdateJpaAnnotation)((Object)JpaAnnotations.PRE_UPDATE.createUsage(modelsContext)))));
            } else if (jaxbMapping.getPostUpdate() != null && methodDetails.getName().equals(jaxbMapping.getPostUpdate().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postUpdateMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PostUpdateJpaAnnotation)((Object)JpaAnnotations.POST_UPDATE.createUsage(modelsContext)))));
            } else if (jaxbMapping.getPostLoad() != null && methodDetails.getName().equals(jaxbMapping.getPostLoad().getMethodName()) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postLoadMethod.set(methodDetails);
                mutableMethodDetails.addAnnotationUsage((Annotation)((Object)((PostLoadJpaAnnotation)((Object)JpaAnnotations.POST_LOAD.createUsage(modelsContext)))));
            }
        });
        JpaEventListener jpaEventListener = new JpaEventListener(consumerType, listenerClassDetails, (MethodDetails)prePersistMethod.get(), (MethodDetails)postPersistMethod.get(), (MethodDetails)preRemoveMethod.get(), (MethodDetails)postRemoveMethod.get(), (MethodDetails)preUpdateMethod.get(), (MethodDetails)postUpdateMethod.get(), (MethodDetails)postLoadMethod.get());
        JpaEventListener.errorIfEmpty(jpaEventListener);
        return jpaEventListener;
    }

    private static boolean isImplicitMethodMappings(JaxbEntityListenerImpl jaxbMapping) {
        return jaxbMapping.getPrePersist() == null && jaxbMapping.getPreUpdate() == null && jaxbMapping.getPreRemove() == null && jaxbMapping.getPostLoad() == null && jaxbMapping.getPostPersist() == null && jaxbMapping.getPostUpdate() == null && jaxbMapping.getPostRemove() == null;
    }

    private static void errorIfEmpty(JpaEventListener jpaEventListener) {
        if (jpaEventListener.prePersistMethod == null && jpaEventListener.postPersistMethod == null && jpaEventListener.preRemoveMethod == null && jpaEventListener.postRemoveMethod == null && jpaEventListener.preUpdateMethod == null && jpaEventListener.postUpdateMethod == null && jpaEventListener.postLoadMethod == null) {
            throw new ModelsException("Mapping for entity-listener specified no callback methods - " + jpaEventListener.listenerClass.getClassName());
        }
    }

    public static JpaEventListener from(JpaEventListenerStyle consumerType, ClassDetails listenerClassDetails) {
        MutableObject prePersistMethod = new MutableObject();
        MutableObject postPersistMethod = new MutableObject();
        MutableObject preRemoveMethod = new MutableObject();
        MutableObject postRemoveMethod = new MutableObject();
        MutableObject preUpdateMethod = new MutableObject();
        MutableObject postUpdateMethod = new MutableObject();
        MutableObject postLoadMethod = new MutableObject();
        listenerClassDetails.forEachMethod((index, methodDetails) -> {
            if (methodDetails.hasDirectAnnotationUsage(PrePersist.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                prePersistMethod.set(methodDetails);
            } else if (methodDetails.hasDirectAnnotationUsage(PostPersist.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postPersistMethod.set(methodDetails);
            } else if (methodDetails.hasDirectAnnotationUsage(PreRemove.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                preRemoveMethod.set(methodDetails);
            } else if (methodDetails.hasDirectAnnotationUsage(PostRemove.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postRemoveMethod.set(methodDetails);
            } else if (methodDetails.hasDirectAnnotationUsage(PreUpdate.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                preUpdateMethod.set(methodDetails);
            } else if (methodDetails.hasDirectAnnotationUsage(PostUpdate.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postUpdateMethod.set(methodDetails);
            } else if (methodDetails.hasDirectAnnotationUsage(PostLoad.class) && JpaEventListener.matchesSignature(consumerType, methodDetails)) {
                postLoadMethod.set(methodDetails);
            }
        });
        JpaEventListener jpaEventListener = new JpaEventListener(consumerType, listenerClassDetails, (MethodDetails)prePersistMethod.get(), (MethodDetails)postPersistMethod.get(), (MethodDetails)preRemoveMethod.get(), (MethodDetails)postRemoveMethod.get(), (MethodDetails)preUpdateMethod.get(), (MethodDetails)postUpdateMethod.get(), (MethodDetails)postLoadMethod.get());
        JpaEventListener.errorIfEmpty(jpaEventListener);
        return jpaEventListener;
    }

    public static JpaEventListener tryAsCallback(ClassDetails classDetails) {
        try {
            return JpaEventListener.from(JpaEventListenerStyle.CALLBACK, classDetails);
        }
        catch (ModelsException e) {
            return null;
        }
    }

    public static boolean matchesSignature(JpaEventListenerStyle callbackType, MethodDetails methodDetails) {
        if (callbackType == JpaEventListenerStyle.CALLBACK) {
            return methodDetails.getArgumentTypes().isEmpty() && methodDetails.getReturnType() == ClassDetails.VOID_CLASS_DETAILS;
        }
        assert (callbackType == JpaEventListenerStyle.LISTENER);
        return methodDetails.getArgumentTypes().size() == 1 && methodDetails.getReturnType() == ClassDetails.VOID_CLASS_DETAILS;
    }
}

