/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.models.xml.internal.PersistenceUnitMetadataImpl;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.boot.models.xml.spi.XmlPreProcessingResult;
import org.hibernate.internal.util.StringHelper;

public class XmlPreProcessingResultImpl
implements XmlPreProcessingResult {
    private final PersistenceUnitMetadataImpl persistenceUnitMetadata;
    private final List<JaxbEntityMappingsImpl> documents = new ArrayList<JaxbEntityMappingsImpl>();
    private final List<String> managedClasses = new ArrayList<String>();
    private final List<String> managedNames = new ArrayList<String>();

    public XmlPreProcessingResultImpl(PersistenceUnitMetadataImpl persistenceUnitMetadata) {
        this.persistenceUnitMetadata = persistenceUnitMetadata;
    }

    public XmlPreProcessingResultImpl(PersistenceUnitMetadata persistenceUnitMetadata) {
        this((PersistenceUnitMetadataImpl)persistenceUnitMetadata);
    }

    public XmlPreProcessingResultImpl() {
        this(new PersistenceUnitMetadataImpl());
    }

    @Override
    public PersistenceUnitMetadataImpl getPersistenceUnitMetadata() {
        return this.persistenceUnitMetadata;
    }

    @Override
    public List<JaxbEntityMappingsImpl> getDocuments() {
        return this.documents;
    }

    @Override
    public List<String> getMappedClasses() {
        return this.managedClasses;
    }

    @Override
    public List<String> getMappedNames() {
        return this.managedNames;
    }

    public void addDocument(JaxbEntityMappingsImpl document) {
        this.persistenceUnitMetadata.apply(document.getPersistenceUnitMetadata());
        this.documents.add(document);
        document.getEmbeddables().forEach(jaxbEmbeddable -> {
            if (StringHelper.isNotEmpty(jaxbEmbeddable.getClazz())) {
                this.managedClasses.add(XmlProcessingHelper.determineClassName(document, jaxbEmbeddable));
            } else if (StringHelper.isNotEmpty(jaxbEmbeddable.getName())) {
                this.managedNames.add(jaxbEmbeddable.getName());
            }
        });
        document.getMappedSuperclasses().forEach(jaxbMappedSuperclass -> this.managedClasses.add(XmlProcessingHelper.determineClassName(document, jaxbMappedSuperclass)));
        document.getEntities().forEach(jaxbEntity -> {
            if (StringHelper.isNotEmpty(jaxbEntity.getClazz())) {
                this.managedClasses.add(XmlProcessingHelper.determineClassName(document, jaxbEntity));
            } else if (StringHelper.isNotEmpty(jaxbEntity.getName())) {
                this.managedNames.add(jaxbEntity.getName());
            }
        });
    }
}

