/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import org.hibernate.annotations.FetchMode;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOrderColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralFetchModeImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.XmlAnnotations;
import org.hibernate.boot.models.annotations.internal.CollectionClassificationXmlAnnotation;
import org.hibernate.boot.models.annotations.internal.FetchAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyClassJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyEnumeratedJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.MapKeyTemporalJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.OrderByJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.OrderColumnJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.SortComparatorAnnotation;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class CommonPluralAttributeProcessing {
    public static void applyPluralAttributeStructure(JaxbPluralAttribute jaxbPluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext buildingContext = xmlDocumentContext.getModelBuildingContext();
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        if (jaxbPluralAttribute.getFetchMode() != null) {
            FetchAnnotation fetchAnn = (FetchAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.FETCH, buildingContext);
            fetchAnn.value(CommonPluralAttributeProcessing.interpretFetchMode(jaxbPluralAttribute.getFetchMode()));
        }
        if (jaxbPluralAttribute.getClassification() != null) {
            if (jaxbPluralAttribute.getClassification() == LimitedCollectionClassification.BAG) {
                memberDetails.applyAnnotationUsage(HibernateAnnotations.BAG, buildingContext);
            } else {
                CollectionClassificationXmlAnnotation collectionClassificationAnn = (CollectionClassificationXmlAnnotation)memberDetails.applyAnnotationUsage(XmlAnnotations.COLLECTION_CLASSIFICATION, buildingContext);
                collectionClassificationAnn.value(jaxbPluralAttribute.getClassification());
            }
        }
        XmlAnnotationHelper.applyCollectionUserType(jaxbPluralAttribute.getCollectionType(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCollectionId(jaxbPluralAttribute.getCollectionId(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCollectionClassification(jaxbPluralAttribute.getClassification(), memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbPluralAttribute.getOrderBy())) {
            OrderByJpaAnnotation orderByAnn = (OrderByJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.ORDER_BY, buildingContext));
            orderByAnn.value(jaxbPluralAttribute.getOrderBy());
        }
        CommonPluralAttributeProcessing.applyOrderColumn(jaxbPluralAttribute, memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbPluralAttribute.getSort())) {
            SortComparatorAnnotation sortAnn = (SortComparatorAnnotation)memberDetails.applyAnnotationUsage(HibernateAnnotations.SORT_COMPARATOR, buildingContext);
            ClassDetails comparatorClassDetails = classDetailsRegistry.resolveClassDetails(jaxbPluralAttribute.getSort());
            sortAnn.value(comparatorClassDetails.toJavaClass());
        }
        if (jaxbPluralAttribute.getSortNatural() != null) {
            memberDetails.applyAnnotationUsage(HibernateAnnotations.SORT_NATURAL, buildingContext);
        }
        if (jaxbPluralAttribute.getMapKey() != null) {
            MapKeyJpaAnnotation mapKeyAnn = (MapKeyJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY, buildingContext));
            if (jaxbPluralAttribute.getMapKey() != null && StringHelper.isNotEmpty(jaxbPluralAttribute.getMapKey().getName())) {
                mapKeyAnn.name(jaxbPluralAttribute.getMapKey().getName());
            }
        }
        if (jaxbPluralAttribute.getMapKeyClass() != null) {
            String className = xmlDocumentContext.resolveClassName(jaxbPluralAttribute.getMapKeyClass().getClazz());
            ClassDetails mapKeyClass = classDetailsRegistry.resolveClassDetails(className);
            MapKeyClassJpaAnnotation mapKeyClassAnn = (MapKeyClassJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_CLASS, buildingContext));
            mapKeyClassAnn.value(mapKeyClass.toJavaClass());
        }
        if (jaxbPluralAttribute.getMapKeyTemporal() != null) {
            MapKeyTemporalJpaAnnotation mapKeyTemporalAnn = (MapKeyTemporalJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_TEMPORAL, buildingContext));
            mapKeyTemporalAnn.value(jaxbPluralAttribute.getMapKeyTemporal());
        }
        if (jaxbPluralAttribute.getMapKeyEnumerated() != null) {
            MapKeyEnumeratedJpaAnnotation mapKeyEnumeratedAnn = (MapKeyEnumeratedJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_ENUMERATED, buildingContext));
            mapKeyEnumeratedAnn.value(jaxbPluralAttribute.getMapKeyEnumerated());
        }
        XmlAnnotationHelper.applyConverts(jaxbPluralAttribute.getMapKeyConverts(), "key", memberDetails, xmlDocumentContext);
        if (jaxbPluralAttribute.getMapKeyColumn() != null) {
            MapKeyColumnJpaAnnotation columnAnn = (MapKeyColumnJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_COLUMN, xmlDocumentContext.getModelBuildingContext()));
            columnAnn.apply(jaxbPluralAttribute.getMapKeyColumn(), xmlDocumentContext);
        }
        if (jaxbPluralAttribute.getMapKeyType() != null) {
            XmlAnnotationHelper.applyMapKeyUserType(jaxbPluralAttribute.getMapKeyType(), memberDetails, xmlDocumentContext);
        }
        JoinColumnProcessing.applyMapKeyJoinColumns(jaxbPluralAttribute.getMapKeyJoinColumns(), memberDetails, xmlDocumentContext);
        ForeignKeyProcessing.applyForeignKey(jaxbPluralAttribute.getMapKeyForeignKey(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyFilters(jaxbPluralAttribute.getFilters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlRestriction(jaxbPluralAttribute.getSqlRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlInsert(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_INSERT, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlUpdate(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_UPDATE, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlDelete(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_DELETE, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlDeleteAll(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_DELETE_ALL, xmlDocumentContext);
    }

    private static FetchMode interpretFetchMode(JaxbPluralFetchModeImpl fetchMode) {
        return switch (fetchMode) {
            default -> throw new IncompatibleClassChangeError();
            case JaxbPluralFetchModeImpl.JOIN -> FetchMode.JOIN;
            case JaxbPluralFetchModeImpl.SELECT -> FetchMode.SELECT;
            case JaxbPluralFetchModeImpl.SUBSELECT -> FetchMode.SELECT;
        };
    }

    private static void applyOrderColumn(JaxbPluralAttribute jaxbPluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbOrderColumnImpl jaxbOrderColumn = jaxbPluralAttribute.getOrderColumn();
        if (jaxbOrderColumn == null) {
            return;
        }
        OrderColumnJpaAnnotation orderColumnAnn = (OrderColumnJpaAnnotation)((Object)memberDetails.applyAnnotationUsage(JpaAnnotations.ORDER_COLUMN, xmlDocumentContext.getModelBuildingContext()));
        orderColumnAnn.apply(jaxbOrderColumn, xmlDocumentContext);
    }
}

