/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JsonArrayJdbcType;

public class H2JsonArrayJdbcType
extends JsonArrayJdbcType {
    public H2JsonArrayJdbcType(JdbcType elementJdbcType) {
        super(elementJdbcType);
    }

    @Override
    public String toString() {
        return "H2JsonArrayJdbcType";
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                String json = ((H2JsonArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setBytes(index, json.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                String json = ((H2JsonArrayJdbcType)this.getJdbcType()).toString(value, this.getJavaType(), options);
                st.setBytes(name, json.getBytes(StandardCharsets.UTF_8));
            }
        };
    }
}

