/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import jakarta.persistence.TemporalType;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryTimeoutException;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.AbstractTransactSQLDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.SQLServerCastingXmlArrayJdbcTypeConstructor;
import org.hibernate.dialect.SQLServerCastingXmlJdbcType;
import org.hibernate.dialect.SQLServerSqlAstTranslator;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.SQLServerAggregateSupport;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.CountFunction;
import org.hibernate.dialect.function.SQLServerFormatEmulation;
import org.hibernate.dialect.function.SqlServerConvertTruncFunction;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.identity.SQLServerIdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.SQLServer2012LimitHandler;
import org.hibernate.dialect.sequence.SQLServer16SequenceSupport;
import org.hibernate.dialect.sequence.SQLServerSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.unique.AlterTableUniqueIndexDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.jdbc.dialect.spi.BasicSQLExceptionConverter;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierCaseStrategy;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.CheckConstraint;
import org.hibernate.mapping.Column;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.procedure.internal.SQLServerCallableStatementSupport;
import org.hibernate.procedure.spi.CallableStatementSupport;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.tool.schema.internal.StandardSequenceExporter;
import org.hibernate.tool.schema.spi.Exporter;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.TimestampUtcAsJdbcTimestampJdbcType;
import org.hibernate.type.descriptor.jdbc.TinyIntAsSmallIntJdbcType;
import org.hibernate.type.descriptor.jdbc.UUIDJdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;
import org.hibernate.type.descriptor.sql.internal.DdlTypeImpl;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class SQLServerDialect
extends AbstractTransactSQLDialect {
    private static final DatabaseVersion MINIMUM_VERSION = DatabaseVersion.make(11, 0);
    private static final int PARAM_LIST_SIZE_LIMIT = 2048;
    private static final int GEOMETRY_TYPE_CODE = -157;
    private static final int GEOGRAPHY_TYPE_CODE = -158;
    private final StandardSequenceExporter exporter;
    private final UniqueDelegate uniqueDelegate = new AlterTableUniqueIndexDelegate(this);
    private final Dialect.SizeStrategy sizeStrategy = new Dialect.SizeStrategyImpl(){

        @Override
        public Size resolveSize(JdbcType jdbcType, JavaType<?> javaType, Integer precision, Integer scale, Long length) {
            return switch (jdbcType.getDdlTypeCode()) {
                case 2004, 2005, 2011 -> super.resolveSize(jdbcType, javaType, precision, scale, length == null ? SQLServerDialect.this.getDefaultLobLength() : length.longValue());
                default -> super.resolveSize(jdbcType, javaType, precision, scale, length);
            };
        }
    };

    public SQLServerDialect() {
        this(MINIMUM_VERSION);
    }

    public SQLServerDialect(DatabaseVersion version) {
        super(version);
        this.exporter = this.createSequenceExporter(version);
    }

    public SQLServerDialect(DialectResolutionInfo info) {
        this(SQLServerDialect.staticDetermineDatabaseVersion(info));
        this.registerKeywords(info);
    }

    @Override
    public DatabaseVersion determineDatabaseVersion(DialectResolutionInfo info) {
        return SQLServerDialect.staticDetermineDatabaseVersion(info);
    }

    private static DatabaseVersion staticDetermineDatabaseVersion(DialectResolutionInfo info) {
        Integer compatibilityLevel = SQLServerDialect.getCompatibilityLevel(info);
        if (compatibilityLevel != null) {
            int majorVersion = compatibilityLevel / 10;
            int minorVersion = compatibilityLevel % 10;
            return DatabaseVersion.make(majorVersion, minorVersion);
        }
        return info.makeCopyOrDefault(MINIMUM_VERSION);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Integer getCompatibilityLevel(DialectResolutionInfo info) {
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData == null) return ConfigurationHelper.getInteger("hibernate.dialect.sqlserver.compatibility_level", info.getConfigurationValues());
        try (Statement statement = databaseMetaData.getConnection().createStatement();){
            ResultSet rs = statement.executeQuery("SELECT compatibility_level FROM sys.databases where name = db_name();");
            if (!rs.next()) return ConfigurationHelper.getInteger("hibernate.dialect.sqlserver.compatibility_level", info.getConfigurationValues());
            Integer n = rs.getInt(1);
            return n;
        }
        catch (SQLException e) {
            throw BasicSQLExceptionConverter.INSTANCE.convert(e);
        }
    }

    private StandardSequenceExporter createSequenceExporter(DatabaseVersion version) {
        return new SqlServerSequenceExporter(this);
    }

    @Override
    protected DatabaseVersion getMinimumSupportedVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        this.registerKeyword("top");
        this.registerKeyword("key");
    }

    @Override
    protected String columnType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 8 -> "float";
            case 2005 -> "varchar(max)";
            case 2011 -> "nvarchar(max)";
            case 2004 -> "varbinary(max)";
            case 91 -> "date";
            case 92 -> "time";
            case 93 -> "datetime2($p)";
            case 2013, 2014 -> "datetimeoffset($p)";
            default -> super.columnType(sqlTypeCode);
        };
    }

    @Override
    protected String castType(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case 12, 2005, 4001 -> "varchar(max)";
            case -9, 2011, 4002 -> "nvarchar(max)";
            case -3, 2004, 4003 -> "varbinary(max)";
            default -> super.castType(sqlTypeCode);
        };
    }

    @Override
    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3200, "geometry", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3250, "geography", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(2009, "xml", this));
        ddlTypeRegistry.addDescriptor(new DdlTypeImpl(3000, "uniqueidentifier", this));
    }

    @Override
    public int getPreferredSqlTypeCodeForArray() {
        return 3019;
    }

    @Override
    public JdbcType resolveSqlTypeDescriptor(String columnTypeName, int jdbcTypeCode, int precision, int scale, JdbcTypeRegistry jdbcTypeRegistry) {
        switch (jdbcTypeCode) {
            case 1111: {
                if (!columnTypeName.equals("uniqueidentifier")) break;
                jdbcTypeCode = 3000;
                break;
            }
            case -157: {
                jdbcTypeCode = 3200;
                break;
            }
            case -158: {
                jdbcTypeCode = 3250;
            }
        }
        return super.resolveSqlTypeDescriptor(columnTypeName, jdbcTypeCode, precision, scale, jdbcTypeRegistry);
    }

    @Override
    public int getMaxVarcharLength() {
        return 8000;
    }

    @Override
    public int getMaxNVarcharLength() {
        return 4000;
    }

    @Override
    public TimeZoneSupport getTimeZoneSupport() {
        return TimeZoneSupport.NATIVE;
    }

    @Override
    public long getDefaultLobLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxIdentifierLength() {
        return 128;
    }

    @Override
    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        typeContributions.contributeJdbcType(TimestampUtcAsJdbcTimestampJdbcType.INSTANCE);
        typeContributions.getTypeConfiguration().getJdbcTypeRegistry().addDescriptor(-6, TinyIntAsSmallIntJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(SQLServerCastingXmlJdbcType.INSTANCE);
        typeContributions.contributeJdbcType(UUIDJdbcType.INSTANCE);
        typeContributions.contributeJdbcTypeConstructor(SQLServerCastingXmlArrayJdbcTypeConstructor.INSTANCE);
    }

    @Override
    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType<Date> dateType = basicTypeRegistry.resolve(StandardBasicTypes.DATE);
        BasicType<Date> timeType = basicTypeRegistry.resolve(StandardBasicTypes.TIME);
        BasicType<Date> timestampType = basicTypeRegistry.resolve(StandardBasicTypes.TIMESTAMP);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionContributions.getFunctionRegistry().register("count", new CountFunction(this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.DEFAULT, "count_big", "+", "varchar(max)", true, "varbinary(max)"));
        functionFactory.avg_castingNonDoubleArguments(this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.log_log();
        functionFactory.round_round();
        functionFactory.everyAny_minMaxIif();
        functionFactory.octetLength_pattern("datalength(?1)");
        functionFactory.bitLength_pattern("datalength(?1)*8");
        functionFactory.locate_charindex();
        functionFactory.stddevPopSamp_stdevp();
        functionFactory.varPopSamp_varp();
        functionContributions.getFunctionRegistry().register("format", new SQLServerFormatEmulation(functionContributions.getTypeConfiguration()));
        functionFactory.translate();
        functionFactory.median_percentileCont(true);
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datefromparts").setInvariantType(dateType).setExactArgumentCount(3).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("timefromparts").setInvariantType(timeType).setExactArgumentCount(5).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("smalldatetimefromparts").setInvariantType(timestampType).setExactArgumentCount(5).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetimefromparts").setInvariantType(timestampType).setExactArgumentCount(7).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetime2fromparts").setInvariantType(timestampType).setExactArgumentCount(8).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("datetimeoffsetfromparts").setInvariantType(timestampType).setExactArgumentCount(10).setParameterTypes(FunctionParameterType.INTEGER).register();
        functionFactory.windowFunctions();
        functionFactory.inverseDistributionOrderedSetAggregates_windowEmulation();
        functionFactory.hypotheticalOrderedSetAggregates_windowEmulation();
        if (this.getVersion().isSameOrAfter(13)) {
            functionFactory.jsonValue_sqlserver();
            functionFactory.jsonQuery_sqlserver();
            functionFactory.jsonExists_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonObject_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonArray_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonSet_sqlserver();
            functionFactory.jsonRemove_sqlserver();
            functionFactory.jsonReplace_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonInsert_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonArrayAppend_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonArrayInsert_sqlserver();
            functionFactory.jsonTable_sqlserver();
        }
        functionFactory.xmlelement_sqlserver();
        functionFactory.xmlcomment_sqlserver();
        functionFactory.xmlforest_sqlserver();
        functionFactory.xmlconcat_sqlserver();
        functionFactory.xmlpi_sqlserver();
        functionFactory.xmlquery_sqlserver();
        functionFactory.xmlexists_sqlserver();
        functionFactory.xmlagg_sqlserver();
        functionFactory.xmltable_sqlserver();
        functionFactory.unnest_sqlserver();
        if (this.getVersion().isSameOrAfter(14)) {
            functionFactory.listagg_stringAggWithinGroup("varchar(max)");
            functionFactory.jsonArrayAgg_sqlserver(this.getVersion().isSameOrAfter(16));
            functionFactory.jsonObjectAgg_sqlserver(this.getVersion().isSameOrAfter(16));
        }
        if (this.getVersion().isSameOrAfter(16)) {
            functionFactory.leastGreatest();
            functionFactory.dateTrunc_datetrunc();
            functionFactory.trunc_round_datetrunc();
            functionFactory.generateSeries_sqlserver(this.getMaximumSeriesSize());
        } else {
            functionContributions.getFunctionRegistry().register("trunc", new SqlServerConvertTruncFunction(functionContributions.getTypeConfiguration()));
            functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
            if (this.supportsRecursiveCTE()) {
                functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), false, false);
            }
        }
    }

    protected int getMaximumSeriesSize() {
        if (this.getVersion().isSameOrAfter(16)) {
            return 10000;
        }
        return 100;
    }

    @Override
    public String trimPattern(TrimSpec specification, boolean isWhitespace) {
        if (this.getVersion().isSameOrAfter(16)) {
            return switch (specification) {
                default -> throw new IncompatibleClassChangeError();
                case TrimSpec.BOTH -> {
                    if (isWhitespace) {
                        yield "trim(?1)";
                    }
                    yield "trim(?2 from ?1)";
                }
                case TrimSpec.LEADING -> {
                    if (isWhitespace) {
                        yield "ltrim(?1)";
                    }
                    yield "ltrim(?1,?2)";
                }
                case TrimSpec.TRAILING -> isWhitespace ? "rtrim(?1)" : "rtrim(?1,?2)";
            };
        }
        return super.trimPattern(specification, isWhitespace);
    }

    @Override
    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            @Override
            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, org.hibernate.sql.ast.tree.Statement statement) {
                return new SQLServerSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    @Override
    public AggregateSupport getAggregateSupport() {
        return SQLServerAggregateSupport.valueOf(this);
    }

    @Override
    public Dialect.SizeStrategy getSizeStrategy() {
        return this.sizeStrategy;
    }

    @Override
    public String castPattern(CastType from, CastType to) {
        if (to == CastType.STRING) {
            switch (from) {
                case TIMESTAMP: {
                    return "format(?1,'yyyy-MM-dd HH:mm:ss')";
                }
                case TIME: {
                    return "format(?1,'hh\\:mm\\:ss')";
                }
            }
        }
        return super.castPattern(from, to);
    }

    @Override
    public String currentTimestamp() {
        return "sysdatetime()";
    }

    @Override
    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        if (dbMetaData == null) {
            builder.setUnquotedCaseStrategy(IdentifierCaseStrategy.MIXED);
            builder.setQuotedCaseStrategy(IdentifierCaseStrategy.MIXED);
        }
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    @Override
    public String currentTime() {
        return "convert(time,getdate())";
    }

    @Override
    public String currentDate() {
        return "convert(date,getdate())";
    }

    @Override
    public String currentTimestampWithTimeZone() {
        return "sysdatetimeoffset()";
    }

    @Override
    public String getNoColumnsInsertString() {
        return "default values";
    }

    @Override
    public LimitHandler getLimitHandler() {
        return SQLServer2012LimitHandler.INSTANCE;
    }

    @Override
    public boolean supportsValuesList() {
        return true;
    }

    @Override
    public boolean supportsDistinctFromPredicate() {
        return this.getVersion().isSameOrAfter(16);
    }

    @Override
    public char closeQuote() {
        return ']';
    }

    @Override
    public String getCurrentSchemaCommand() {
        return "select schema_name()";
    }

    @Override
    public boolean supportsIfExistsBeforeTableName() {
        return this.getVersion().isSameOrAfter(16) || super.supportsIfExistsBeforeTableName();
    }

    @Override
    public boolean supportsIfExistsBeforeConstraintName() {
        return this.getVersion().isSameOrAfter(16) || super.supportsIfExistsBeforeConstraintName();
    }

    @Override
    public char openQuote() {
        return '[';
    }

    @Override
    public String appendLockHint(LockOptions lockOptions, String tableName) {
        LockMode lockMode = lockOptions.getAliasSpecificLockMode(tableName);
        if (lockMode == null) {
            lockMode = lockOptions.getLockMode();
        }
        String writeLockStr = lockOptions.getTimeOut() == -2 ? "updlock" : "updlock,holdlock";
        String readLockStr = lockOptions.getTimeOut() == -2 ? "updlock" : "holdlock";
        String noWaitStr = lockOptions.getTimeOut() == 0 ? ",nowait" : "";
        String skipLockStr = lockOptions.getTimeOut() == -2 ? ",readpast" : "";
        return switch (lockMode) {
            case LockMode.PESSIMISTIC_WRITE, LockMode.WRITE -> tableName + " with (" + writeLockStr + ",rowlock" + noWaitStr + skipLockStr + ")";
            case LockMode.PESSIMISTIC_READ -> tableName + " with (" + readLockStr + ",rowlock" + noWaitStr + skipLockStr + ")";
            case LockMode.UPGRADE_SKIPLOCKED -> tableName + " with (updlock,rowlock,readpast" + noWaitStr + ")";
            case LockMode.UPGRADE_NOWAIT -> tableName + " with (updlock,holdlock,rowlock,nowait)";
            default -> tableName;
        };
    }

    @Override
    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    @Override
    public boolean supportsResultSetPositionQueryMethodsOnForwardOnlyCursor() {
        return false;
    }

    @Override
    public boolean supportsCircularCascadeDeleteConstraints() {
        return false;
    }

    @Override
    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    @Override
    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    @Override
    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return false;
    }

    @Override
    public int getInExpressionCountLimit() {
        return 2048;
    }

    @Override
    public IdentityColumnSupport getIdentityColumnSupport() {
        return SQLServerIdentityColumnSupport.INSTANCE;
    }

    @Override
    public boolean supportsNonQueryWithCTE() {
        return true;
    }

    @Override
    public boolean supportsSkipLocked() {
        return true;
    }

    @Override
    public boolean supportsNoWait() {
        return true;
    }

    @Override
    public boolean supportsWait() {
        return false;
    }

    @Override
    public SequenceSupport getSequenceSupport() {
        return this.getVersion().isSameOrAfter(16) ? SQLServer16SequenceSupport.INSTANCE : SQLServerSequenceSupport.INSTANCE;
    }

    @Override
    public String getQuerySequencesString() {
        return "select * from INFORMATION_SCHEMA.SEQUENCES";
    }

    @Override
    public String getQueryHintString(String sql, String hints) {
        StringBuilder buffer = new StringBuilder(sql.length() + hints.length() + 12);
        int pos = sql.indexOf(59);
        if (pos > -1) {
            buffer.append(sql, 0, pos);
        } else {
            buffer.append(sql);
        }
        buffer.append(" OPTION (").append(hints).append(")");
        if (pos > -1) {
            buffer.append(";");
        }
        sql = buffer.toString();
        return sql;
    }

    @Override
    public boolean supportsNullPrecedence() {
        return false;
    }

    @Override
    public boolean supportsOffsetInSubquery() {
        return true;
    }

    @Override
    public boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public boolean supportsLateral() {
        return true;
    }

    @Override
    public boolean supportsRecursiveCTE() {
        return true;
    }

    @Override
    public boolean supportsFetchClause(FetchClauseType type) {
        return true;
    }

    @Override
    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return new TemplatedViolatedConstraintNameExtractor(sqle -> {
            switch (JdbcExceptionHelper.extractErrorCode(sqle)) {
                case 2601: 
                case 2627: {
                    String message = sqle.getMessage();
                    if (message.contains("unique index ")) {
                        return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("unique index '", "'", message);
                    }
                    return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate("'", "'", message);
                }
            }
            return null;
        });
    }

    @Override
    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            String sqlState = JdbcExceptionHelper.extractSqlState(sqlException);
            if ("HY008".equals(sqlState)) {
                return new QueryTimeoutException(message, sqlException, sql);
            }
            return switch (JdbcExceptionHelper.extractErrorCode(sqlException)) {
                case 1222 -> new LockTimeoutException(message, sqlException, sql);
                case 2601, 2627 -> new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException));
                default -> null;
            };
        };
    }

    @Override
    public int getDefaultTimestampPrecision() {
        return 7;
    }

    @Override
    public long getFractionalSecondPrecisionInNanos() {
        return 1L;
    }

    @Override
    public String extractPattern(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.TIMEZONE_HOUR -> "(datepart(tz,?2)/60)";
            case TemporalUnit.TIMEZONE_MINUTE -> "(datepart(tz,?2)%60)";
            case TemporalUnit.SECOND -> "(datepart(second,?2)+datepart(nanosecond,?2)/1000000000)";
            case TemporalUnit.EPOCH -> "datediff_big(second, '1970-01-01', ?2)";
            default -> "datepart(?1,?2)";
        };
    }

    @Override
    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        return switch (unit) {
            case TemporalUnit.NANOSECOND, TemporalUnit.NATIVE -> "dateadd(nanosecond,?2%1000000000,dateadd(second,?2/1000000000,?3))";
            case TemporalUnit.SECOND -> "dateadd(nanosecond,cast(?2*1e9 as bigint)%1000000000,dateadd(second,?2,?3))";
            default -> "dateadd(?1,?2,?3)";
        };
    }

    @Override
    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        if (unit == TemporalUnit.NATIVE) {
            return "datediff_big(nanosecond,?2,?3)";
        }
        return unit.normalized() == TemporalUnit.NANOSECOND ? "datediff_big(?1,?2,?3)" : "datediff(?1,?2,?3)";
    }

    @Override
    public String translateDurationField(TemporalUnit unit) {
        return unit == TemporalUnit.NATIVE ? "nanosecond" : super.translateDurationField(unit);
    }

    @Override
    public String translateExtractField(TemporalUnit unit) {
        return switch (unit) {
            case TemporalUnit.WEEK -> "isowk";
            case TemporalUnit.OFFSET -> "tz";
            default -> super.translateExtractField(unit);
        };
    }

    @Override
    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SQLServerDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "\"").replace("G", "g").replace("EEEE", "dddd").replace("EEE", "ddd").replace("a", "tt").replace("S", "F").replace("XXX", "K").replace("xxx", "zzz").replace("x", "zz");
    }

    @Override
    public void appendUUIDLiteral(SqlAppender appender, UUID literal) {
        appender.appendSql("cast('");
        appender.appendSql(literal.toString());
        appender.appendSql("' as uniqueidentifier)");
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate(appender, temporalAccessor);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime(appender, temporalAccessor, this.supportsTemporalLiteralOffset(), jdbcTimeZone);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                if (this.supportsTemporalLiteralOffset() && temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
                    DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, true, jdbcTimeZone);
                    appender.appendSql("' as datetimeoffset)");
                    break;
                }
                DateTimeUtils.appendAsTimestampWithMicros(appender, temporalAccessor, false, jdbcTimeZone);
                appender.appendSql("' as datetime2)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate(appender, date);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime(appender, date);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMicros(appender, date, jdbcTimeZone);
                appender.appendSql("' as datetimeoffset)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsDate(appender, calendar);
                appender.appendSql("' as date)");
                break;
            }
            case TIME: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTime(appender, calendar);
                appender.appendSql("' as time)");
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("cast('");
                DateTimeUtils.appendAsTimestampWithMillis(appender, calendar, jdbcTimeZone);
                appender.appendSql("' as datetime2)");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public String getCreateTemporaryTableColumnAnnotation(int sqlTypeCode) {
        return switch (sqlTypeCode) {
            case -16, -15, -9, -1, 1, 12 -> "collate database_default";
            default -> "";
        };
    }

    @Override
    public String[] getDropSchemaCommand(String schemaName) {
        String[] stringArray;
        if (this.getVersion().isSameOrAfter(13)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "drop schema if exists " + schemaName;
        } else {
            stringArray = super.getDropSchemaCommand(schemaName);
        }
        return stringArray;
    }

    @Override
    public String getCreateIndexString(boolean unique) {
        return unique ? "create unique nonclustered index" : "create index";
    }

    @Override
    public String getCreateIndexTail(boolean unique, List<Column> columns) {
        if (unique) {
            StringBuilder tail = new StringBuilder();
            for (Column column : columns) {
                if (!column.isNullable()) continue;
                tail.append(tail.isEmpty() ? " where " : " and ").append(column.getQuotedName(this)).append(" is not null");
            }
            return tail.toString();
        }
        return "";
    }

    @Override
    public String getAlterColumnTypeString(String columnName, String columnType, String columnDefinition) {
        return "alter column " + columnName + " " + columnType;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.BOTH;
    }

    @Override
    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    @Override
    public Exporter<Sequence> getSequenceExporter() {
        return this.exporter == null ? super.getSequenceExporter() : this.exporter;
    }

    @Override
    public String generatedAs(String generatedAs) {
        return " as (" + generatedAs + ") persisted";
    }

    @Override
    public boolean hasDataTypeBeforeGeneratedAs() {
        return false;
    }

    @Override
    public MutationOperation createOptionalTableUpdateOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate optionalTableUpdate, SessionFactoryImplementor factory) {
        SQLServerSqlAstTranslator translator = new SQLServerSqlAstTranslator(factory, optionalTableUpdate);
        return translator.createMergeOperation(optionalTableUpdate);
    }

    @Override
    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    @Override
    public boolean supportsFromClauseInUpdate() {
        return true;
    }

    @Override
    public CallableStatementSupport getCallableStatementSupport() {
        return SQLServerCallableStatementSupport.INSTANCE;
    }

    @Override
    public String getCheckConstraintString(CheckConstraint checkConstraint) {
        String constraintName = checkConstraint.getName();
        return constraintName == null ? " check " + this.getCheckConstraintOptions(checkConstraint) + "(" + checkConstraint.getConstraint() + ")" : " constraint " + constraintName + " check " + this.getCheckConstraintOptions(checkConstraint) + "(" + checkConstraint.getConstraint() + ")";
    }

    private String getCheckConstraintOptions(CheckConstraint checkConstraint) {
        return StringHelper.isNotEmpty(checkConstraint.getOptions()) ? checkConstraint.getOptions() + " " : "";
    }

    @Override
    public boolean supportsBindingNullForSetObject() {
        return true;
    }

    private static class SqlServerSequenceExporter
    extends StandardSequenceExporter {
        public SqlServerSequenceExporter(Dialect dialect) {
            super(dialect);
        }

        @Override
        protected String getFormattedSequenceName(QualifiedSequenceName name, Metadata metadata, SqlStringGenerationContext context) {
            return context.formatWithoutCatalog(name);
        }
    }
}

