/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.dialect.function.json.HANAJsonValueFunction;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.AggregateColumn;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.SqlTypes;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class HANAAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new HANAAggregateSupport();
    private static final String JSON_QUERY_START = "json_query(";
    private static final String JSON_QUERY_JSON_END = "' error on error)";

    private HANAAggregateSupport() {
    }

    public static AggregateSupport valueOf(Dialect dialect) {
        return dialect.getVersion().isSameOrAfter(2, 0, 40) ? INSTANCE : AggregateSupportImpl.INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                String parentPartExpression = HANAAggregateSupport.determineParentPartExpression(aggregateParentReadExpression);
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 16: {
                        if (SqlTypes.isNumericType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                            return template.replace(placeholder, "case json_value(" + parentPartExpression + columnExpression + "') when 'true' then 1 when 'false' then 0 end");
                        }
                        return template.replace(placeholder, "case json_value(" + parentPartExpression + columnExpression + "') when 'true' then true when 'false' then false end");
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 3003: {
                        return template.replace(placeholder, "cast(json_value(" + parentPartExpression + columnExpression + "') as " + column.getColumnDefinition() + ")");
                    }
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        return template.replace(placeholder, "hextobin(json_value(" + parentPartExpression + columnExpression + "' error on error))");
                    }
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, JSON_QUERY_START + parentPartExpression + columnExpression + JSON_QUERY_JSON_END);
                    }
                    case 3000: {
                        if (!SqlTypes.isBinaryType(column.getJdbcMapping().getJdbcType().getDdlTypeCode())) break;
                        return template.replace(placeholder, "hextobin(json_value(" + parentPartExpression + columnExpression + "'))");
                    }
                }
                return template.replace(placeholder, "json_value(" + parentPartExpression + columnExpression + "' returning " + HANAJsonValueFunction.jsonValueReturningType(column) + " error on error)");
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static String determineParentPartExpression(String aggregateParentReadExpression) {
        String parentPartExpression = aggregateParentReadExpression.startsWith(JSON_QUERY_START) && aggregateParentReadExpression.endsWith(JSON_QUERY_JSON_END) ? aggregateParentReadExpression.substring(JSON_QUERY_START.length(), aggregateParentReadExpression.length() - JSON_QUERY_JSON_END.length()) + "." : aggregateParentReadExpression + ",'$.";
        return parentPartExpression;
    }

    private static String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping) {
        int sqlTypeCode = jdbcMapping.getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode) {
            case 3000: {
                if (!SqlTypes.isBinaryType(jdbcMapping.getJdbcType().getDdlTypeCode())) {
                    return customWriteExpression;
                }
            }
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "bintohex(" + customWriteExpression + ")";
            }
            case 93: {
                return "to_varchar(" + customWriteExpression + ",'YYYY-MM-DD\"T\"HH24:MI:SS.FF9')";
            }
            case 3003: {
                return "to_varchar(" + customWriteExpression + ",'YYYY-MM-DD\"T\"HH24:MI:SS.FF9\"Z\"')";
            }
        }
        return customWriteExpression;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                return aggregateParentAssignmentExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    @Override
    public String aggregateCustomWriteExpression(AggregateColumn aggregateColumn, List<Column> aggregatedColumns) {
        int sqlTypeCode = aggregateColumn.getType().getJdbcType().getDefaultSqlTypeCode();
        switch (sqlTypeCode == 2003 ? aggregateColumn.getTypeCode() : sqlTypeCode) {
            case 3001: 
            case 3018: {
                return null;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumn.getTypeCode());
    }

    @Override
    public int aggregateComponentSqlTypeCode(int aggregateColumnSqlTypeCode, int columnSqlTypeCode) {
        if (aggregateColumnSqlTypeCode == 3001) {
            return columnSqlTypeCode == 2003 ? 3018 : columnSqlTypeCode;
        }
        return columnSqlTypeCode;
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 3001;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
        return new RootJsonWriteExpression(aggregateColumn, columns);
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            super(aggregateColumn, aggregateColumn.getColumnDefinition());
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(aggregateColumn, columns);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)basePath, translator, aggregateColumnWriteExpression);
        }
    }

    private static class PassThroughExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;

        PassThroughExpression(SelectableMapping selectableMapping) {
            this.selectableMapping = selectableMapping;
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isJson();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            String parentPartExpression = HANAAggregateSupport.determineParentPartExpression(path);
            switch (this.selectableMapping.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                case 16: {
                    sb.append("case json_value(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    if (SqlTypes.isNumericType(this.selectableMapping.getJdbcMapping().getJdbcType().getDdlTypeCode())) {
                        sb.append("') when 'true' then 1 when 'false' then 0 end");
                        break;
                    }
                    sb.append("') when 'true' then true when 'false' then false end");
                    break;
                }
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    sb.append("json_value(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append("' returning ");
                    sb.append(HANAJsonValueFunction.jsonValueReturningType(this.selectableMapping));
                    sb.append(" error on error)");
                    break;
                }
                case 3001: 
                case 3018: {
                    sb.append(HANAAggregateSupport.JSON_QUERY_START);
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(HANAAggregateSupport.JSON_QUERY_JSON_END);
                    break;
                }
                default: {
                    sb.append("json_value(");
                    sb.append(parentPartExpression);
                    sb.append(this.selectableMapping.getSelectableName());
                    sb.append(HANAAggregateSupport.JSON_QUERY_JSON_END);
                }
            }
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public boolean isAggregate() {
            return this.selectableMapping.getJdbcMapping().getJdbcType().isJson();
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String columnDefinition;
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();

        private AggregateJsonWriteExpression(SelectableMapping selectableMapping, String columnDefinition) {
            this.selectableMapping = selectableMapping;
            this.columnDefinition = columnDefinition;
        }

        @Override
        public boolean isAggregate() {
            return true;
        }

        protected void initializeSubExpressions(SelectableMapping aggregateColumn, SelectableMapping[] columns) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                for (int i = 1; i < parts.length - 1; ++i) {
                    AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)currentAggregate.selectableMapping.getJdbcMapping().getJdbcType();
                    EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
                    int selectableIndex = embeddableMappingType.getSelectableIndex(parts[i].getSelectableName());
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression(embeddableMappingType.getSelectable(selectableIndex), this.columnDefinition));
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, HANAAggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping())));
            }
            this.passThroughUnsetSubExpressions(aggregateColumn);
        }

        protected void passThroughUnsetSubExpressions(SelectableMapping aggregateColumn) {
            AggregateJdbcType aggregateJdbcType = (AggregateJdbcType)aggregateColumn.getJdbcMapping().getJdbcType();
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            int jdbcValueCount = embeddableMappingType.getJdbcValueCount();
            for (int i = 0; i < jdbcValueCount; ++i) {
                SelectableMapping selectableMapping = embeddableMappingType.getJdbcValueSelectable(i);
                JsonWriteExpression jsonWriteExpression = this.subExpressions.get(selectableMapping.getSelectableName());
                if (jsonWriteExpression == null) {
                    this.subExpressions.put(selectableMapping.getSelectableName(), new PassThroughExpression(selectableMapping));
                    continue;
                }
                if (!(jsonWriteExpression instanceof AggregateJsonWriteExpression)) continue;
                AggregateJsonWriteExpression writeExpression = (AggregateJsonWriteExpression)jsonWriteExpression;
                writeExpression.passThroughUnsetSubExpressions(selectableMapping);
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            int aggregateCount = this.determineAggregateCount();
            if (aggregateCount != 0) {
                sb.append("(trim(trailing '}' from ");
            }
            sb.append("(select");
            if (aggregateCount != this.subExpressions.size()) {
                int separator = 32;
                for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                    String column = entry.getKey();
                    JsonWriteExpression value = entry.getValue();
                    if (value.isAggregate()) continue;
                    sb.append((char)separator);
                    value.append(sb, path, translator, expression);
                    sb.append(' ');
                    sb.appendDoubleQuoteEscapedString(column);
                    separator = 44;
                }
                sb.append(" from sys.dummy for json('arraywrap'='no','omitnull'='no')");
                sb.append(" returns ");
                sb.append(this.columnDefinition);
            } else {
                sb.append(" cast('{}' as ");
                sb.append(this.columnDefinition);
                sb.append(") jsonresult from sys.dummy");
            }
            sb.append(')');
            if (aggregateCount != 0) {
                sb.append(')');
                String parentPartExpression = HANAAggregateSupport.determineParentPartExpression(path);
                String separator = aggregateCount == this.subExpressions.size() ? " " : ",";
                for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                    String column = entry.getKey();
                    JsonWriteExpression value = entry.getValue();
                    if (!value.isAggregate()) continue;
                    sb.append("||'");
                    sb.append(separator);
                    sb.append('\"');
                    sb.append(column);
                    sb.append("\":'||");
                    if (value instanceof AggregateJsonWriteExpression) {
                        String subPath = HANAAggregateSupport.JSON_QUERY_START + parentPartExpression + column + HANAAggregateSupport.JSON_QUERY_JSON_END;
                        value.append(sb, subPath, translator, expression);
                    } else {
                        sb.append("coalesce(");
                        value.append(sb, path, translator, expression);
                        sb.append(",'null')");
                    }
                    separator = ",";
                }
                sb.append("||'}')");
            }
        }

        private int determineAggregateCount() {
            int count = 0;
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                if (!entry.getValue().isAggregate()) continue;
                ++count;
            }
            return count;
        }
    }

    static interface JsonWriteExpression {
        public boolean isAggregate();

        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

