/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.aggregate;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.aggregate.AggregateSupport;
import org.hibernate.dialect.aggregate.AggregateSupportImpl;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectablePath;
import org.hibernate.metamodel.mapping.SqlTypedMapping;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerAggregateSupport
extends AggregateSupportImpl {
    private static final AggregateSupport INSTANCE = new SQLServerAggregateSupport();
    private static final String JSON_QUERY_START = "json_query(";
    private static final String JSON_QUERY_JSON_END = "')";
    private static final int JSON_VALUE_MAX_LENGTH = 4000;

    private SQLServerAggregateSupport() {
    }

    public static AggregateSupport valueOf(Dialect dialect) {
        return dialect.getVersion().isSameOrAfter(13) ? INSTANCE : AggregateSupportImpl.INSTANCE;
    }

    @Override
    public String aggregateComponentCustomReadExpression(String template, String placeholder, String aggregateParentReadExpression, String columnExpression, int aggregateColumnTypeCode, SqlTypedMapping column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                String parentPartExpression = aggregateParentReadExpression.startsWith(JSON_QUERY_START) && aggregateParentReadExpression.endsWith(JSON_QUERY_JSON_END) ? aggregateParentReadExpression.substring(JSON_QUERY_START.length(), aggregateParentReadExpression.length() - JSON_QUERY_JSON_END.length()) + "." : aggregateParentReadExpression + ",'$.";
                switch (column.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode()) {
                    case 3001: 
                    case 3018: {
                        return template.replace(placeholder, JSON_QUERY_START + parentPartExpression + columnExpression + JSON_QUERY_JSON_END);
                    }
                    case -3: 
                    case -2: 
                    case 2004: 
                    case 4003: {
                        if (SQLServerAggregateSupport.determineLength(column) * 2L > 4000L) {
                            return template.replace(placeholder, "(select convert(" + column.getColumnDefinition() + ",v,2) from openjson(" + aggregateParentReadExpression + ") with (v varchar(max) '$." + columnExpression + "'))");
                        }
                        return template.replace(placeholder, "convert(" + column.getColumnDefinition() + ",json_value(" + parentPartExpression + columnExpression + "'),2)");
                    }
                    case -15: 
                    case -9: 
                    case 1: 
                    case 12: 
                    case 2005: 
                    case 2011: 
                    case 4001: 
                    case 4002: {
                        if (SQLServerAggregateSupport.determineLength(column) > 4000L) {
                            return template.replace(placeholder, "(select * from openjson(" + aggregateParentReadExpression + ") with (v " + column.getColumnDefinition() + " '$." + columnExpression + "'))");
                        }
                    }
                    case -7: 
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 2013: 
                    case 2014: 
                    case 3003: 
                    case 3007: {
                        return template.replace(placeholder, "cast(json_value(" + parentPartExpression + columnExpression + "') as " + column.getColumnDefinition() + ")");
                    }
                }
                return template.replace(placeholder, "(select * from openjson(" + aggregateParentReadExpression + ") with (v " + column.getColumnDefinition() + " '$." + columnExpression + "'))");
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private static Long determineLength(SqlTypedMapping column) {
        Long length = column.getLength();
        if (length != null) {
            return length;
        }
        String columnDefinition = column.getColumnDefinition();
        assert (columnDefinition != null);
        int parenthesisIndex = columnDefinition.indexOf(40);
        if (parenthesisIndex != -1) {
            int end;
            for (end = parenthesisIndex + 1; end < columnDefinition.length() && Character.isDigit(columnDefinition.charAt(end)); ++end) {
            }
            return Long.parseLong(columnDefinition.substring(parenthesisIndex + 1, end));
        }
        return 8000L;
    }

    @Override
    public String aggregateComponentAssignmentExpression(String aggregateParentAssignmentExpression, String columnExpression, int aggregateColumnTypeCode, Column column) {
        switch (aggregateColumnTypeCode) {
            case 3001: 
            case 3018: {
                return aggregateParentAssignmentExpression;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateColumnTypeCode);
    }

    private String jsonCustomWriteExpression(String customWriteExpression, JdbcMapping jdbcMapping, SelectableMapping column, TypeConfiguration typeConfiguration) {
        switch (jdbcMapping.getJdbcType().getDefaultSqlTypeCode()) {
            case -3: 
            case -2: 
            case 2004: 
            case 4003: {
                return "convert(nvarchar(max)," + customWriteExpression + ",2)";
            }
            case 92: {
                return "left(" + customWriteExpression + ",8)";
            }
            case 91: {
                return "format(" + customWriteExpression + ",'yyyy-MM-dd')";
            }
            case 93: {
                return "format(" + customWriteExpression + ",'yyyy-MM-ddTHH:mm:ss.fffffff')";
            }
            case 2014: 
            case 3003: {
                return "format(" + customWriteExpression + ",'yyyy-MM-ddTHH:mm:ss.fffffffzzz')";
            }
            case 3000: {
                return "cast(" + customWriteExpression + " as nvarchar(36))";
            }
            case 3001: 
            case 3018: {
                return JSON_QUERY_START + customWriteExpression + ")";
            }
        }
        return customWriteExpression;
    }

    private static String determineElementTypeName(Size castTargetSize, BasicPluralType<?, ?> pluralType, TypeConfiguration typeConfiguration) {
        BasicType<?> expressionType;
        DdlTypeRegistry ddlTypeRegistry = typeConfiguration.getDdlTypeRegistry();
        DdlType ddlType = ddlTypeRegistry.getDescriptor((expressionType = pluralType.getElementType()).getJdbcType().getDdlTypeCode());
        if (ddlType == null) {
            ddlType = ddlTypeRegistry.getDescriptor(4);
        }
        return ddlType.getTypeName(castTargetSize, expressionType, ddlTypeRegistry);
    }

    @Override
    public boolean requiresAggregateCustomWriteExpressionRenderer(int aggregateSqlTypeCode) {
        return aggregateSqlTypeCode == 3001;
    }

    @Override
    public AggregateSupport.WriteExpressionRenderer aggregateCustomWriteExpressionRenderer(SelectableMapping aggregateColumn, SelectableMapping[] columnsToUpdate, TypeConfiguration typeConfiguration) {
        int aggregateSqlTypeCode = aggregateColumn.getJdbcMapping().getJdbcType().getDefaultSqlTypeCode();
        switch (aggregateSqlTypeCode) {
            case 3001: {
                return this.jsonAggregateColumnWriter(aggregateColumn, columnsToUpdate, typeConfiguration);
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate SQL type: " + aggregateSqlTypeCode);
    }

    private AggregateSupport.WriteExpressionRenderer jsonAggregateColumnWriter(SelectableMapping aggregateColumn, SelectableMapping[] columns, TypeConfiguration typeConfiguration) {
        return new RootJsonWriteExpression(aggregateColumn, columns, this, typeConfiguration);
    }

    private static class RootJsonWriteExpression
    extends AggregateJsonWriteExpression
    implements AggregateSupport.WriteExpressionRenderer {
        private final boolean nullable;
        private final String path;

        RootJsonWriteExpression(SelectableMapping aggregateColumn, SelectableMapping[] columns, SQLServerAggregateSupport aggregateSupport, TypeConfiguration typeConfiguration) {
            super(aggregateColumn, aggregateSupport);
            this.nullable = aggregateColumn.isNullable();
            this.path = aggregateColumn.getSelectionExpression();
            this.initializeSubExpressions(columns, aggregateSupport, typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression aggregateColumnWriteExpression, String qualifier) {
            Object basePath = qualifier == null || qualifier.isBlank() ? this.path : qualifier + "." + this.path;
            this.append(sqlAppender, (String)(this.nullable ? "coalesce(" + (String)basePath + ",'{}')" : basePath), translator, aggregateColumnWriteExpression);
        }
    }

    private static class BasicJsonWriteExpression
    implements JsonWriteExpression {
        private final SelectableMapping selectableMapping;
        private final String customWriteExpressionStart;
        private final String customWriteExpressionEnd;

        BasicJsonWriteExpression(SelectableMapping selectableMapping, String customWriteExpression) {
            this.selectableMapping = selectableMapping;
            if (customWriteExpression.equals("?")) {
                this.customWriteExpressionStart = "";
                this.customWriteExpressionEnd = "";
            } else {
                String[] parts = StringHelper.split("?", customWriteExpression);
                assert (parts.length == 2);
                this.customWriteExpressionStart = parts[0];
                this.customWriteExpressionEnd = parts[1];
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            sb.append(this.customWriteExpressionStart);
            translator.render(expression.getValueExpression(this.selectableMapping), SqlAstNodeRenderingMode.NO_UNTYPED);
            sb.append(this.customWriteExpressionEnd);
        }
    }

    private static class AggregateJsonWriteExpression
    implements JsonWriteExpression {
        private final LinkedHashMap<String, JsonWriteExpression> subExpressions = new LinkedHashMap();
        protected final EmbeddableMappingType embeddableMappingType;

        public AggregateJsonWriteExpression(SelectableMapping selectableMapping, SQLServerAggregateSupport aggregateSupport) {
            this.embeddableMappingType = ((AggregateJdbcType)selectableMapping.getJdbcMapping().getJdbcType()).getEmbeddableMappingType();
        }

        protected void initializeSubExpressions(SelectableMapping[] columns, SQLServerAggregateSupport aggregateSupport, TypeConfiguration typeConfiguration) {
            for (SelectableMapping column : columns) {
                SelectablePath selectablePath = column.getSelectablePath();
                SelectablePath[] parts = selectablePath.getParts();
                AggregateJsonWriteExpression currentAggregate = this;
                EmbeddableMappingType currentMappingType = this.embeddableMappingType;
                for (int i = 1; i < parts.length - 1; ++i) {
                    SelectableMapping selectableMapping = currentMappingType.getJdbcValueSelectable(currentMappingType.getSelectableIndex(parts[i].getSelectableName()));
                    currentAggregate = (AggregateJsonWriteExpression)currentAggregate.subExpressions.computeIfAbsent(parts[i].getSelectableName(), k -> new AggregateJsonWriteExpression(selectableMapping, aggregateSupport));
                    currentMappingType = currentAggregate.embeddableMappingType;
                }
                String customWriteExpression = column.getWriteExpression();
                currentAggregate.subExpressions.put(parts[parts.length - 1].getSelectableName(), new BasicJsonWriteExpression(column, aggregateSupport.jsonCustomWriteExpression(customWriteExpression, column.getJdbcMapping(), column, typeConfiguration)));
            }
        }

        @Override
        public void append(SqlAppender sb, String path, SqlAstTranslator<?> translator, AggregateSupport.AggregateColumnWriteExpression expression) {
            for (int i = 0; i < this.subExpressions.size() - 1; ++i) {
                sb.append("json_modify(");
            }
            sb.append("json_modify(");
            sb.append(path);
            for (Map.Entry<String, JsonWriteExpression> entry : this.subExpressions.entrySet()) {
                String column = entry.getKey();
                JsonWriteExpression value = entry.getValue();
                String subPath = SQLServerAggregateSupport.JSON_QUERY_START + path + ",'$." + column + SQLServerAggregateSupport.JSON_QUERY_JSON_END;
                sb.append(",'$.");
                sb.append(column);
                sb.append("',");
                if (value instanceof AggregateJsonWriteExpression) {
                    value.append(sb, subPath, translator, expression);
                } else {
                    value.append(sb, subPath, translator, expression);
                }
                sb.append(')');
            }
        }
    }

    static interface JsonWriteExpression {
        public void append(SqlAppender var1, String var2, SqlAstTranslator<?> var3, AggregateSupport.AggregateColumnWriteExpression var4);
    }
}

