/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.FunctionRenderer;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.type.BasicType;

public class CastFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;
    private final CastType booleanCastType;

    public CastFunction(Dialect dialect, int preferredSqlTypeCodeForBoolean) {
        super("cast", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.useArgType(2), StandardFunctionArgumentTypeResolvers.IMPLIED_RESULT_TYPE);
        this.dialect = dialect;
        this.booleanCastType = this.getBooleanCastType(preferredSqlTypeCodeForBoolean);
    }

    private CastType getBooleanCastType(int preferredSqlTypeCodeForBoolean) {
        return switch (preferredSqlTypeCodeForBoolean) {
            case -7, -6, 5 -> CastType.INTEGER_BOOLEAN;
            default -> CastType.BOOLEAN;
        };
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        Expression source = (Expression)arguments.get(0);
        JdbcMapping sourceMapping = source.getExpressionType().getSingleJdbcMapping();
        CastType sourceType = this.getCastType(sourceMapping);
        CastTarget castTarget = (CastTarget)arguments.get(1);
        JdbcMapping targetJdbcMapping = castTarget.getExpressionType().getSingleJdbcMapping();
        CastType targetType = this.getCastType(targetJdbcMapping);
        if (sourceType == CastType.OTHER && targetType == CastType.STRING && sourceMapping.getJdbcType().isArray()) {
            CastFunction.renderCastArrayToString(sqlAppender, arguments.get(0), this.dialect, walker);
        } else {
            new PatternRenderer(this.dialect.castPattern(sourceType, targetType)).render(sqlAppender, arguments, walker);
        }
    }

    public static void renderCastArrayToString(SqlAppender sqlAppender, SqlAstNode arrayArgument, Dialect dialect, SqlAstTranslator<?> walker) {
        SessionFactoryImplementor sessionFactory = walker.getSessionFactory();
        BasicType<String> stringType = sessionFactory.getTypeConfiguration().getBasicTypeForJavaType(String.class);
        SqmFunctionRegistry functionRegistry = sessionFactory.getQueryEngine().getSqmFunctionRegistry();
        FunctionRenderer concatDescriptor = (FunctionRenderer)((Object)functionRegistry.findFunctionDescriptor("concat"));
        FunctionRenderer arrayToStringDescriptor = (FunctionRenderer)((Object)functionRegistry.findFunctionDescriptor("array_to_string"));
        boolean caseWhen = dialect.isEmptyStringTreatedAsNull();
        if (caseWhen) {
            sqlAppender.append("case when ");
            arrayArgument.accept(walker);
            sqlAppender.append(" is null then null else ");
        }
        concatDescriptor.render(sqlAppender, List.of(new QueryLiteral<String>("[", stringType), new SelfRenderingFunctionSqlAstExpression("array_to_string", arrayToStringDescriptor, List.of(arrayArgument, new QueryLiteral<String>(",", stringType), new QueryLiteral<String>("null", stringType)), stringType, stringType), new QueryLiteral<String>("]", stringType)), stringType, walker);
        if (caseWhen) {
            sqlAppender.append(" end");
        }
    }

    private CastType getCastType(JdbcMapping sourceMapping) {
        CastType castType = sourceMapping.getCastType();
        return castType == CastType.BOOLEAN ? this.booleanCastType : castType;
    }

    @Override
    public String getArgumentListSignature() {
        return "(arg as Type)";
    }
}

