/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import java.util.Locale;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionArgumentException;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class GenerateSeriesArgumentValidator
implements ArgumentsValidator {
    private final ArgumentsValidator delegate = StandardArgumentsValidators.between(2, 3);

    @Override
    public void validate(List<? extends SqmTypedNode<?>> arguments, String functionName, TypeConfiguration typeConfiguration) {
        DomainType<?> stepType;
        this.delegate.validate(arguments, functionName, typeConfiguration);
        SqmTypedNode<?> start = arguments.get(0);
        SqmTypedNode<?> stop = arguments.get(1);
        SqmTypedNode<?> step = arguments.size() > 2 ? arguments.get(2) : null;
        SqmExpressible<?> startExpressible = start.getExpressible();
        SqmExpressible<?> stopExpressible = stop.getExpressible();
        SqmExpressible<?> stepExpressible = step == null ? null : step.getExpressible();
        DomainType<?> startType = startExpressible == null ? null : startExpressible.getSqmType();
        DomainType<?> stopType = stopExpressible == null ? null : stopExpressible.getSqmType();
        DomainType<?> domainType = stepType = stepExpressible == null ? null : stepExpressible.getSqmType();
        if (startType == null) {
            throw this.unknownType(functionName, arguments, 0);
        }
        if (stopType == null) {
            throw this.unknownType(functionName, arguments, 1);
        }
        if (startType != stopType) {
            throw new FunctionArgumentException(String.format("Start and stop parameters of function '%s()' must be of the same type, but found [%s,%s]", functionName, startType.getTypeName(), stopType.getTypeName()));
        }
        JdbcMapping type = (JdbcMapping)((Object)startType);
        JdbcType jdbcType = type.getJdbcType();
        if (jdbcType.isInteger() || jdbcType.isDecimal()) {
            if (step != null) {
                if (stepType == null) {
                    throw this.unknownType(functionName, arguments, 2);
                }
                if (stepType != startType) {
                    throw new FunctionArgumentException(String.format("Step parameter of function '%s()' is of type '%s', but must be of the same type as start and stop [%s,%s]", functionName, stepType.getTypeName(), startType.getTypeName(), stopType.getTypeName()));
                }
            }
        } else if (jdbcType.isTemporal()) {
            if (step == null) {
                throw new FunctionArgumentException(String.format(Locale.ROOT, "Function %s() requires exactly 3 arguments when invoked with a temporal argument, but %d arguments given", functionName, arguments.size()));
            }
            if (stepType == null) {
                throw this.unknownType(functionName, arguments, 2);
            }
            JdbcType stepJdbcType = ((JdbcMapping)((Object)stepType)).getJdbcType();
            if (!stepJdbcType.isInterval() && !stepJdbcType.isDuration()) {
                throw new FunctionArgumentException(String.format("Step parameter of function '%s()' is of type '%s', but must be of type interval", functionName, stepType.getTypeName()));
            }
        } else {
            throw new FunctionArgumentException(String.format("Unsupported type '%s' for function '%s()'. Only integral, decimal and timestamp types are supported.", startType.getTypeName(), functionName));
        }
    }

    private FunctionArgumentException unknownType(String functionName, List<? extends SqmTypedNode<?>> arguments, int parameterIndex) {
        return new FunctionArgumentException(String.format("Couldn't determine type of parameter %d of function '%s()'. Argument is '%s'", parameterIndex, functionName, arguments.get(parameterIndex)));
    }
}

