/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.NumberSeriesGenerateSeriesFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.spi.TypeConfiguration;

public class SQLServerGenerateSeriesFunction
extends NumberSeriesGenerateSeriesFunction {
    public SQLServerGenerateSeriesFunction(int maxSeriesSize, TypeConfiguration typeConfiguration) {
        super((SetReturningFunctionTypeResolver)new SQLServerGenerateSeriesSetReturningFunctionTypeResolver(), typeConfiguration.getBasicTypeRegistry().resolve(java.time.Duration.class, 3015), maxSeriesSize);
    }

    @Override
    public boolean rendersIdentifierVariable(List<SqlAstNode> arguments, SessionFactoryImplementor sessionFactory) {
        return true;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                ModelPart elementPart = functionTableGroup.getModelPart().findSubPart(CollectionPart.Nature.ELEMENT.getName(), null);
                boolean isTemporal = elementPart.getSingleJdbcMapping().getJdbcType().isTemporal();
                if (withOrdinality || isTemporal) {
                    walker.registerQueryTransformer(new NumberSeriesGenerateSeriesFunction.NumberSeriesQueryTransformer(functionTableGroup, functionTableGroup, "value", SQLServerGenerateSeriesFunction.this.coerceToTimestamp));
                }
                return functionTableGroup;
            }
        };
    }

    @Override
    protected void renderGenerateSeries(SqlAppender sqlAppender, Expression start, Expression stop, @Nullable Expression step, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        ModelPart elementPart = tupleType.findSubPart(CollectionPart.Nature.ELEMENT.getName(), null);
        ModelPart ordinalityPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        boolean isTemporal = elementPart.getSingleJdbcMapping().getJdbcType().isTemporal();
        if (ordinalityPart != null || isTemporal) {
            boolean stepNeedsEmulation;
            boolean startNeedsEmulation = SQLServerGenerateSeriesFunction.needsVariable(start);
            boolean bl = stepNeedsEmulation = step != null && SQLServerGenerateSeriesFunction.needsVariable(step);
            if (startNeedsEmulation || stepNeedsEmulation) {
                sqlAppender.appendSql("((values ");
                int separator = 40;
                if (startNeedsEmulation) {
                    sqlAppender.appendSql((char)separator);
                    start.accept(walker);
                    separator = 44;
                }
                if (stepNeedsEmulation) {
                    sqlAppender.appendSql((char)separator);
                    if (step instanceof Duration) {
                        Duration duration = (Duration)step;
                        duration.getMagnitude().accept(walker);
                    } else {
                        step.accept(walker);
                    }
                }
                sqlAppender.appendSql(")) ");
                sqlAppender.appendSql(tableIdentifierVariable);
                sqlAppender.appendSql("_");
                separator = 40;
                if (startNeedsEmulation) {
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql("b");
                    separator = 44;
                }
                if (stepNeedsEmulation) {
                    sqlAppender.appendSql((char)separator);
                    sqlAppender.appendSql("s");
                }
                sqlAppender.appendSql(") join ");
            }
            sqlAppender.appendSql("generate_series(1,");
            sqlAppender.appendSql(this.maxSeriesSize);
            sqlAppender.appendSql(") ");
            sqlAppender.appendSql(tableIdentifierVariable);
            if (startNeedsEmulation || stepNeedsEmulation) {
                sqlAppender.appendSql(" on 1=1)");
            }
        } else {
            sqlAppender.appendSql("generate_series(");
            start.accept(walker);
            sqlAppender.appendSql(',');
            stop.accept(walker);
            if (step != null) {
                sqlAppender.appendSql(',');
                step.accept(walker);
            }
            sqlAppender.appendSql(") ");
            sqlAppender.appendSql(tableIdentifierVariable);
        }
    }

    private static class SQLServerGenerateSeriesSetReturningFunctionTypeResolver
    extends NumberSeriesGenerateSeriesFunction.NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver {
        public SQLServerGenerateSeriesSetReturningFunctionTypeResolver() {
            super("value", "value");
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            Expression start = (Expression)arguments.get(0);
            Expression stop = (Expression)arguments.get(1);
            JdbcMappingContainer expressionType = NullnessHelper.coalesce(start.getExpressionType(), stop.getExpressionType());
            JdbcMapping type = expressionType.getSingleJdbcMapping();
            if (type == null) {
                throw new IllegalArgumentException("Couldn't determine types of arguments to function 'generate_series'");
            }
            if (withOrdinality || type.getJdbcType().isTemporal()) {
                return this.resolveIterationVariableBasedFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
            }
            return super.resolveFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
        }
    }
}

