/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.dialect.function.DateTruncEmulation;
import org.hibernate.dialect.function.TruncFunction;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlServerConvertTruncFunction
extends TruncFunction {
    private final DateTruncConvertEmulation dateTruncEmulation;

    public SqlServerConvertTruncFunction(TypeConfiguration typeConfiguration) {
        super("round(?1,0,1)", "round(?1,?2,1)", null, null, typeConfiguration);
        this.dateTruncEmulation = new DateTruncConvertEmulation(typeConfiguration);
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<? extends SqmTypedNode<?>> arguments, ReturnableType<T> impliedResultType, QueryEngine queryEngine) {
        ArrayList args = new ArrayList(arguments);
        if (arguments.size() == 2 && arguments.get(1) instanceof SqmExtractUnit) {
            return this.dateTruncEmulation.generateSqmExpression(arguments, impliedResultType, queryEngine);
        }
        return new SelfRenderingSqmFunction<T>(this, this.numericRenderingSupport, args, impliedResultType, TruncFunction.TruncArgumentsValidator.NUMERIC_VALIDATOR, this.getReturnTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName());
    }

    private static class DateTruncConvertEmulation
    extends DateTruncEmulation {
        public DateTruncConvertEmulation(TypeConfiguration typeConfiguration) {
            super("convert", typeConfiguration);
        }

        @Override
        public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
            sqlAppender.appendSql(this.toDateFunction);
            sqlAppender.append('(');
            sqlAppender.append("datetime,");
            sqlAstArguments.get(1).accept(walker);
            sqlAppender.append(')');
        }
    }
}

