/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.dialect.function.NumberSeriesGenerateSeriesFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.derived.AnonymousTupleTableGroupProducer;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.function.SelfRenderingSqmSetReturningFunction;
import org.hibernate.query.sqm.produce.function.SetReturningFunctionTypeResolver;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.FunctionTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.type.spi.TypeConfiguration;

public class SybaseASEGenerateSeriesFunction
extends NumberSeriesGenerateSeriesFunction {
    public SybaseASEGenerateSeriesFunction(int maxSeriesSize, TypeConfiguration typeConfiguration) {
        super((SetReturningFunctionTypeResolver)new SybaseASEGenerateSeriesSetReturningFunctionTypeResolver(), typeConfiguration.getBasicTypeRegistry().resolve(java.time.Duration.class, 3015), maxSeriesSize);
    }

    @Override
    public boolean rendersIdentifierVariable(List<SqlAstNode> arguments, SessionFactoryImplementor sessionFactory) {
        return true;
    }

    @Override
    protected <T> SelfRenderingSqmSetReturningFunction<T> generateSqmSetReturningFunctionExpression(List<? extends SqmTypedNode<?>> arguments, QueryEngine queryEngine) {
        return new SelfRenderingSqmSetReturningFunction<T>(this, this, arguments, this.getArgumentsValidator(), this.getSetReturningTypeResolver(), queryEngine.getCriteriaBuilder(), this.getName()){

            @Override
            public TableGroup convertToSqlAst(NavigablePath navigablePath, String identifierVariable, boolean lateral, boolean canUseInnerJoins, boolean withOrdinality, SqmToSqlAstConverter walker) {
                FunctionTableGroup functionTableGroup = (FunctionTableGroup)super.convertToSqlAst(navigablePath, identifierVariable, lateral, canUseInnerJoins, withOrdinality, walker);
                walker.registerQueryTransformer(new NumberSeriesGenerateSeriesFunction.NumberSeriesQueryTransformer(functionTableGroup, functionTableGroup, "i", SybaseASEGenerateSeriesFunction.this.coerceToTimestamp));
                return functionTableGroup;
            }
        };
    }

    @Override
    protected void renderGenerateSeries(SqlAppender sqlAppender, Expression start, Expression stop, @Nullable Expression step, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstTranslator<?> walker) {
        boolean stepNeedsEmulation;
        boolean startNeedsEmulation = SybaseASEGenerateSeriesFunction.needsVariable(start);
        boolean bl = stepNeedsEmulation = step != null && SybaseASEGenerateSeriesFunction.needsVariable(step);
        if (startNeedsEmulation || stepNeedsEmulation) {
            sqlAppender.appendSql("((select");
            int separator = 32;
            if (startNeedsEmulation) {
                sqlAppender.appendSql((char)separator);
                start.accept(walker);
                separator = 44;
            }
            if (stepNeedsEmulation) {
                sqlAppender.appendSql((char)separator);
                if (step instanceof Duration) {
                    Duration duration = (Duration)step;
                    duration.getMagnitude().accept(walker);
                } else {
                    step.accept(walker);
                }
            }
            sqlAppender.appendSql(") ");
            sqlAppender.appendSql(tableIdentifierVariable);
            sqlAppender.appendSql("_");
            separator = 40;
            if (startNeedsEmulation) {
                sqlAppender.appendSql((char)separator);
                sqlAppender.appendSql("b");
                separator = 44;
            }
            if (stepNeedsEmulation) {
                sqlAppender.appendSql((char)separator);
                sqlAppender.appendSql("s");
            }
            sqlAppender.appendSql(") join ");
        }
        sqlAppender.appendSql("xmltable('/r/a' passing '<r>'+replicate('<a/>',");
        sqlAppender.appendSql(this.maxSeriesSize);
        sqlAppender.appendSql(")+'</r>' columns i bigint for ordinality, v varchar(255) path '.') ");
        sqlAppender.appendSql(tableIdentifierVariable);
        if (startNeedsEmulation || stepNeedsEmulation) {
            sqlAppender.appendSql(" on 1=1)");
        }
    }

    private static class SybaseASEGenerateSeriesSetReturningFunctionTypeResolver
    extends NumberSeriesGenerateSeriesFunction.NumberSeriesGenerateSeriesSetReturningFunctionTypeResolver {
        public SybaseASEGenerateSeriesSetReturningFunctionTypeResolver() {
            super("v", "i");
        }

        @Override
        public SelectableMapping[] resolveFunctionReturnType(List<? extends SqlAstNode> arguments, String tableIdentifierVariable, boolean lateral, boolean withOrdinality, SqmToSqlAstConverter converter) {
            return this.resolveIterationVariableBasedFunctionReturnType(arguments, tableIdentifierVariable, lateral, withOrdinality, converter);
        }
    }
}

